/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStyle;
import oracle.dbtools.raptor.datatypes.CallableBindingSplitMode;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataParameter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.CallableBindingImpl;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingSplit;
import oracle.dbtools.raptor.datatypes.values.DataValueMapped;

public class CallableBindingBOOLEAN<P extends DataBinding>
extends CallableBindingImpl<P>
implements CallableBindingSplitMode<P> {
    protected final BindContext context;
    private final CallableBindingSplit<P> splitBinding;
    private CallableStatement stmt = null;
    private static final String BOOL2INT = "FUNCTION bool2int(b BOOLEAN)RETURN NUMBER AS BEGIN IF (b IS NULL)THEN RETURN NULL;ELSE CASE b WHEN true THEN RETURN 1;ELSE RETURN 0;END CASE;END IF;END bool2int;";
    private static final String INT2BOOL = "FUNCTION int2bool(i NUMBER)RETURN BOOLEAN AS BEGIN IF (i IS NULL)THEN RETURN NULL;ELSE RETURN (i <> 0);END IF;END int2bool;";

    public CallableBindingBOOLEAN(BindContext bindContext, P p, DataType dataType) {
        super(p);
        this.context = bindContext;
        this.splitBinding = new CallableBindingSplit<P>(bindContext, (DataBinding)p, dataType){

            @Override
            public PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder pLSQLBoundBlockBuilder) {
                boolean bl = false;
                boolean bl2 = false;
                String string = this.getParameter().getName();
                DataType dataType = this.param.getDataType();
                BindingMode bindingMode = this.param.getMode();
                if (this.param instanceof DataParameter) {
                    switch (bindingMode) {
                        case RETURN: {
                            pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.PreCallWrapper, "%s := bool2int(", this.getBindToken(bindingMode));
                            pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.PostCallWrapper, ")");
                            bl = true;
                            break;
                        }
                        case IN: {
                            pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.ParamBinding, string + "=>int2bool(%s)", this.getBindToken(bindingMode));
                            bl2 = true;
                            break;
                        }
                        case IN_OUT: {
                            pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.PreCallBlocks, string + " := int2bool(%s);", this.inDatum.getBindToken(this.inDatum.getMode()));
                            bl2 = true;
                        }
                        case OUT: {
                            pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.DataDecls, string + " " + dataType.getConstrainedDataTypeString() + ";");
                            pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.ParamBinding, string + "=>" + string);
                            pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.PostCallBlocks, "%s := bool2int(" + string + ");", this.getBindToken(bindingMode));
                            bl = true;
                        }
                    }
                } else {
                    switch (bindingMode) {
                        case IN: {
                            pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.PreCallBlocks, string + " := int2bool(%s);", this.getBindToken(bindingMode));
                            bl2 = true;
                            break;
                        }
                        case IN_OUT: {
                            pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.PreCallBlocks, string + " := int2bool(%s);", this.inDatum.getBindToken(this.inDatum.getMode()));
                            bl2 = true;
                        }
                        case OUT: {
                            pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.PostCallBlocks, "%s := bool2int(" + string + ");", this.getBindToken(bindingMode));
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.StdProcDecls, CallableBindingBOOLEAN.BOOL2INT);
                }
                if (bl2) {
                    pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.StdProcDecls, CallableBindingBOOLEAN.INT2BOOL);
                }
                return pLSQLBoundBlockBuilder;
            }
        };
    }

    @Override
    public void setByNameBindToken(String string) {
        this.splitBinding.setByNameBindToken(string);
    }

    @Override
    public String getByNameBindToken() {
        return this.splitBinding.getByNameBindToken();
    }

    @Override
    public void setByPositionBindToken(String string) {
        this.splitBinding.setByPositionBindToken(string);
    }

    @Override
    public String getByPositionBindToken() {
        return this.splitBinding.getByPositionBindToken();
    }

    @Override
    public BindingStyle getBindingStyle(BindingMode bindingMode) {
        return this.splitBinding.getBindingStyle(bindingMode);
    }

    @Override
    public String getBindToken(BindingMode bindingMode) {
        return this.splitBinding.getBindToken(bindingMode);
    }

    @Override
    protected void customBind(DataValue dataValue) throws SQLException {
        this.inputValue = dataValue;
        DataValue dataValue2 = dataValue instanceof DataValueMapped ? ((DataValueMapped)dataValue).getBindingDataValue() : dataValue;
        this.splitBinding.bind(this.stmt, dataValue2);
    }

    @Override
    public CallableStatement getCallableStatement() {
        return this.stmt;
    }

    @Override
    protected void setCallableStatement(CallableStatement callableStatement) {
        this.stmt = callableStatement;
    }

    @Override
    protected void customBindIN(DataValue dataValue) throws SQLException {
    }

    @Override
    public void customReportBinding(StringBuilder stringBuilder, String string, DataValue dataValue) {
        DataValue dataValue2 = dataValue.getBindingDataValue();
        this.splitBinding.customReportBinding(stringBuilder, string, dataValue2);
    }

    @Override
    public PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder pLSQLBoundBlockBuilder) {
        return this.splitBinding.customBuilder(pLSQLBoundBlockBuilder);
    }

    @Override
    protected void customBind() throws SQLException {
        this.splitBinding.bind(this.stmt);
    }

    @Override
    protected void customBindOUT() throws SQLException {
    }

    @Override
    protected DataValue customOutput() throws SQLException {
        if (this.outputValue == null) {
            DataValue dataValue = this.splitBinding.getOutput();
            this.outputValue = this.dataType.getDataValue(dataValue.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DEFAULT));
        }
        return this.outputValue;
    }

    @Override
    protected CallableBindingSplitMode<P> customSplitModeBinding() {
        return this;
    }
}

