/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LargeBinary;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.sql.Datum;

public class LongBinary
extends LargeBinary {
    public LongBinary() {
    }

    protected LongBinary(LongBinary longBinary) {
        super(longBinary);
    }

    protected LongBinary(Object object) {
        super(object);
    }

    public LongBinary(byte[] byArray) {
        super(byArray);
    }

    public LongBinary(File file) {
        super(file);
    }

    public LongBinary(InputStream inputStream) throws IOException {
        this(inputStream, 32768);
    }

    public LongBinary(InputStream inputStream, int n) throws IOException {
        this(LongBinary.getBuilder(EncodingType.ENCODING_NONE, n).write(inputStream).build());
    }

    public LongBinary(CharSequence charSequence) throws IOException, EncodingException {
        this(charSequence, 32768);
    }

    public LongBinary(CharSequence charSequence, int n) throws IOException, EncodingException {
        this(LongBinary.getBuilder(EncodingType.ENCODING_HEX, n).write(new StringReader(((Object)charSequence).toString())).build());
    }

    public LongBinary(char[] cArray) throws IOException, EncodingException {
        this(cArray, 32768);
    }

    public LongBinary(char[] cArray, int n) throws IOException, EncodingException {
        this(LongBinary.getBuilder(EncodingType.ENCODING_HEX, n).write(new CharArrayReader(cArray)).build());
    }

    public LongBinary(Reader reader) throws IOException, EncodingException {
        this(reader, 32768);
    }

    public LongBinary(Reader reader, int n) throws IOException, EncodingException {
        this(LongBinary.getBuilder(EncodingType.ENCODING_HEX, n).write(reader).build());
    }

    public static LongBinary constructFrom(Object object) throws IOException, SQLException, EncodingException {
        return LongBinary.constructFrom(object, 32768);
    }

    public static LongBinary constructFrom(Object object, int n) throws IOException, SQLException, EncodingException {
        if (object instanceof byte[]) {
            return new LongBinary((byte[])object);
        }
        if (object instanceof InputStream) {
            return new LongBinary((InputStream)object, n);
        }
        if (object instanceof File) {
            return new LongBinary((File)object);
        }
        if (object instanceof char[]) {
            return new LongBinary((char[])object, n);
        }
        if (object instanceof CharSequence) {
            return new LongBinary((CharSequence)object, n);
        }
        if (object instanceof Reader) {
            return new LongBinary((Reader)object, n);
        }
        if (object instanceof Datum) {
            Datum datum = (Datum)object;
            return new LongBinary(datum.stringValue(), n);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long getLength() throws SQLException {
        if (this.getValue() instanceof File) {
            return ((File)this.getValue()).length();
        }
        if (this.getValue() instanceof byte[]) {
            return ((byte[])this.getValue()).length;
        }
        return 0L;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof LongBinary) {
            bl = super.equals(object);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void customFinalize(Object object, boolean bl) throws Throwable {
        try {
            if (bl && object instanceof File) {
                ((File)object).delete();
            }
        }
        finally {
            super.customFinalize(object, bl);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException, SQLException {
        if (this.getValue() instanceof File) {
            return new FileInputStream((File)this.getValue());
        }
        if (this.getValue() instanceof byte[]) {
            return new ByteArrayInputStream((byte[])this.getValue());
        }
        return null;
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType, Object object) throws IOException, SQLException {
        switch (valueType) {
            case JDBC: {
                return this.getInputStream();
            }
        }
        return super.customTypedValue(dataTypeConnectionProvider, valueType, object);
    }

    public static LongBinaryBuilder getBuilder() {
        return LongBinary.getBuilder(32768);
    }

    public static LongBinaryBuilder getBuilder(EncodingType encodingType, int n) {
        return new LongBinary().getBuilder0(encodingType, n);
    }

    public static LongBinaryBuilder getBuilder(EncodingType encodingType) {
        return LongBinary.getBuilder(encodingType, 32768);
    }

    public static LongBinaryBuilder getBuilder(int n) {
        return new LongBinary().getBuilder0(EncodingType.ENCODING_BASE64, n);
    }

    private LongBinaryBuilder getBuilder0(EncodingType encodingType, int n) {
        return new LongBinaryBuilder(encodingType, n);
    }

    public class LongBinaryBuilder
    extends LargeBinary.LargeBinaryBuilder {
        protected LongBinaryBuilder(EncodingType encodingType, int n) {
            super(encodingType, n);
        }

        @Override
        public LongBinary build() throws IOException {
            this.switchableStream.flush();
            this.switchableStream.close();
            if (LongBinary.this.getValue() != null && LongBinary.this.getValue() instanceof File) {
                File file = (File)LongBinary.this.getValue();
                file.setReadOnly();
            } else {
                LongBinary.this.setValue(((ByteArrayOutputStream)this.ostream).toByteArray(), false);
            }
            return LongBinary.this;
        }

        @Override
        public LongBinaryBuilder write(Reader reader) throws IOException, EncodingException {
            return (LongBinaryBuilder)super.write(reader);
        }

        @Override
        public LongBinaryBuilder write(InputStream inputStream) throws IOException {
            byte[] byArray = new byte[2400];
            int n = inputStream.read(byArray);
            while (n != -1) {
                this.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            return this;
        }

        @Override
        protected void cutOver() throws IOException {
            this.ostream.flush();
            this.ostream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)this.ostream).toByteArray());
            File file = File.createTempFile("sqldev", ".tmp");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            LargeBinary.copyBytes(byteArrayInputStream, fileOutputStream);
            LongBinary.this.setValue(file, true);
            this.ostream = fileOutputStream;
        }
    }
}

