/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LongVarchar;
import oracle.jdbc.OracleConnection;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class ClobDatum
extends LongVarchar {
    public ClobDatum() {
    }

    protected ClobDatum(ClobDatum clobDatum) {
        super(clobDatum);
    }

    protected ClobDatum(Object object) {
        super(object);
    }

    public ClobDatum(Clob clob) throws SQLException {
        super(clob);
    }

    public ClobDatum(CharSequence charSequence) {
        super(charSequence);
    }

    public ClobDatum(File file) {
        super(file);
    }

    public ClobDatum(Reader reader) throws IOException {
        new ClobDatum();
        this(ClobDatum.getBuilder().write(reader).build());
    }

    public ClobDatum(Reader reader, int n) throws IOException {
        new ClobDatum();
        this(ClobDatum.getBuilder(n).write(reader).build());
    }

    public static ClobDatum constructFrom(Object object) throws IOException, SQLException {
        if (object instanceof Clob) {
            return new ClobDatum((Clob)object);
        }
        if (object instanceof char[]) {
            return new ClobDatum(String.valueOf((char[])object));
        }
        if (object instanceof CharSequence) {
            return new ClobDatum((CharSequence)object);
        }
        if (object instanceof File) {
            return new ClobDatum((File)object);
        }
        if (object instanceof Reader) {
            return new ClobDatum((Reader)object);
        }
        if (object instanceof Datum) {
            Datum datum = (Datum)object;
            return new ClobDatum(datum.stringValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long getLength() throws SQLException {
        if (this.getValue() instanceof Clob) {
            Clob clob = (Clob)this.getValue();
            if (ClobDatum.isEmptyLob(clob)) {
                return 0L;
            }
            return ((Clob)this.getValue()).length();
        }
        return super.getLength();
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof ClobDatum) {
            bl = super.equals(object);
        }
        return bl;
    }

    @Override
    public Reader getReader() throws IOException, SQLException {
        if (this.getValue() instanceof Clob) {
            Clob clob = (Clob)this.getValue();
            if (ClobDatum.isEmptyLob(clob)) {
                return new StringReader("");
            }
            return clob.getCharacterStream();
        }
        return super.getReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object customTypedValue(DataTypeConnectionProvider dataTypeConnectionProvider, ValueType valueType, Object object) throws IOException, SQLException {
        Object object2 = this.getValue();
        switch (valueType) {
            case DATUM: {
                if (object2 instanceof Clob) {
                    return object2;
                }
                Clob clob = ClobDatum.getTemporaryClob(dataTypeConnectionProvider.getValidDataTypeConnection());
                ClobDatum.open(clob, 1);
                try {
                    Writer writer = clob.setCharacterStream(1L);
                    ClobDatum.copyCharacters(this.getReader(), writer);
                    writer.close();
                }
                finally {
                    try {
                        ClobDatum.close(clob);
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(ClobDatum.class.getName()).log(Level.WARNING, sQLException.getLocalizedMessage(), sQLException);
                    }
                }
                return clob;
            }
        }
        return super.customTypedValue(dataTypeConnectionProvider, valueType, object);
    }

    public static ClobDatumBuilder getBuilder() {
        return ClobDatum.getBuilder(32768);
    }

    private ClobDatumBuilder getBuilder0(int n) {
        return new ClobDatumBuilder(n);
    }

    public static ClobDatumBuilder getBuilder(int n) {
        return new ClobDatum().getBuilder0(n);
    }

    protected static Clob getTemporaryClob(Connection connection) throws SQLException {
        if (connection instanceof OracleConnection) {
            return CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
        }
        return connection.createClob();
    }

    protected static Clob getEmptyClob(Connection connection) throws SQLException {
        if (connection instanceof OracleConnection) {
            return CLOB.getEmptyCLOB();
        }
        return ClobDatum.getTemporaryClob(connection);
    }

    protected static boolean isEmptyLob(Clob clob) throws SQLException {
        if (clob instanceof CLOB) {
            return ((CLOB)clob).isEmptyLob();
        }
        return false;
    }

    protected static void open(Clob clob, int n) throws SQLException {
        CLOB cLOB;
        if (clob instanceof CLOB && !(cLOB = (CLOB)clob).isEmptyLob() && !cLOB.isOpen()) {
            cLOB.open(n);
        }
    }

    protected static void close(Clob clob) throws SQLException {
        CLOB cLOB;
        if (clob instanceof CLOB && !(cLOB = (CLOB)clob).isEmptyLob() && cLOB.isOpen()) {
            cLOB.close();
        }
    }

    protected static void free(Clob clob) throws SQLException {
        CLOB cLOB;
        if (clob instanceof CLOB && (cLOB = (CLOB)clob).isTemporary() && !cLOB.isOpen()) {
            cLOB.freeTemporary();
        }
        clob.free();
    }

    public class ClobDatumBuilder
    extends LongVarchar.LongVarcharBuilder {
        protected ClobDatumBuilder(int n) {
            super(ClobDatum.this, n);
        }

        @Override
        public ClobDatumBuilder write(Reader reader) throws IOException {
            return (ClobDatumBuilder)super.write(reader);
        }

        @Override
        public ClobDatum build() throws IOException {
            super.build();
            return ClobDatum.this;
        }
    }
}

