/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;

public class DataTypeConnectionProviderImpl<C extends Connection>
implements DataTypeConnectionProvider<C> {
    protected final Class<C> connectionClass;
    private WeakReference<C> connection;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String CONNECTION = "connection";

    public DataTypeConnectionProviderImpl(Class<C> clazz) {
        this(clazz, null);
    }

    public DataTypeConnectionProviderImpl(Class<C> clazz, C c) {
        this.connectionClass = clazz;
        this.connection = new WeakReference<C>(clazz.cast(c));
    }

    public DataTypeConnectionProviderImpl(C c) {
        this.connectionClass = c.getClass();
        this.connection = new WeakReference<C>(c);
    }

    protected C setDataTypeConnection(C c) {
        C c2 = this.peekDataTypeConnection();
        this.connection = new WeakReference<C>(this.connectionClass.cast(c));
        this.firePropertyChange(CONNECTION, c2, c);
        return c2;
    }

    protected C releaseDataTypeConnection(boolean bl) throws DataTypeConnectionException {
        C c = this.peekDataTypeConnection();
        try {
            if (bl && c != null && !c.isClosed()) {
                c.close();
            }
        }
        catch (SQLException sQLException) {
            throw new DataTypeConnectionException(sQLException);
        }
        return this.setDataTypeConnection(null);
    }

    @Override
    public C peekDataTypeConnection() {
        return (C)((Connection)this.connection.get());
    }

    @Override
    public C getDataTypeConnection() {
        return this.peekDataTypeConnection();
    }

    @Override
    public C getValidDataTypeConnection() {
        return this.getDataTypeConnection();
    }

    @Override
    public void unlockDataTypeConnection() throws DataTypeConnectionException {
    }

    @Override
    public C lockDataTypeConnection() throws DataTypeConnectionException {
        return this.lockDataTypeConnection(false);
    }

    @Override
    public C lockDataTypeConnection(boolean bl) throws DataTypeConnectionException {
        return this.getValidDataTypeConnection();
    }

    @Override
    public C getNLSConnection() {
        return this.getDataTypeConnection();
    }

    @Override
    public C peekNLSConnection() {
        return this.peekDataTypeConnection();
    }

    @Override
    public C getValidNLSConnection() throws DataTypeConnectionException {
        return this.getValidDataTypeConnection();
    }

    @Override
    public void unlockNLSConnection() throws DataTypeConnectionException {
    }

    @Override
    public C lockNLSConnection() throws DataTypeConnectionException {
        return this.lockNLSConnection(false);
    }

    @Override
    public C lockNLSConnection(boolean bl) throws DataTypeConnectionException {
        return this.getValidNLSConnection();
    }

    @Override
    public Class<C> getDataTypeConnnectionClass() {
        return this.connectionClass;
    }

    private static boolean areEquals(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }
}

