/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;

public class PLSQLBlockBuilder {
    public static final String IDENT = " ";
    protected ArrayList<LinkedList<String>> components;

    public PLSQLBlockBuilder() {
        int n = PLSQLBlockComponent.values().length;
        this.components = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.components.add(null);
        }
    }

    public void setComponent(PLSQLBlockComponent pLSQLBlockComponent, List<String> list) {
        LinkedList<String> linkedList = null;
        if (list != null) {
            linkedList = PLSQLBlockBuilder.addLists(pLSQLBlockComponent.getPrepend(), pLSQLBlockComponent.getUnique(), linkedList, list);
        }
        this.components.set(pLSQLBlockComponent.getSequence(), linkedList);
    }

    public void setComponent(PLSQLBlockComponent pLSQLBlockComponent, String[] stringArray) {
        LinkedList<String> linkedList = null;
        if (stringArray != null) {
            linkedList = PLSQLBlockBuilder.addLists(pLSQLBlockComponent.getPrepend(), pLSQLBlockComponent.getUnique(), linkedList, stringArray);
        }
        this.components.set(pLSQLBlockComponent.getSequence(), linkedList);
    }

    public List<String> getComponent(PLSQLBlockComponent pLSQLBlockComponent) {
        return this.components.get(pLSQLBlockComponent.getSequence());
    }

    public List<String> addComponent(PLSQLBlockComponent pLSQLBlockComponent, List<String> list) {
        LinkedList<String> linkedList = this.components.get(pLSQLBlockComponent.getSequence());
        linkedList = PLSQLBlockBuilder.addLists(pLSQLBlockComponent.getPrepend(), pLSQLBlockComponent.getUnique(), linkedList, list);
        this.components.set(pLSQLBlockComponent.getSequence(), linkedList);
        return linkedList;
    }

    public List<String> addComponent(PLSQLBlockComponent pLSQLBlockComponent, String[] stringArray) {
        LinkedList<String> linkedList = this.components.get(pLSQLBlockComponent.getSequence());
        linkedList = PLSQLBlockBuilder.addLists(pLSQLBlockComponent.getPrepend(), pLSQLBlockComponent.getUnique(), linkedList, stringArray);
        this.components.set(pLSQLBlockComponent.getSequence(), linkedList);
        return linkedList;
    }

    public List<String> addComponent(PLSQLBlockComponent pLSQLBlockComponent, String string) {
        LinkedList<String> linkedList = this.components.get(pLSQLBlockComponent.getSequence());
        if (string != null) {
            if (linkedList == null) {
                linkedList = new LinkedList();
                this.components.set(pLSQLBlockComponent.getSequence(), linkedList);
            }
            if (!pLSQLBlockComponent.getUnique() || !linkedList.contains(string)) {
                if (pLSQLBlockComponent.getPrepend()) {
                    linkedList.addFirst(string);
                } else {
                    linkedList.add(string);
                }
            }
        }
        return linkedList;
    }

    public List<String> addComponent(PLSQLBlockComponent pLSQLBlockComponent, StringBuffer stringBuffer) {
        return this.addComponent(pLSQLBlockComponent, stringBuffer != null ? stringBuffer.toString() : null);
    }

    public PLSQLBlockBuilder addBuilder(PLSQLBlockBuilder pLSQLBlockBuilder) {
        for (PLSQLBlockComponent pLSQLBlockComponent : PLSQLBlockComponent.values()) {
            int n = pLSQLBlockComponent.getSequence();
            boolean bl = pLSQLBlockComponent.getPrepend();
            boolean bl2 = pLSQLBlockComponent.getUnique();
            this.components.set(n, PLSQLBlockBuilder.addLists(bl, bl2, this.components.get(n), (List<String>)pLSQLBlockBuilder.components.get(n)));
        }
        return this;
    }

    private static LinkedList<String> addLists(boolean bl, boolean bl2, LinkedList<String> linkedList, String[] stringArray) {
        LinkedList<String> linkedList2 = linkedList;
        if (stringArray != null) {
            int n = 0;
            for (String string : stringArray) {
                if (bl2 && PLSQLBlockBuilder.contains(linkedList2, string)) continue;
                if (bl) {
                    linkedList2 = PLSQLBlockBuilder.add(linkedList2, n, string);
                    ++n;
                    continue;
                }
                linkedList2 = PLSQLBlockBuilder.add(linkedList2, string);
            }
        }
        return linkedList2;
    }

    private static LinkedList<String> addLists(boolean bl, boolean bl2, LinkedList<String> linkedList, List<String> list) {
        LinkedList<String> linkedList2 = linkedList;
        if (list != null) {
            if (!bl2) {
                linkedList2 = bl ? PLSQLBlockBuilder.addAll(linkedList2, 0, list) : PLSQLBlockBuilder.addAll(linkedList2, list);
            } else {
                int n = 0;
                for (String string : list) {
                    if (PLSQLBlockBuilder.contains(linkedList2, string)) continue;
                    if (bl) {
                        linkedList2 = PLSQLBlockBuilder.add(linkedList2, n, string);
                        ++n;
                        continue;
                    }
                    linkedList2 = PLSQLBlockBuilder.add(linkedList2, string);
                }
            }
        }
        return linkedList2;
    }

    private static boolean contains(LinkedList<String> linkedList, String string) {
        return linkedList != null && linkedList.contains(string);
    }

    private static LinkedList<String> add(LinkedList<String> linkedList, String string) {
        LinkedList<String> linkedList2 = linkedList == null ? new LinkedList<String>() : linkedList;
        linkedList2.add(string);
        return linkedList2;
    }

    private static LinkedList<String> add(LinkedList<String> linkedList, int n, String string) {
        LinkedList<String> linkedList2 = linkedList == null ? new LinkedList<String>() : linkedList;
        linkedList2.add(n, string);
        return linkedList2;
    }

    private static LinkedList<String> addAll(LinkedList<String> linkedList, Collection<String> collection) {
        LinkedList<String> linkedList2 = linkedList == null ? new LinkedList<String>() : linkedList;
        linkedList2.addAll(collection);
        return linkedList2;
    }

    private static LinkedList<String> addAll(LinkedList<String> linkedList, int n, Collection<String> collection) {
        LinkedList<String> linkedList2 = linkedList == null ? new LinkedList<String>() : linkedList;
        linkedList2.addAll(n, collection);
        return linkedList2;
    }

    public String generateSql() {
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = this.getComponent(PLSQLBlockComponent.Prototype);
        List<String> list2 = this.getComponent(PLSQLBlockComponent.DataDecls);
        List<String> list3 = this.getComponent(PLSQLBlockComponent.StdProcDecls);
        List<String> list4 = this.getComponent(PLSQLBlockComponent.ProcDecls);
        List<String> list5 = this.getComponent(PLSQLBlockComponent.DataInitBlocks);
        List<String> list6 = this.getComponent(PLSQLBlockComponent.PreCallBlocks);
        List<String> list7 = this.getComponent(PLSQLBlockComponent.PreCallWrapper);
        List<String> list8 = this.getComponent(PLSQLBlockComponent.Call);
        List<String> list9 = this.getComponent(PLSQLBlockComponent.ParamBinding);
        List<String> list10 = this.getComponent(PLSQLBlockComponent.PostCallWrapper);
        List<String> list11 = this.getComponent(PLSQLBlockComponent.PostCallBlocks);
        List<String> list12 = this.getComponent(PLSQLBlockComponent.OthersBlocks);
        int n = 0;
        if (list != null) {
            this.formatStatement(stringBuilder, n++, list);
            this.formatStatement(stringBuilder, n, list2);
            this.formatStatement(stringBuilder, n, list3);
            this.formatStatement(stringBuilder, n--, list4);
        } else if (list2 != null || list3 != null || list4 != null) {
            this.formatStatement(stringBuilder, n++, "DECLARE");
            this.formatStatement(stringBuilder, n, list2);
            this.formatStatement(stringBuilder, n, list3);
            this.formatStatement(stringBuilder, n--, list4);
        }
        this.formatStatement(stringBuilder, n++, "BEGIN");
        this.formatStatement(stringBuilder, n, list5);
        if (list12 != null) {
            this.formatStatement(stringBuilder, n++, "BEGIN");
        }
        this.formatStatement(stringBuilder, n, list6);
        if (list7 != null) {
            this.formatText(stringBuilder, n, list7);
        } else {
            this.formatText(stringBuilder, n, "");
        }
        this.formatText(stringBuilder, 0, list8);
        if (list9 != null) {
            this.formatText(stringBuilder, 0, "(");
            this.formatParameters(stringBuilder, n + 1, list9);
            this.formatText(stringBuilder, 0, ")");
        }
        if (list10 != null) {
            this.formatText(stringBuilder, 0, list10);
        }
        if (list7 != null || list8 != null || list9 != null || list10 != null) {
            this.formatStatement(stringBuilder, 0, ";");
        }
        this.formatStatement(stringBuilder, n, list11);
        if (list12 != null) {
            this.formatStatement(stringBuilder, --n, "EXCEPTION");
            this.formatStatement(stringBuilder, ++n, "WHEN OTHERS");
            this.formatStatement(stringBuilder, n++, "THEN");
            this.formatStatement(stringBuilder, n, list12);
            this.formatStatement(stringBuilder, --n, "END;");
        }
        this.formatStatement(stringBuilder, --n, "END;");
        return stringBuilder.toString();
    }

    protected StringBuilder formatStatement(StringBuilder stringBuilder, int n, List<String> list) {
        StringBuilder stringBuilder2 = stringBuilder;
        if (list != null) {
            for (String string : list) {
                stringBuilder2 = this.formatStatement(stringBuilder2, n, string);
            }
        }
        return stringBuilder2;
    }

    private StringBuilder formatStatement(StringBuilder stringBuilder, int n, String string) {
        if (string != null) {
            this.formatText(stringBuilder, n, string);
            stringBuilder.append('\n');
        }
        return stringBuilder;
    }

    protected StringBuilder formatText(StringBuilder stringBuilder, int n, List<String> list) {
        StringBuilder stringBuilder2 = stringBuilder;
        if (list != null) {
            for (String string : list) {
                stringBuilder2 = this.formatText(stringBuilder2, n, string);
            }
        }
        return stringBuilder2;
    }

    protected StringBuilder formatText(StringBuilder stringBuilder, int n, String string) {
        if (string != null) {
            this.formatIdent(stringBuilder, n);
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    protected StringBuilder formatParameters(StringBuilder stringBuilder, int n, List<String> list) {
        if (list != null) {
            int n2 = 0;
            for (String string : list) {
                if (string == null) continue;
                if (n2 > 0) {
                    stringBuilder.append(",");
                    if (n > 0) {
                        stringBuilder.append('\n');
                        this.formatIdent(stringBuilder, n);
                    } else {
                        stringBuilder.append(' ');
                    }
                }
                stringBuilder.append(string);
                ++n2;
            }
        }
        return stringBuilder;
    }

    protected StringBuilder formatIdent(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(IDENT);
        }
        return stringBuilder;
    }
}

