/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.editableheader;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.controls.grid.editableheader.EditableHeaderTableColumn;
import oracle.dbtools.raptor.controls.grid.editableheader.EditableHeaderUI;

public class EditableHeader
extends JTableHeader
implements CellEditorListener {
    public final int HEADER_ROW = -10;
    protected transient int editingColumn;
    protected transient TableCellEditor cellEditor;
    protected transient Component editorComp;

    public EditableHeader(TableColumnModel tableColumnModel, TableCellEditor tableCellEditor) {
        super(tableColumnModel);
        this.setReorderingAllowed(true);
        this.cellEditor = tableCellEditor;
        tableColumnModel.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                if (tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex() && EditableHeader.this.cellEditor != null) {
                    EditableHeader.this.cellEditor.cancelCellEditing();
                }
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
    }

    @Override
    public void updateUI() {
        this.setUI(new EditableHeaderUI());
        this.resizeAndRepaint();
        this.invalidate();
    }

    protected void recreateTableColumn(TableColumnModel tableColumnModel) {
        int n;
        int n2 = tableColumnModel.getColumnCount();
        EditableHeaderTableColumn[] editableHeaderTableColumnArray = new EditableHeaderTableColumn[n2];
        TableColumn[] tableColumnArray = new TableColumn[n2];
        for (n = 0; n < n2; ++n) {
            EditableHeaderTableColumn editableHeaderTableColumn;
            tableColumnArray[n] = tableColumnModel.getColumn(n);
            editableHeaderTableColumnArray[n] = editableHeaderTableColumn = new EditableHeaderTableColumn(this.cellEditor);
            editableHeaderTableColumnArray[n].copyValues(tableColumnArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            tableColumnModel.removeColumn(tableColumnArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            tableColumnModel.addColumn(editableHeaderTableColumnArray[n]);
        }
    }

    public boolean editCellAt(int n) {
        return this.editCellAt(n);
    }

    public boolean editCellAt(int n, EventObject eventObject) {
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (!this.isCellEditable(n)) {
            return false;
        }
        TableCellEditor tableCellEditor = this.getCellEditor(n);
        if (tableCellEditor != null && tableCellEditor.isCellEditable(eventObject)) {
            this.editorComp = this.prepareEditor(tableCellEditor, n);
            this.editorComp.setBounds(this.getHeaderRect(n));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.setCellEditor(tableCellEditor);
            this.setEditingColumn(n);
            tableCellEditor.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    public boolean isCellEditable(int n) {
        int n2 = this.columnModel.getColumn(n).getModelIndex();
        EditableHeaderTableColumn editableHeaderTableColumn = (EditableHeaderTableColumn)this.columnModel.getColumn(n2);
        return editableHeaderTableColumn.isHeaderEditable();
    }

    public TableCellEditor getCellEditor(int n) {
        int n2 = this.columnModel.getColumn(n).getModelIndex();
        EditableHeaderTableColumn editableHeaderTableColumn = (EditableHeaderTableColumn)this.columnModel.getColumn(n2);
        return editableHeaderTableColumn.getHeaderEditor();
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        TableCellEditor tableCellEditor2 = this.cellEditor;
        this.cellEditor = tableCellEditor;
        this.columnModel.getColumn(0).setCellEditor(tableCellEditor);
        this.columnModel.getColumn(1).setCellEditor(tableCellEditor);
        if (tableCellEditor2 != null && tableCellEditor2 instanceof TableCellEditor) {
            tableCellEditor2.removeCellEditorListener(this);
        }
        if (tableCellEditor != null && tableCellEditor instanceof TableCellEditor) {
            tableCellEditor.addCellEditorListener(this);
        }
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n) {
        Object object = this.columnModel.getColumn(n).getHeaderValue();
        boolean bl = true;
        int n2 = -10;
        JTable jTable = this.getTable();
        Component component = tableCellEditor.getTableCellEditorComponent(jTable, object, bl, n2, n);
        if (component instanceof JComponent) {
            ((JComponent)component).setNextFocusableComponent(this);
        }
        return component;
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public void setEditingColumn(int n) {
        this.editingColumn = n;
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public void removeEditor() {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.removeCellEditorListener(this);
            this.requestFocus();
            this.remove(this.editorComp);
            int n = this.getEditingColumn();
            Rectangle rectangle = this.getHeaderRect(n);
            this.setCellEditor(null);
            this.setEditingColumn(-1);
            this.editorComp = null;
            this.repaint(rectangle);
        }
    }

    public boolean isEditing() {
        return this.cellEditor != null;
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            Object object = tableCellEditor.getCellEditorValue();
            int n = this.getEditingColumn();
            this.columnModel.getColumn(n).setHeaderValue(object);
            this.removeEditor();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        this.removeEditor();
    }
}

