/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.Messages;
import oracle.dbtools.raptor.controls.grid.contextmenu.SingleRecordViewPanel;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;

public class SingleRecordView
extends GridContextMenuItem {
    private static String _nextCmdName = "GRID_SINGLE_VIEW_NEXT";
    private static int _nextCmdId = Ide.findOrCreateCmdID((String)_nextCmdName);
    private IdeAction _nextCmdAction = null;
    private static String _prevCmdName = "GRID_SINGLE_VIEW_PREV";
    private static int _prevCmdId = Ide.findOrCreateCmdID((String)_prevCmdName);
    private IdeAction _prevCmdAction = null;
    private static String _startCmdName = "GRID_SINGLE_VIEW_START";
    private static int _startCmdId = Ide.findOrCreateCmdID((String)_startCmdName);
    private IdeAction _startCmdAction = null;
    private static String _lastCmdName = "GRID_SINGLE_VIEW_LAST";
    private static int _lastCmdId = Ide.findOrCreateCmdID((String)_lastCmdName);
    private IdeAction _lastCmdAction = null;
    private static String _cmdName = "GRID_SINGLE_RECORD_VIEW";
    private static int _SRVcmdId = Ide.findOrCreateCmdID((String)_cmdName);
    private IdeAction _SRVaction = null;
    private JMenuItem _menuItem = null;
    private int _currRow;
    private SingleRecordViewPanel _panel;
    protected int h = 200;
    protected int w = 200;
    private static SingleRecordView _instance = null;

    private SingleRecordView() {
        this.initActions();
    }

    public static SingleRecordView getInstance() {
        if (_instance == null) {
            _instance = new SingleRecordView();
        }
        return _instance;
    }

    @Override
    protected boolean canShow(ContextMenu contextMenu) {
        return true;
    }

    @Override
    protected void createAndShowMenu(ContextMenu contextMenu) {
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)this._SRVaction);
        contextMenu.add((Component)jMenuItem);
        this._currRow = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (_SRVcmdId == n) {
            this._panel = new SingleRecordViewPanel(this._table, this._currRow);
            this._panel.getToolBar().add((ToggleAction)this._startCmdAction);
            this._panel.getToolBar().add((ToggleAction)this._prevCmdAction);
            this._panel.getToolBar().add((ToggleAction)this._nextCmdAction);
            this._panel.getToolBar().add((ToggleAction)this._lastCmdAction);
            this._panel.print(this._panel.getGraphics());
            int n2 = Toolkit.getDefaultToolkit().getScreenSize().height;
            int n3 = Toolkit.getDefaultToolkit().getScreenSize().width;
            Dimension dimension = this._panel.getPreferredSize();
            int n4 = dimension.height;
            int n5 = dimension.width;
            if (n4 + 150 > n2 || n5 + 150 > n3) {
                n4 = n2 - 500;
                if (n5 + 150 > n3) {
                    n5 = n3 - 500;
                }
                dimension.setSize(n5, n4);
                this._panel.setSize(dimension);
                this._panel.setPreferredSize(dimension);
            }
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand() == "apply") {
                        SingleRecordView.this._panel.save();
                    }
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                }
            };
            int n6 = this._table.isEditable() ? 14 : 6;
            UIUtils.showPanelAsDialog(this._panel, Messages.getString("SingleRecordView.0"), actionListener, n6, true);
            this._panel.removeTaskListener();
            return true;
        }
        if (_startCmdId == n) {
            this._panel.first();
        } else if (_prevCmdId == n) {
            this._panel.prev();
        } else if (_nextCmdId == n) {
            this._panel.next();
        } else if (_lastCmdId == n) {
            this._panel.last();
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    private void initActions() {
        if (this._SRVaction == null) {
            this._SRVaction = this.createAction(_SRVcmdId, Messages.getString("SingleRecordView.0"), null);
        }
        if (this._startCmdAction == null) {
            this._startCmdAction = this.createAction(_startCmdId, Messages.getString("SingleRecordView.1"), RaptorImage.getIcon("first_ena.png"));
        }
        if (this._prevCmdAction == null) {
            this._prevCmdAction = this.createAction(_prevCmdId, Messages.getString("SingleRecordView.3"), RaptorImage.getIcon("prev_ena.png"));
        }
        if (this._nextCmdAction == null) {
            this._nextCmdAction = this.createAction(_nextCmdId, Messages.getString("SingleRecordView.5"), RaptorImage.getIcon("next_ena.png"));
        }
        if (this._lastCmdAction == null) {
            this._lastCmdAction = this.createAction(_lastCmdId, Messages.getString("SingleRecordView.7"), RaptorImage.getIcon("last_ena.png"));
        }
    }
}

