/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridHeaderContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.Messages;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;

public class CopyColumnHeader
extends GridHeaderContextMenuItem {
    private static CopyColumnHeader _instance = null;
    public static final String _cmdCopyColumnHeading = "cmdCopyColumnHeading";
    public static final int _cmdIdCopyColumnHeading = Ide.findOrCreateCmdID((String)"cmdCopyColumnHeading");
    private IdeAction _actionCopyColumnHeading;
    private JMenuItem _mi = null;

    private CopyColumnHeader() {
        this.initAction();
    }

    public static CopyColumnHeader getInstance() {
        if (_instance == null) {
            _instance = new CopyColumnHeader();
        }
        return _instance;
    }

    private void initAction() {
        if (this._actionCopyColumnHeading == null) {
            this._actionCopyColumnHeading = this.createAction(_cmdIdCopyColumnHeading, Messages.getString("CopyColumnHeading.0"), null);
        }
    }

    @Override
    protected boolean canShow(ContextMenu contextMenu) {
        return true;
    }

    @Override
    protected void createAndShowMenu(ContextMenu contextMenu) {
        this.createJMenuItem(contextMenu);
        contextMenu.add((Component)this._mi);
    }

    private void createJMenuItem(ContextMenu contextMenu) {
        if (this._mi == null) {
            this._mi = contextMenu.createMenuItem((ToggleAction)this._actionCopyColumnHeading);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == _cmdIdCopyColumnHeading && this._table != null) {
            int[] nArray = this._table.getSelectedColumns();
            boolean bl = true;
            StringBuilder stringBuilder = new StringBuilder();
            for (int n : nArray) {
                Object object = this._table.getColumnModel().getColumn(n).getHeaderValue();
                if (object == null) continue;
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                stringBuilder.append(object.toString());
            }
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            return true;
        }
        return false;
    }

    private boolean setMenuEnableState(IdeAction ideAction, Context context) {
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        if (ideAction.getCommandId() == _cmdIdCopyColumnHeading) {
            this.getTableFromContext(context);
            bl = true;
            if (this._table != null && this._table != null && this._table instanceof RaptorGridTable) {
                n = this._table.getSelectedColumnCount();
                if (n < 1 || this._table.isVerticalDisplay()) {
                    bl2 = false;
                    ideAction.setEnabled(false);
                } else {
                    bl2 = true;
                    ideAction.setEnabled(true);
                }
            }
        }
        ideAction.setEnabled(bl2);
        return bl;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == _cmdIdCopyColumnHeading) {
            this.setMenuEnableState(ideAction, context);
            return true;
        }
        return false;
    }

    @Override
    public JMenuItem[] getJMenuItems(ContextMenu contextMenu) {
        this.createJMenuItem(contextMenu);
        return new JMenuItem[]{this._mi};
    }
}

