/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.grid.ColumnAutoSizer;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridHeaderContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.Messages;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;

public class ColumnAutoFit
extends GridHeaderContextMenuItem {
    private static ColumnAutoFit _instance = null;
    public static String CMD_AUTO_FIT_ALL_ON_HEADER = Messages.getString("ColumnAutoFit.0");
    public static String CMD_AUTO_FIT_ALL_ON_VALUE = Messages.getString("ColumnAutoFit.1");
    public static String CMD_AUTO_FIT_ALL_BEST = Messages.getString("ColumnAutoFit.2");
    public static String CMD_AUTO_FIT_ALL_FIT_SCREEN = Messages.getString("ColumnAutoFit.3");
    public static String CMD_AUTO_FIT_SELECTED_ON_HEADER = Messages.getString("ColumnAutoFit.4");
    public static String CMD_AUTO_FIT_SELECTED_ON_VALUE = Messages.getString("ColumnAutoFit.5");
    public static String CMD_AUTO_FIT_SELECTED_BEST = Messages.getString("ColumnAutoFit.6");
    private static int _cmdId1 = Ide.findOrCreateCmdID((String)CMD_AUTO_FIT_ALL_ON_HEADER);
    private static int _cmdId2 = Ide.findOrCreateCmdID((String)CMD_AUTO_FIT_ALL_ON_VALUE);
    private static int _cmdId3 = Ide.findOrCreateCmdID((String)CMD_AUTO_FIT_SELECTED_ON_HEADER);
    private static int _cmdId4 = Ide.findOrCreateCmdID((String)CMD_AUTO_FIT_SELECTED_ON_VALUE);
    private static int _cmdId5 = Ide.findOrCreateCmdID((String)CMD_AUTO_FIT_ALL_BEST);
    private static int _cmdId6 = Ide.findOrCreateCmdID((String)CMD_AUTO_FIT_SELECTED_BEST);
    private static int _cmdId7 = Ide.findOrCreateCmdID((String)CMD_AUTO_FIT_ALL_FIT_SCREEN);
    private IdeAction actionFitSelectedonHeader = null;
    private IdeAction actionFitSelectedonValue = null;
    private IdeAction actionFitSelectedBest = null;
    private IdeAction actionFitAllonHeader = null;
    private IdeAction actionFitAllonValue = null;
    private IdeAction actionFitAllBest = null;
    private IdeAction actionFitAllFitScreen = null;
    private static JMenu menuFitSelected = null;
    private static JMenu menuFitAll = null;
    private static int _lastResizeCmd;

    private ColumnAutoFit() {
        this.initActions();
    }

    public static ColumnAutoFit getInstance() {
        if (_instance == null) {
            _instance = new ColumnAutoFit();
        }
        return _instance;
    }

    @Override
    protected boolean canShow(ContextMenu contextMenu) {
        return true;
    }

    @Override
    protected void createAndShowMenu(ContextMenu contextMenu) {
        this.initActions();
        EventObject eventObject = null;
        if (contextMenu.getContext().getEvent() instanceof MouseEvent) {
            eventObject = (MouseEvent)contextMenu.getContext().getEvent();
        }
        if (eventObject != null && (eventObject.getSource() instanceof JTableHeader || eventObject.getSource() instanceof RaptorGridTable)) {
            Object object;
            Component component = (Component)contextMenu.getContext().getEvent().getSource();
            this._table = component instanceof JTableHeader ? (RaptorGridTable)((JTableHeader)component).getTable() : (RaptorGridTable)component;
            int n = this._table.columnAtPoint(((MouseEvent)eventObject).getPoint());
            int n2 = this._table.rowAtPoint(((MouseEvent)eventObject).getPoint());
            if (n == -1) {
                return;
            }
            if (this._table.getSelectedColumnCount() == 1) {
                this._table.setCellSelectionEnabled(true);
                this._table.setColumnSelectionAllowed(true);
                this._table.setRowSelectionAllowed(true);
            }
            TableColumnModel tableColumnModel = this._table.getColumnModel();
            int n3 = this._table.getRowCount();
            if (n3 != 0 && this._table.getSelectedColumnCount() <= 1) {
                this._table.setRowSelectionInterval(n2, n2);
                this._table.setColumnSelectionInterval(n, n);
            }
            if (this._table.getSelectedColumnCount() == 0) {
                object = tableColumnModel.getSelectionModel();
                ColumnAutoFit.select((ListSelectionModel)object, (MouseEvent)eventObject, n);
            }
            if (this._table.getColumnCount() > 1) {
                object = ColumnAutoSizer.AUTO_FIT_ALL;
                menuFitAll = contextMenu.createMenu((String)object, (float)StringUtils.getMnemonicKeyCode((String)object));
                menuFitAll.add(contextMenu.createMenuItem((ToggleAction)this.actionFitAllonHeader));
                menuFitAll.add(contextMenu.createMenuItem((ToggleAction)this.actionFitAllonValue));
                menuFitAll.add(contextMenu.createMenuItem((ToggleAction)this.actionFitAllBest));
                menuFitAll.add(contextMenu.createMenuItem((ToggleAction)this.actionFitAllFitScreen));
                menuFitAll.setSelected(false);
                this.actionFitAllonHeader.addController((Controller)this);
                this.actionFitAllonHeader.setEnabled(true);
                this.actionFitAllonValue.addController((Controller)this);
                this.actionFitAllonValue.setEnabled(true);
                this.actionFitAllBest.addController((Controller)this);
                this.actionFitAllBest.setEnabled(true);
                this.actionFitAllFitScreen.addController((Controller)this);
                this.actionFitAllFitScreen.setEnabled(true);
                contextMenu.add((Component)menuFitAll);
            }
            if (this._table.getSelectedColumnCount() > 0) {
                object = this._table.getSelectedColumnCount() > 1 ? ColumnAutoSizer.AUTO_FIT_SELECTED + "s" : ColumnAutoSizer.AUTO_FIT_SELECTED;
                menuFitSelected = contextMenu.createMenu((String)object, (float)StringUtils.getMnemonicKeyCode((String)object));
                menuFitSelected.add(contextMenu.createMenuItem((ToggleAction)this.actionFitSelectedonHeader));
                menuFitSelected.add(contextMenu.createMenuItem((ToggleAction)this.actionFitSelectedonValue));
                menuFitSelected.add(contextMenu.createMenuItem((ToggleAction)this.actionFitSelectedBest));
                menuFitSelected.setSelected(false);
                this.actionFitSelectedonHeader.addController((Controller)this);
                this.actionFitSelectedonHeader.setEnabled(true);
                this.actionFitSelectedonValue.addController((Controller)this);
                this.actionFitSelectedonValue.setEnabled(true);
                this.actionFitSelectedBest.addController((Controller)this);
                this.actionFitSelectedBest.setEnabled(true);
                contextMenu.add((Component)menuFitSelected);
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = true;
        if (this._table == null) {
            return false;
        }
        int n = ideAction.getCommandId();
        if (_cmdId1 == n) {
            ColumnAutoSizer.autoResizeTable(this._table, ColumnAutoSizer.AUTO_FIT_ON_HEADER);
        } else if (_cmdId2 == n) {
            ColumnAutoSizer.autoResizeTable(this._table, ColumnAutoSizer.AUTO_FIT_ON_DATA);
        } else if (_cmdId3 == n) {
            ColumnAutoSizer.autoResizeSelectedColumns(this._table, ColumnAutoSizer.AUTO_FIT_ON_HEADER);
        } else if (_cmdId4 == n) {
            ColumnAutoSizer.autoResizeSelectedColumns(this._table, ColumnAutoSizer.AUTO_FIT_ON_DATA);
        } else if (_cmdId5 == n) {
            ColumnAutoSizer.autoResizeTable(this._table, ColumnAutoSizer.AUTO_FIT_OPTIMUM);
        } else if (_cmdId6 == n) {
            ColumnAutoSizer.autoResizeSelectedColumns(this._table, ColumnAutoSizer.AUTO_FIT_OPTIMUM);
        } else if (_cmdId7 == n) {
            ColumnAutoSizer.autoResizeTable(this._table, ColumnAutoSizer.AUTO_FIT_SCREEN);
        } else {
            bl = false;
        }
        if (bl) {
            _lastResizeCmd = n;
            RaptorGridPersistedSettings.savePersistentSettings(this._table);
        }
        return bl;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    private void initActions() {
        String string = ColumnAutoSizer.AUTO_FIT_ON_HEADER;
        String string2 = StringUtils.stripMnemonic((String)string);
        Integer n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        if (this.actionFitAllonHeader == null) {
            this.actionFitAllonHeader = this.createAction(_cmdId1, string2, null);
        }
        if (this.actionFitSelectedonHeader == null) {
            this.actionFitSelectedonHeader = this.createAction(_cmdId3, string2, null);
        }
        string = ColumnAutoSizer.AUTO_FIT_ON_DATA;
        string2 = StringUtils.stripMnemonic((String)string);
        n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        if (this.actionFitAllonValue == null) {
            this.actionFitAllonValue = this.createAction(_cmdId2, string2, null);
        }
        if (this.actionFitSelectedonValue == null) {
            this.actionFitSelectedonValue = this.createAction(_cmdId4, string2, null);
        }
        string = ColumnAutoSizer.AUTO_FIT_OPTIMUM;
        string2 = StringUtils.stripMnemonic((String)string);
        n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        if (this.actionFitAllBest == null) {
            this.actionFitAllBest = this.createAction(_cmdId5, string2, null);
        }
        if (this.actionFitSelectedBest == null) {
            this.actionFitSelectedBest = this.createAction(_cmdId6, string2, null);
        }
        string = ColumnAutoSizer.AUTO_FIT_SCREEN;
        string2 = StringUtils.stripMnemonic((String)string);
        n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        if (this.actionFitAllFitScreen == null) {
            this.actionFitAllFitScreen = this.createAction(_cmdId7, string2, null);
        }
    }

    public void restoreLast(RaptorGridTable raptorGridTable) {
        IdeAction ideAction = IdeAction.find((int)_lastResizeCmd);
        if (raptorGridTable == this._table && ideAction != null) {
            this.handleEvent(ideAction, null);
        }
    }

    public static void select(ListSelectionModel listSelectionModel, MouseEvent mouseEvent, int n) {
        if (mouseEvent.isShiftDown()) {
            int n2 = listSelectionModel.getAnchorSelectionIndex();
            int n3 = listSelectionModel.getLeadSelectionIndex();
            if (n2 != -1) {
                boolean bl = listSelectionModel.getValueIsAdjusting();
                listSelectionModel.setValueIsAdjusting(true);
                boolean bl2 = listSelectionModel.isSelectedIndex(n2);
                if (n3 != -1) {
                    if (bl2) {
                        listSelectionModel.removeSelectionInterval(n2, n3);
                    } else {
                        listSelectionModel.addSelectionInterval(n2, n3);
                    }
                }
                if (bl2) {
                    listSelectionModel.addSelectionInterval(n2, n);
                } else {
                    listSelectionModel.removeSelectionInterval(n2, n);
                }
                listSelectionModel.setValueIsAdjusting(bl);
            } else {
                listSelectionModel.setSelectionInterval(n, n);
            }
        } else if (mouseEvent.isControlDown()) {
            if (listSelectionModel.isSelectedIndex(n)) {
                listSelectionModel.removeSelectionInterval(n, n);
            } else {
                listSelectionModel.addSelectionInterval(n, n);
            }
        } else {
            listSelectionModel.setSelectionInterval(n, n);
        }
    }

    @Override
    public JMenuItem[] getJMenuItems(ContextMenu contextMenu) {
        return null;
    }
}

