/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.raptor.controls.grid.GridFilterField;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.javatools.ui.search.SearchMatcher;

public class GridFilterInsightProvider
implements FieldInsightProvider {
    private GridFilterField _field;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private DefaultListCellRenderer _renderer;

    public GridFilterInsightProvider(GridFilterField gridFilterField) {
        this._field = gridFilterField;
    }

    public void completeInsight(Document document, int n, Object object) {
        try {
            String string = document.getText(0, n);
            if (string.length() > 0 && string.lastIndexOf(" ") > 0) {
                if (Character.isWhitespace(string.charAt(string.length() - 1))) {
                    document.insertString(n, (String)object, null);
                } else if (n - 1 > -1) {
                    document.remove(string.lastIndexOf(" ") + 1, document.getLength() - string.lastIndexOf(" ") - 1);
                    document.insertString(string.lastIndexOf(" ") + 1, (String)object, null);
                }
            } else {
                document.remove(0, document.getLength());
                document.insertString(0, (String)object, null);
            }
        }
        catch (BadLocationException badLocationException) {
            this.logger.log(Level.WARNING, "", badLocationException);
        }
    }

    public ListCellRenderer getCellRenderer() {
        if (this._renderer == null) {
            this._renderer = new DefaultListCellRenderer();
        }
        return this._renderer;
    }

    public Object[] getInsightData(Document document, int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Object object;
            Object object2;
            Object object3;
            String string = document.getText(0, n);
            List<String> list = this._field.getPersistedFilters();
            if (list != null) {
                object3 = list.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    object = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
                    if (!object.matches((CharSequence)object2)) continue;
                    arrayList.add(object2);
                }
            }
            if ((object3 = this._field.getColumnNames()) != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    SearchMatcher searchMatcher;
                    object = (String)object2.next();
                    if (string.length() == 0 || Character.isWhitespace(string.charAt(string.length() - 1))) {
                        SearchMatcher searchMatcher2 = SearchMatcher.getPrefixMatcher((CharSequence)string, (boolean)true, (boolean)true);
                        if (searchMatcher2.matches((CharSequence)object)) {
                            arrayList.add(0, object);
                            continue;
                        }
                        arrayList.add(object);
                        continue;
                    }
                    int n2 = 0;
                    if (string.lastIndexOf(" ") > 0 && string.lastIndexOf(" ") < string.length()) {
                        n2 = string.lastIndexOf(" ");
                    }
                    if (!(searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string.substring(n2 + 1, string.length()), (boolean)true)).matches((CharSequence)object)) continue;
                    arrayList.add(object);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            this.logger.log(Level.WARNING, "", badLocationException);
        }
        return arrayList.toArray();
    }

    public boolean handlesInsight(Document document, int n) {
        return true;
    }

    public boolean isAutoPopupChar(char c) {
        return true;
    }
}

