/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import oracle.dbtools.raptor.controls.grid.GridColumnHighlightParameter;
import oracle.dbtools.raptor.controls.grid.GridColumnSortParameter;
import oracle.dbtools.raptor.utils.AliasedName;

public class GridColumn
extends AliasedName
implements Comparable<GridColumn> {
    protected boolean _skip = false;
    protected GridColumnSortParameter _sortParam = null;
    protected boolean _isSortable = true;
    protected GridColumnHighlightParameter _highlightParam = null;
    protected boolean _hidden = false;

    public GridColumn(String string, boolean bl) {
        super(string);
        this._skip = bl;
    }

    public GridColumn(AliasedName aliasedName, boolean bl) {
        super(aliasedName.getOriginal());
        this._aliasName = aliasedName.getAlias();
        this._skip = bl;
    }

    public boolean isSkiped() {
        return this._skip;
    }

    public void setSkipped(boolean bl) {
        this._skip = bl;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setHidden(boolean bl) {
        this._hidden = bl;
    }

    public void setSortParameter(GridColumnSortParameter gridColumnSortParameter) {
        this._sortParam = !this._skip && this.isSortable() ? gridColumnSortParameter : null;
    }

    public GridColumnSortParameter getSortParameter() {
        return this._sortParam;
    }

    public GridColumnHighlightParameter getHighlightParameter() {
        return this._highlightParam;
    }

    public void setHighlightParameter(GridColumnHighlightParameter gridColumnHighlightParameter) {
        this._highlightParam = this._skip ? gridColumnHighlightParameter : null;
    }

    public boolean isSortable() {
        return this._isSortable;
    }

    public void setSortable(boolean bl) {
        this._isSortable = bl;
    }

    @Override
    public GridColumn clone() throws CloneNotSupportedException {
        GridColumn gridColumn = new GridColumn(super.clone(), this.isSkiped());
        gridColumn.setSortable(this.isSortable());
        gridColumn.setHidden(this._hidden);
        if (this._sortParam != null) {
            gridColumn.setSortParameter(new GridColumnSortParameter(this._sortParam));
        }
        if (this._highlightParam != null) {
            gridColumn.setHighlightParameter(new GridColumnHighlightParameter(this.getHighlightParameter().getColumnName(), this.getHighlightParameter().getHighlightColor()));
        }
        return gridColumn;
    }

    @Override
    public int compareTo(GridColumn gridColumn) {
        GridColumnSortParameter gridColumnSortParameter = this.getSortParameter();
        GridColumnSortParameter gridColumnSortParameter2 = gridColumn.getSortParameter();
        if (this == null && gridColumnSortParameter2 == null) {
            return this.getOriginal().compareTo(gridColumn.getOriginal());
        }
        if (gridColumnSortParameter != null && gridColumnSortParameter2 == null) {
            return 1;
        }
        if (gridColumnSortParameter == null && gridColumnSortParameter2 != null) {
            return -1;
        }
        if (gridColumnSortParameter.getSortOrder() > gridColumnSortParameter2.getSortOrder()) {
            return 1;
        }
        if (gridColumnSortParameter.getSortOrder() < gridColumnSortParameter2.getSortOrder()) {
            return -1;
        }
        return 0;
    }

    @Override
    public String toString() {
        return (this._aliasName != null ? this._aliasName : this._originalName) + (this.getSortParameter() != null ? " " + this.getSortParameter() : "");
    }
}

