/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.dbtools.raptor.controls.grid.Messages;
import oracle.dbtools.raptor.controls.grid.RaptorGridSearchParameter;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.ide.Ide;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.help.HelpSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.ui.TransparentPanel;
import oracle.javatools.ui.ghost.ComponentConverter;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class FinderHighlighter
extends GhostPalette
implements AncestorListener {
    private static HashMap<RaptorGridTable, FinderHighlighter> _instances = new HashMap();
    private RaptorGridTable _table;
    private JPanel _mainPanel = new JPanel(new GridBagLayout());
    private SearchField _searchField;
    private final JPanel _optionsPanel = new TransparentPanel();
    private JRadioButton _searchButton = new JRadioButton(Messages.getString("FinderHighlighter.0"));
    private JRadioButton _highlightButton = new JRadioButton(Messages.getString("FinderHighlighter.1"));
    private JCheckBox _wholeWord = new JCheckBox(Messages.getString("FinderHighlighter.2"));
    private JCheckBox _startsWith = new JCheckBox(Messages.getString("FinderHighlighter.3"));
    private JCheckBox _ignoreCase = new JCheckBox(Messages.getString("FinderHighlighter.4"));
    private JCheckBox _wrap = new JCheckBox(Messages.getString("FinderHighlighter.5"));
    private ColorChoice _highlightColor = new ColorChoice();
    private JLabel _colourLabel = new JLabel("     " + Messages.getString("FinderHighlighter.12"));
    private JCheckBox _highlightSave = new JCheckBox(Messages.getString("FinderHighlighter.6"));
    private JPanel _currentHighlights = new TransparentPanel();
    private JCheckBox _showRows = new JCheckBox(Messages.getString("FinderHighlighter.7"));
    private JLabel _status = new JLabel();
    private GridBagConstraints gbc = new GridBagConstraints();
    private List<RaptorGridSearchParameter> _highlights = new ArrayList<RaptorGridSearchParameter>();
    private static String _lastSearchTerm = null;
    private static boolean _lastSearchCheckboxSelected = true;
    private static boolean _lastWrapSelected = false;
    private static boolean _lastIgnoeCaseSelected = false;
    private static boolean _lastWholeWordSelected = false;
    private static boolean _lastPersistSelected = false;
    private static boolean _lastShowRows = false;
    private static Dimension _lastSize = null;
    private static final SearchCategory ALL_COLUMNS_CATEGORY = new SearchCategory(Messages.getString("FinderHighlighter.8"));
    private List<ColumnSearchCategory> _searchCategories = new ArrayList<ColumnSearchCategory>();
    private ColumnModelListener _columnListener = new ColumnModelListener();

    private FinderHighlighter(RaptorGridTable raptorGridTable) {
        this._table = raptorGridTable;
        this.setTitle(Messages.getString("FinderHighlighter.9"));
        this.setLayout(new GridBagLayout());
        this.addSearchField();
        this.addSearchTypes();
        this.addSearchOptions();
        this.addExistingHighlights();
        this.addStatusLabel();
        this.addSearchCategories();
        this.add(this._mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 5), 0, 0));
        this._searchField.setAutoFind(false);
        this._searchField.setAllowEmptySearch(false);
        this._searchField.setStyle(SearchField.Style.FIND);
        this._searchField.addSearchListener(new SearchListener(){

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }

            public void searchPerformed(SearchEvent searchEvent) {
                if (FinderHighlighter.this._highlightButton.isSelected()) {
                    FinderHighlighter.this.highlight(searchEvent);
                } else if (FinderHighlighter.this._searchButton.isSelected()) {
                    FinderHighlighter.this.search(searchEvent);
                }
            }
        });
        this.addAncestorListener(this);
        this._table.getColumnModel().addColumnModelListener(this._columnListener);
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_gridfindhighlight_html");
    }

    private void addSearchCategories() {
        this._searchField.clearCategories();
        this._searchField.addCategory(ALL_COLUMNS_CATEGORY);
        this._searchField.setSelectedCategory(ALL_COLUMNS_CATEGORY);
        if (this._table.getGridModel() != null) {
            Enumeration<TableColumn> enumeration = this._table.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                int n;
                TableColumn tableColumn = enumeration.nextElement();
                if (tableColumn.getModelIndex() == -1 || (n = this._table.convertColumnIndexToView(tableColumn.getModelIndex())) == -1 || n >= this._table.getColumnCount()) continue;
                this._searchField.addCategory((SearchCategory)new ColumnSearchCategory(this._table, n));
            }
        }
    }

    private void addSearchField() {
        this._searchField = new SearchField();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 18;
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 2;
        this.gbc.weightx = 1.0;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 5, 5, 5);
        if (_lastSearchTerm != null) {
            this._searchField.clear();
            this._searchField.getTextField().setText(_lastSearchTerm);
            this._searchField.getTextField().selectAll();
        }
        this._mainPanel.add((Component)this._searchField, this.gbc);
    }

    private void addSearchTypes() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._searchButton);
        buttonGroup.add(this._highlightButton);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this._searchButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                FinderHighlighter.this._highlightColor.setEnabled(FinderHighlighter.this._highlightButton.isSelected());
                FinderHighlighter.this._colourLabel.setEnabled(FinderHighlighter.this._highlightButton.isSelected());
                FinderHighlighter.this._highlightSave.setEnabled(FinderHighlighter.this._highlightButton.isSelected());
                FinderHighlighter.this._showRows.setEnabled(FinderHighlighter.this._highlightButton.isSelected());
            }
        });
        this._searchButton.setSelected(_lastSearchCheckboxSelected);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this._searchButton, gridBagConstraints);
        this._highlightButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                FinderHighlighter.this._colourLabel.setEnabled(FinderHighlighter.this._highlightButton.isSelected());
                FinderHighlighter.this._highlightColor.setEnabled(FinderHighlighter.this._highlightButton.isSelected());
                FinderHighlighter.this._highlightSave.setEnabled(FinderHighlighter.this._highlightButton.isSelected());
                FinderHighlighter.this._showRows.setEnabled(FinderHighlighter.this._highlightButton.isSelected());
            }
        });
        this._highlightButton.setSelected(!_lastSearchCheckboxSelected);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this._highlightButton, gridBagConstraints);
        ++this.gbc.gridy;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 2;
        this._mainPanel.add((Component)jPanel, this.gbc);
    }

    private void addSearchOptions() {
        this._optionsPanel.setLayout(new GridBagLayout());
        HeaderPanel headerPanel = new HeaderPanel((JComponent)this._optionsPanel);
        headerPanel.getHeader().setLevel(Header.Level.SUB);
        headerPanel.getHeader().setText(Messages.getString("FinderHighlighter.10"));
        headerPanel.getHeader().setExpanded(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this._ignoreCase.setSelected(_lastIgnoeCaseSelected);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this._optionsPanel.add((Component)this._ignoreCase, gridBagConstraints);
        ComponentConverter.convertToGhost((JComponent)this._highlightColor, (UIConstants.Look)UIConstants.Look.LIGHT);
        ColorChoice.setCustomColorPaneSupported((boolean)false);
        this._highlightColor.setDefaultAllowed(false);
        this._highlightColor.setSelectedColor(Color.CYAN);
        this._highlightColor.setToolTipText(Messages.getString("FinderHighlighter.11"));
        this._highlightColor.addPropertyChangeListener("selectedColor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("selectedColor")) {
                    FinderHighlighter.this.requestFocusInWindow();
                }
            }
        });
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.anchor = 17;
        this._optionsPanel.add((Component)this._highlightColor, gridBagConstraints);
        this._optionsPanel.add((Component)this._colourLabel, gridBagConstraints);
        this._wholeWord.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (FinderHighlighter.this._wholeWord.isSelected() && FinderHighlighter.this._startsWith.isSelected()) {
                    FinderHighlighter.this._startsWith.setSelected(false);
                }
            }
        });
        this._wholeWord.setSelected(_lastWholeWordSelected);
        ++gridBagConstraints.gridy;
        --gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this._optionsPanel.add((Component)this._wholeWord, gridBagConstraints);
        this._highlightSave.setSelected(_lastPersistSelected);
        ++gridBagConstraints.gridx;
        this._optionsPanel.add((Component)this._highlightSave, gridBagConstraints);
        this._wrap.setSelected(_lastWrapSelected);
        ++gridBagConstraints.gridy;
        --gridBagConstraints.gridx;
        this._optionsPanel.add((Component)this._startsWith, gridBagConstraints);
        this._showRows.setSelected(_lastShowRows);
        ++gridBagConstraints.gridx;
        this._optionsPanel.add((Component)this._showRows, gridBagConstraints);
        this._startsWith.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (FinderHighlighter.this._startsWith.isSelected() && FinderHighlighter.this._wholeWord.isSelected()) {
                    FinderHighlighter.this._wholeWord.setSelected(false);
                }
            }
        });
        this._startsWith.setSelected(this._wholeWord.isSelected());
        ++gridBagConstraints.gridy;
        --gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this._optionsPanel.add((Component)this._wrap, gridBagConstraints);
        --this.gbc.gridx;
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(5, 5, 0, 5);
        this.gbc.weighty = 0.0;
        this.gbc.weightx = 1.0;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 2;
        this._mainPanel.add((Component)headerPanel, this.gbc);
    }

    private void addExistingHighlights() {
        this._currentHighlights.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this._currentHighlights, "North");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        this.addCurrentHighlights();
        HeaderPanel headerPanel = new HeaderPanel((JComponent)jScrollPane);
        ComponentConverter.convertToGhost((JComponent)jScrollPane, (UIConstants.Look)UIConstants.Look.LIGHT);
        headerPanel.getHeader().setLevel(Header.Level.SUB);
        headerPanel.getHeader().setText(Messages.getString("FinderHighlighter.13"));
        headerPanel.getHeader().setExpanded(true);
        ++this.gbc.gridy;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 1;
        this._mainPanel.add((Component)headerPanel, this.gbc);
    }

    private void addCurrentHighlights() {
        this._currentHighlights.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        List<JPanel> list = this.getExistingHighlights();
        for (JPanel jPanel : list) {
            this._currentHighlights.add((Component)jPanel, gridBagConstraints);
        }
        this._currentHighlights.revalidate();
        this._currentHighlights.repaint();
        this.revalidate();
        this.repaint();
        this.pack();
    }

    private void addStatusLabel() {
        this._status.setOpaque(false);
        ++this.gbc.gridy;
        this._mainPanel.add((Component)this._status, this.gbc);
    }

    private void highlight(SearchEvent searchEvent) {
        this._status.setText("");
        int[] nArray = null;
        SearchCategory searchCategory = searchEvent.getSearchCategory();
        if (searchCategory != null && searchCategory != ALL_COLUMNS_CATEGORY) {
            nArray = new int[]{((ColumnSearchCategory)searchCategory).getColumnViewIndex()};
        }
        RaptorGridSearchParameter raptorGridSearchParameter = new RaptorGridSearchParameter(searchEvent.getSearchText(), nArray);
        raptorGridSearchParameter.setColor(this._highlightColor.getSelectedColor());
        raptorGridSearchParameter.setIgnoreCase(this._ignoreCase.isSelected());
        raptorGridSearchParameter.setWholeWord(this._wholeWord.isSelected());
        raptorGridSearchParameter.setStartsWith(this._startsWith.isSelected());
        raptorGridSearchParameter.setPersist(this._highlightSave.isSelected());
        raptorGridSearchParameter.setHighlightRow(this._showRows.isSelected());
        if (!this._highlights.contains(raptorGridSearchParameter)) {
            this._table.addHighLightParam(raptorGridSearchParameter);
            this._highlights.add(raptorGridSearchParameter);
            this._table.repaint();
            this.addCurrentHighlights();
            int n = raptorGridSearchParameter.getMatchCount(this._table);
            this._status.setText(Messages.getString("FinderHighlighter.15") + n + Messages.getString("FinderHighlighter.16") + (n > 1 ? Messages.getString("FinderHighlighter.17") : Messages.getString("FinderHighlighter.18")));
            this.revalidate();
            this.repaint();
        } else {
            this._status.setText(Messages.getString("FinderHighlighter.19"));
        }
    }

    private void search(SearchEvent searchEvent) {
        int n;
        this._status.setText("");
        boolean bl = false;
        int n2 = 0;
        int n3 = this._table.getSelectedRow() == -1 ? 0 : this._table.getSelectedRow();
        int n4 = this._table.getSelectedColumn() == -1 ? 0 : this._table.getSelectedColumn();
        int[] nArray = null;
        SearchCategory searchCategory = searchEvent.getSearchCategory();
        if (searchCategory != null && searchCategory != ALL_COLUMNS_CATEGORY) {
            nArray = new int[]{((ColumnSearchCategory)searchCategory).getColumnViewIndex()};
        }
        RaptorGridSearchParameter raptorGridSearchParameter = new RaptorGridSearchParameter(searchEvent.getSearchText(), nArray);
        raptorGridSearchParameter.setIgnoreCase(this._ignoreCase.isSelected());
        raptorGridSearchParameter.setWholeWord(this._wholeWord.isSelected());
        raptorGridSearchParameter.setStartsWith(this._startsWith.isSelected());
        bl = false;
        boolean bl2 = this._wrap.isSelected();
        if (searchEvent.getDirection() == SearchEvent.Direction.FORWARD) {
            if (n4 < this._table.getColumnCount() - 1) {
                ++n4;
            } else {
                n4 = 0;
                n3 = n3 < this._table.getLoadedRowCount() - 1 ? ++n3 : 0;
            }
            for (n = n3; n < this._table.getLoadedRowCount() && !bl && n2++ != this._table.getLoadedRowCount() + 1; ++n) {
                for (int i = n4; i < this._table.getColumnCount() && !bl; ++i) {
                    if (raptorGridSearchParameter.matches(this._table, n, i)) {
                        bl = true;
                        this._table.changeSelection(n, i, false, false);
                        break;
                    }
                    if (!bl2 || n != this._table.getLoadedRowCount() - 1 || i != this._table.getColumnCount() - 1) continue;
                    n3 = 0;
                    n = -1;
                    n4 = 0;
                    bl = false;
                    break;
                }
                n4 = 0;
            }
        } else if (searchEvent.getDirection() == SearchEvent.Direction.BACKWARD) {
            if (n4 > 0) {
                --n4;
            } else if (n3 > 0) {
                --n3;
            } else {
                n3 = this._table.getLoadedRowCount() - 1;
                n4 = this._table.getColumnCount() - 1;
            }
            for (n = n3; n >= 0 && !bl && n2++ != this._table.getLoadedRowCount() + 1; --n) {
                for (int i = n4; i >= 0 && !bl; --i) {
                    if (raptorGridSearchParameter.matches(this._table, n, i)) {
                        bl = true;
                        this._table.changeSelection(n, i, false, false);
                        break;
                    }
                    if (!bl2 || n != 0 || i != 0) continue;
                    n3 = this._table.getLoadedRowCount() - 1;
                    n = n3 + 1;
                    n4 = this._table.getColumnCount() - 1;
                    bl = false;
                    break;
                }
                n4 = this._table.getColumnCount() - 1;
            }
        }
        n = raptorGridSearchParameter.getMatchCount(this._table);
        this._status.setText(Messages.getString("FinderHighlighter.21") + n + Messages.getString("FinderHighlighter.20") + (n > 1 ? Messages.getString("FinderHighlighter.22") : Messages.getString("FinderHighlighter.23")));
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.cleanup(ancestorEvent);
    }

    private void cleanup(EventObject eventObject) {
        this._table.getColumnModel().removeColumnModelListener(this._columnListener);
        for (RaptorGridSearchParameter raptorGridSearchParameter : this._highlights) {
            if (raptorGridSearchParameter.isPersist()) continue;
            this._table.removeHighLightParam(raptorGridSearchParameter);
        }
        this._highlights.clear();
        _lastSearchCheckboxSelected = this._searchButton.isSelected();
        _lastSearchTerm = this._searchField.getText();
        _lastIgnoeCaseSelected = this._ignoreCase.isSelected();
        _lastWholeWordSelected = this._wholeWord.isSelected();
        _lastWrapSelected = this._wrap.isSelected();
        _lastShowRows = this._showRows.isSelected();
        _lastSize = this.getSize();
        if (this.isShowing()) {
            this.removeAncestorListener(this);
            this.hidePanel();
        }
        this._table.repaint();
        this._table.requestFocusInWindow();
        _instances.remove(this._table);
        this._table = null;
    }

    private List<JPanel> getExistingHighlights() {
        ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
        List<RaptorGridSearchParameter> list = this._table.getSearchParams(true);
        for (final RaptorGridSearchParameter raptorGridSearchParameter : list) {
            if (raptorGridSearchParameter == null || !raptorGridSearchParameter.isPersist()) continue;
            final JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            final ColorChoice colorChoice = new ColorChoice();
            ComponentConverter.convertToGhost((JComponent)colorChoice, (UIConstants.Look)UIConstants.Look.LIGHT);
            ColorChoice.setCustomColorPaneSupported((boolean)false);
            colorChoice.setDefaultAllowed(false);
            colorChoice.setSelectedColor(raptorGridSearchParameter.getColor());
            colorChoice.addPropertyChangeListener("selectedColor", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("selectedColor")) {
                        raptorGridSearchParameter.setColor(colorChoice.getSelectedColor());
                        FinderHighlighter.this.requestFocusInWindow();
                        FinderHighlighter.this._table.repaint();
                    }
                }
            });
            jPanel.add((Component)colorChoice, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            JLabel jLabel = new JLabel(((Object)raptorGridSearchParameter.getSearchString()).toString());
            jLabel.setToolTipText(raptorGridSearchParameter.toString());
            jPanel.add((Component)jLabel, gridBagConstraints);
            arrayList.add(jPanel);
            final JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setToolTipText(Messages.getString("FinderHighlighter.26"));
            jCheckBox.setSelected(raptorGridSearchParameter.isEnabled());
            jCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    raptorGridSearchParameter.setEnabled(jCheckBox.isSelected());
                    FinderHighlighter.this._table.repaint();
                }
            });
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)jCheckBox, gridBagConstraints);
            SmallSquareButton smallSquareButton = new SmallSquareButton(OracleIcons.getIcon((String)"delete.png"), Messages.getString("FinderHighlighter.27"));
            smallSquareButton.setFocusable(true);
            smallSquareButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FinderHighlighter.this._table.removeHighLightParam(raptorGridSearchParameter);
                    FinderHighlighter.this._highlights.remove(raptorGridSearchParameter);
                    FinderHighlighter.this._currentHighlights.remove(jPanel);
                    FinderHighlighter.this._currentHighlights.revalidate();
                    FinderHighlighter.this._currentHighlights.repaint();
                    FinderHighlighter.this._table.repaint();
                    FinderHighlighter.this.revalidate();
                    FinderHighlighter.this.repaint();
                }
            });
            jPanel.add((Component)smallSquareButton, gridBagConstraints);
            ComponentConverter.convertToGhost((JComponent)jPanel, (UIConstants.Look)UIConstants.Look.LIGHT);
        }
        return arrayList;
    }

    public Dimension getPreferredSize() {
        if (_lastSize != null) {
            return _lastSize;
        }
        return new Dimension(this._mainPanel.getPreferredSize().width + 15, this._mainPanel.getPreferredSize().height + 50);
    }

    public static void showDialog(RaptorGridTable raptorGridTable) {
        FinderHighlighter finderHighlighter = _instances.get(raptorGridTable);
        if (finderHighlighter == null) {
            finderHighlighter = new FinderHighlighter(raptorGridTable);
            _instances.put(raptorGridTable, finderHighlighter);
            finderHighlighter.setSize(finderHighlighter.getPreferredSize());
            finderHighlighter.pack();
            finderHighlighter.setLocation(raptorGridTable.getLocation());
            finderHighlighter.show(Ide.getMainWindow().getLayeredPane(), true, true);
        } else {
            finderHighlighter.setVisible(true);
        }
    }

    private class ColumnModelListener
    implements TableColumnModelListener {
        private ColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            FinderHighlighter.this.cleanup(tableColumnModelEvent);
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            FinderHighlighter.this.cleanup(tableColumnModelEvent);
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    private static class ColumnSearchCategory
    extends SearchCategory {
        int _columnViewIndex = -1;

        public ColumnSearchCategory(RaptorGridTable raptorGridTable, int n) {
            super(raptorGridTable.getColumnName(n));
            this._columnViewIndex = n;
        }

        int getColumnViewIndex() {
            return this._columnViewIndex;
        }
    }
}

