/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import com.sleepycat.persist.model.Persistent;
import com.sleepycat.persist.model.PersistentProxy;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.db.DBUtil;
import oracle.javatools.db.DBException;
import oracle.jdbc.OracleConnection;
import oracle.sql.CLOB;

@Persistent(proxyFor=CLOB.class)
public class CLOBProxy
implements PersistentProxy<CLOB> {
    private byte[] bytes = null;
    private String connName = null;

    public CLOB convertProxy() {
        OracleConnection oracleConnection = null;
        try {
            oracleConnection = (OracleConnection)DBUtil.getConnectionResolver().getConnection(this.connName);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        try {
            if (oracleConnection != null) {
                return new CLOB(oracleConnection, this.bytes);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    public void initializeProxy(CLOB cLOB) {
        Connection connection = null;
        try {
            connection = cLOB.getJavaSqlConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (connection != null) {
            this.connName = DBUtil.getConnectionResolver().getConnectionName(connection);
        }
        this.bytes = cLOB.getBytes();
    }
}

