/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.dbtools.raptor.controls.SQLDialogHelpProvider;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.format.XMLFormatter;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditorAddin;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.tabbedpane.CustomTabbedPaneUI;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.util.IdeUtil;
import oracle.javatools.editor.EditorProperties;

public class UIUtils {
    public static final String HELP_TEXT = "HELP_TEXT";
    private static ActionAcceleratorKeystrokeChangeListener AAKEYSTROKE_CHANGE_LISTENER;

    public static boolean showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener) {
        return UIUtils.showPanelAsDialog(jPanel, string, actionListener, 14, true);
    }

    public static boolean showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener, boolean bl) {
        return UIUtils.showPanelAsDialog(jPanel, string, actionListener, 14, bl);
    }

    public static boolean showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener, int n) {
        return UIUtils.showPanelAsDialog(jPanel, string, actionListener, n, true);
    }

    public static boolean showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener, int n, boolean bl) {
        return UIUtils.createPanelDialog(jPanel, string, actionListener, n, bl).runDialog();
    }

    public static boolean showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, SQLDialogHelpProvider sQLDialogHelpProvider) {
        return UIUtils.showPanelAsTabbedDialog(jPanelArray, stringArray, string, null, null, null);
    }

    public static boolean showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener) {
        return UIUtils.showPanelAsTabbedDialog(jPanelArray, stringArray, string, actionListener, null, null);
    }

    public static boolean showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider) {
        return UIUtils.showPanelAsTabbedDialog(jPanelArray, stringArray, string, actionListener, helpProvider, null);
    }

    public static boolean showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider, ChangeListener changeListener) {
        return UIUtils.createTabbedPanelDialog(jPanelArray, stringArray, string, actionListener, helpProvider, changeListener).runDialog();
    }

    public static boolean showPanelAsTabbedDialog2(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider, ChangeListener changeListener) {
        return UIUtils.createTabbedPanelDialog2(jPanelArray, stringArray, string, actionListener, helpProvider, changeListener).runDialog();
    }

    public static boolean showPanelAsTabbedDialog2(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener) {
        return UIUtils.showPanelAsTabbedDialog2(jPanelArray, stringArray, string, actionListener, null, null);
    }

    public static void setClipboard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    public static void addFontListener(Component component) {
        final Component component2 = component;
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)AddinManager.getAddinManager().getExtensionIDForAddin(CodeEditorAddin.class));
        FontSizeOptions fontSizeOptions = (FontSizeOptions)clientSetting.getData("FontSizeOptions");
        if (fontSizeOptions != null) {
            Font font = new Font(fontSizeOptions.getFontFamily(), 0, fontSizeOptions.getFontSize());
            component.setFont(font);
        }
        EditorProperties.getProperties().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() != "editor-font-size" && propertyChangeEvent.getPropertyName() != "editor-font-family") {
                    String string = null;
                    int n = 10;
                    n = propertyChangeEvent.getPropertyName() == "editor-font-size" ? ((Integer)propertyChangeEvent.getNewValue()).intValue() : component2.getFont().getSize();
                    string = propertyChangeEvent.getPropertyName() == "editor-font-family" ? (String)propertyChangeEvent.getNewValue() : component2.getFont().getFamily();
                    Font font = null;
                    font = propertyChangeEvent.getPropertyName() == "editor-font" ? (Font)propertyChangeEvent.getNewValue() : new Font(string, 0, n);
                    component2.setFont(font);
                }
            }
        });
    }

    public static void addIdeKeyBindings(JComponent jComponent, int n, String string) {
        MultiInputMap multiInputMap;
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext keyStrokeContext = keyStrokeContextRegistry.getContext(string);
        InputMap inputMap = jComponent.getInputMap(n);
        if (!(inputMap instanceof MultiInputMap)) {
            multiInputMap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)keyStrokeOptions, (KeyStrokeContext)keyStrokeContext);
            multiInputMap.setParent(inputMap);
            jComponent.setInputMap(n, (InputMap)multiInputMap);
        } else {
            multiInputMap = (MultiInputMap)inputMap;
            MultiMapAdapter.fillLocalMap((MultiInputMap)multiInputMap, (KeyStrokeOptions)keyStrokeOptions, (KeyStrokeContext)keyStrokeContext);
        }
        Set set = keyStrokeContext.getAllActions(false);
        ActionMap actionMap = Ide.getIdeActionMap();
        ActionMap actionMap2 = jComponent.getActionMap();
        for (Object object : set) {
            int n2 = object.getCommandId();
            if (actionMap.get(n2) == null) continue;
            actionMap2.put(n2, (Action)object);
        }
        if (jComponent instanceof JTable) {
            Object object;
            KeyStroke keyStroke = KeyStroke.getKeyStroke(32, 0);
            Stack<Object> stack = new Stack<Object>();
            for (object = jComponent.getInputMap(1); object != null; object = ((InputMap)object).getParent()) {
                stack.push(object);
            }
            while (stack.size() > 0) {
                object = (InputMap)stack.pop();
                if (!"addToSelection".equals(((InputMap)object).get(keyStroke))) continue;
                ((InputMap)object).remove(keyStroke);
                break;
            }
        }
    }

    public static boolean isAccelerator(KeyStroke keyStroke) {
        if (null == keyStroke) {
            return false;
        }
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
        KeyStrokes keyStrokes = new KeyStrokes(keyStroke);
        return keyStrokeMap.getKeyStrokesStartingWith(keyStrokes).contains(keyStrokes);
    }

    public static boolean isUndefined(KeyStroke keyStroke) {
        if (null == keyStroke) {
            return true;
        }
        return '\uffff' == keyStroke.getKeyChar() && 0 == keyStroke.getKeyCode();
    }

    public static void setupAccelerators(Toolbar toolbar) {
        Action[] actionArray;
        if (null == toolbar) {
            return;
        }
        for (Action action : actionArray = toolbar.getActions()) {
            if (!(action instanceof IdeAction)) continue;
            UIUtils.setupAccelerator((IdeAction)action);
        }
    }

    public static void setupAccelerator(IdeAction ideAction) {
        UIUtils.setupAccelerator(ideAction, true);
    }

    private static void setupAccelerator(IdeAction ideAction, boolean bl) {
        if (ideAction != null) {
            Object object;
            Serializable serializable;
            int n;
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
            KeyStroke keyStroke = KeyUtil.getBestAccelerator((KeyStrokeMap)keyStrokeMap, (int)(n = ideAction.getCommandId()));
            if (keyStroke == null && (serializable = keyStrokeOptions.getLocalKeyMaps()) != null) {
                object = ((HashMap)serializable).values().iterator();
                while (keyStroke == null && object.hasNext()) {
                    KeyStrokeMap keyStrokeMap2 = (KeyStrokeMap)object.next();
                    keyStroke = KeyUtil.getBestAccelerator((KeyStrokeMap)keyStrokeMap2, (int)n);
                }
            }
            if (keyStroke != null) {
                serializable = new StringBuffer(20);
                ((StringBuffer)serializable).append(" (");
                object = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
                if (object != null && ((String)object).length() > 0) {
                    ((StringBuffer)serializable).append((String)object);
                    ((StringBuffer)serializable).append("+");
                }
                ((StringBuffer)serializable).append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
                ((StringBuffer)serializable).append(")");
                ideAction.putValueDirectly("AcceleratorKey", (Object)keyStroke);
                ideAction.putValueDirectly("last-tooltip-suffix", (Object)((StringBuffer)serializable).toString());
                if (bl) {
                    UIUtils.getActionAcceleratorKeystrokeChangeListener().add(ideAction);
                }
            }
        }
    }

    private static ActionAcceleratorKeystrokeChangeListener getActionAcceleratorKeystrokeChangeListener() {
        if (null == AAKEYSTROKE_CHANGE_LISTENER) {
            AAKEYSTROKE_CHANGE_LISTENER = new ActionAcceleratorKeystrokeChangeListener();
        }
        return AAKEYSTROKE_CHANGE_LISTENER;
    }

    public static void makeTitledBorder(JComponent jComponent, String string) {
        TitledBorder titledBorder = new TitledBorder(string);
        jComponent.setBorder(titledBorder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tableToXml(ResultsFormatterWrapper resultsFormatterWrapper, String string, String string2, final boolean bl, final boolean bl2) throws IOException {
        XMLFormatter xMLFormatter = new XMLFormatter(){

            @Override
            public void printColumn(Object object, int n, int n2) throws IOException {
                if (bl2) {
                    super.printColumn(object, n, n2);
                    return;
                }
                if (n == 0 && !bl) {
                    return;
                }
                String string = this.getColumnName(n2);
                this.write("\t\t<" + string.replace(' ', '_').replace('/', '_') + ">");
                this.write("<![CDATA[");
                if (object != null) {
                    this.write(this.getValue(object).toString());
                }
                this.write("]]>");
                this.write("</" + string.replace(' ', '_') + ">" + this.getLineTerminator());
            }
        };
        File file = new File(string);
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string2);
            xMLFormatter.setDataProvider(resultsFormatterWrapper);
            xMLFormatter.setOutWriter(outputStreamWriter);
            xMLFormatter.setResult(false);
            xMLFormatter.print();
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(UIUtils.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
    }

    public static String stripElipses(String string) {
        Pattern pattern = Pattern.compile("\\.\\.\\.$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return string.substring(0, matcher.start());
        }
        return string;
    }

    public static JEWTDialog createPanelDialog(JPanel jPanel, String string, ActionListener actionListener) {
        return UIUtils.createPanelDialog(jPanel, string, actionListener, 14, true);
    }

    public static JEWTDialog createTabbedPanelDialog(JPanel[] jPanelArray, String[] stringArray, String string, SQLDialogHelpProvider sQLDialogHelpProvider) {
        return UIUtils.createTabbedPanelDialog(jPanelArray, stringArray, string, null, null, null);
    }

    public static JEWTDialog createPanelDialog(JPanel jPanel, String string, ActionListener actionListener, boolean bl) {
        return UIUtils.createPanelDialog(jPanel, string, actionListener, 14, bl);
    }

    public static JEWTDialog createTabbedPanelDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener) {
        return UIUtils.createTabbedPanelDialog(jPanelArray, stringArray, string, actionListener, null, null);
    }

    public static JEWTDialog createTabbedPanelDialog2(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener) {
        return UIUtils.createTabbedPanelDialog2(jPanelArray, stringArray, string, actionListener, null, null);
    }

    public static JEWTDialog createTabbedPanelDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider) {
        return UIUtils.createTabbedPanelDialog(jPanelArray, stringArray, string, actionListener, helpProvider, null);
    }

    public static JEWTDialog createTabbedPanelDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider, ChangeListener changeListener) {
        final JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setUI((TabbedPaneUI)new CustomTabbedPaneUI());
        Component component = null;
        for (int i = 0; i < jPanelArray.length; ++i) {
            if (0 == i) {
                for (Component component2 : jPanelArray[i].getComponents()) {
                    JTextField jTextField;
                    if (!component2.isFocusable() || component2 instanceof JTextField && !(jTextField = (JTextField)component2).isEditable()) continue;
                    component = component2;
                    break;
                }
            }
            jTabbedPane.addTab(stringArray[i], jPanelArray[i]);
        }
        if (helpProvider != null) {
            jTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider);
        } else {
            HelpProvider helpProvider2 = new HelpProvider(){

                public void showHelp(Component component) throws HelpUnavailableException {
                    HelpSystem.getHelpSystem().showHelp((JComponent)jTabbedPane.getSelectedComponent());
                }
            };
            jTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider2);
        }
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jTabbedPane, component, (String)UIUtils.stripElipses(string), (int)14);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        if (changeListener != null) {
            jTabbedPane.addChangeListener(changeListener);
        }
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        return jEWTDialog;
    }

    public static JEWTDialog createTabbedPanelDialog2(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider, ChangeListener changeListener) {
        final JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setUI((TabbedPaneUI)new CustomTabbedPaneUI());
        for (int i = 0; i < jPanelArray.length; ++i) {
            jPanelArray[i].setBorder(BorderFactory.createEtchedBorder());
            jTabbedPane.addTab(stringArray[i], jPanelArray[i]);
        }
        if (helpProvider != null) {
            jTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider);
        } else {
            HelpProvider helpProvider2 = new HelpProvider(){

                public void showHelp(Component component) throws HelpUnavailableException {
                    HelpSystem.getHelpSystem().showHelp((JComponent)jTabbedPane.getSelectedComponent());
                }
            };
            jTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider2);
        }
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jTabbedPane, null, (String)UIUtils.stripElipses(string), (int)28);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        if (changeListener != null) {
            jTabbedPane.addChangeListener(changeListener);
        }
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        jEWTDialog.setPreferredSize(jTabbedPane.getPreferredSize());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        return jEWTDialog;
    }

    public static JEWTDialog createPanelDialog(JPanel jPanel, String string, ActionListener actionListener, int n) {
        return UIUtils.createPanelDialog(jPanel, string, actionListener, n, true);
    }

    public static JEWTDialog createPanelDialog(JPanel jPanel, String string, ActionListener actionListener, int n, boolean bl) {
        Dimension dimension = jPanel.getPreferredSize();
        dimension.setSize(dimension.getWidth() + 150.0, dimension.getHeight() + 100.0);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)UIUtils.stripElipses(string), (int)n);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        jEWTDialog.setModal(bl);
        if (jPanel.getClientProperty(HELP_TEXT) != null) {
            String string2 = (String)jPanel.getClientProperty(HELP_TEXT);
            jPanel.putClientProperty("JEWT.HelpProvider", new SQLDialogHelpProvider(string2));
        }
        jEWTDialog.setSize(dimension);
        DialogSizeKeeper.attachToComponent((Component)jEWTDialog, (String)(string + ".dialogSize"));
        jEWTDialog.setLocationRelativeTo(null);
        return jEWTDialog;
    }

    private static class ActionAcceleratorKeystrokeChangeListener
    implements ChangeListener {
        private Collection<WeakReference<IdeAction>> _actions = new ArrayList<WeakReference<IdeAction>>();

        public ActionAcceleratorKeystrokeChangeListener() {
            Ide.getSettings().getKeyStrokeOptions().addChangeListener((ChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(IdeAction ideAction) {
            assert (ideAction != null);
            Collection<WeakReference<IdeAction>> collection = this._actions;
            synchronized (collection) {
                if (!this.contains(ideAction)) {
                    this._actions.add(new WeakReference<IdeAction>(ideAction));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean contains(IdeAction ideAction) {
            assert (ideAction != null);
            Collection<WeakReference<IdeAction>> collection = this._actions;
            synchronized (collection) {
                for (WeakReference<IdeAction> weakReference : this._actions) {
                    if (!ideAction.equals(weakReference.get())) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Collection<WeakReference<IdeAction>> collection = this._actions;
            synchronized (collection) {
                ArrayList<WeakReference<IdeAction>> arrayList = new ArrayList<WeakReference<IdeAction>>();
                for (WeakReference<IdeAction> weakReference : this._actions) {
                    IdeAction ideAction = (IdeAction)weakReference.get();
                    if (ideAction != null) {
                        UIUtils.setupAccelerator(ideAction, false);
                        continue;
                    }
                    arrayList.add(weakReference);
                }
                if (!arrayList.isEmpty()) {
                    this._actions.removeAll(arrayList);
                }
            }
        }
    }
}

