/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.awt.Component;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.ui.Messages;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class RaptorTaskUtils {
    public static String getErrorMessage(Throwable throwable) {
        String string = null;
        if (throwable != null && throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            if (exception instanceof TaskException) {
                TaskException taskException = (TaskException)exception;
                return RaptorTaskUtils.getErrorMessage(taskException.getCause());
            }
            if (exception instanceof ExecutionException) {
                ExecutionException executionException = (ExecutionException)exception;
                return RaptorTaskUtils.getErrorMessage(executionException.getCause());
            }
            if (exception instanceof CancellationException) {
                return Messages.getString("TaskProgressViewer.TaskCancelled");
            }
            if (exception instanceof SQLException) {
                return ((SQLException)exception).getMessage();
            }
        }
        return string != null ? string : "";
    }

    public static void showErrorMessage(String string, Component component, RaptorTaskDescriptor raptorTaskDescriptor, boolean bl) {
        Throwable throwable = raptorTaskDescriptor.getThrowable();
        if (throwable instanceof TaskException) {
            throwable = ((TaskException)throwable).getCause();
        } else if (throwable instanceof ExecutionException) {
            throwable = ((ExecutionException)throwable).getCause();
        }
        if (throwable instanceof CancellationException) {
            if (!bl) {
                String string2 = Messages.getString("TaskProgressViewer.TaskCancelled") + raptorTaskDescriptor.getMessage();
                MessageDialog.error((Component)component, (Object)string2, (String)Messages.getString("TaskProgressViewer.Title"), null);
                return;
            }
        } else {
            String string3;
            if (throwable instanceof SQLException) {
                SQLErrorDialog.showErrorDialog(string, component, Messages.getString("TaskProgressViewer.Title"), (SQLException)throwable);
                return;
            }
            String string4 = string3 = throwable == null ? raptorTaskDescriptor.getMessage() : throwable.getMessage();
            if (string3 == null || string3.equals("")) {
                string3 = raptorTaskDescriptor.getThrowable().getMessage();
            }
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
            String string5 = dateFormat.format(new Date(raptorTaskDescriptor.getStartTime()));
            String string6 = dateFormat.format(new Date(raptorTaskDescriptor.getLastProgressTime()));
            String string7 = "<table border=\"0\"> <tr> <td>" + Messages.getString("TaskProgressViewer.StartTime") + "</td>" + "<td>" + string5 + "</td></tr><tr><td>" + Messages.getString("TaskProgressViewer.EndTime") + "</td><td>" + string6 + "</td></tr></table>";
            string3 = "<html>" + string3 + "<br> " + string7 + "</html>";
            ExceptionDialog.showExceptionDialog((Component)component, (Throwable)throwable, (String)Messages.getString("TaskProgressViewer.Title"), (String)string3, null);
        }
    }

    public static void showErrorMessage(String string, Component component, RaptorTaskDescriptor raptorTaskDescriptor) {
        RaptorTaskUtils.showErrorMessage(string, component, raptorTaskDescriptor, false);
    }
}

