/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.FileAssociations;
import oracle.ide.migration.Migrator;
import oracle.javatools.util.PlatformUtils;

public class FileAssociationsMigrator
implements Migrator {
    private static final int FILE_ASSOCIATION_CATEGORY = 0;
    boolean _selected = true;

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int category) {
        return null;
    }

    public boolean canMigrate(int category, File sourceDir) {
        return false;
    }

    public void setSelected(int category, boolean selected) {
        if (category == 0) {
            this._selected = selected;
        }
    }

    public boolean isSelected(int category) {
        return category == 0 ? this._selected : false;
    }

    public String[] migrate(File sourceDir, File destDir) {
        if (!PlatformUtils.isWindows()) {
            return null;
        }
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public void addinsLoaded(IdeEvent e) {
                FileAssociationsMigrator.this.migrateAssociations();
                Ide.removeIdeListener((IdeListener)this);
            }
        });
        return null;
    }

    private void migrateAssociations() {
        DocumentExtensions exts = new DocumentExtensions();
        Map extMap = this.createExtInfoCache(exts);
        for (String ext : extMap.keySet()) {
            if (!FileAssociations.shouldMigrate((String)ext)) continue;
            FileAssociations.setExtensionPath((String)ext);
        }
        FileAssociations.setProxyPath();
    }

    private Map createExtInfoCache(DocumentExtensions dext) {
        HashMap<String, DocumentExtensions.ExtInfo> extInfoCache = new HashMap<String, DocumentExtensions.ExtInfo>();
        for (DocumentExtensions.DocRecord rec : dext.getDocuments()) {
            for (DocumentExtensions.ExtInfo extInfo : rec.getExtensions()) {
                extInfoCache.put(extInfo.getExtension(), extInfo);
            }
        }
        return extInfoCache;
    }
}

