/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.util;

import com.sun.el.lang.ELSupport;
import com.sun.el.util.MessageFactory;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import javax.el.ELException;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;

public class ReflectionUtil {
    protected static final String[] EMPTY_STRING = new String[0];
    protected static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    protected static final Class[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    private ReflectionUtil() {
    }

    public static Class forName(String string) throws ClassNotFoundException {
        if (null == string || "".equals(string)) {
            return null;
        }
        Class<?> clazz = ReflectionUtil.forNamePrimitive(string);
        if (clazz == null) {
            if (string.endsWith("[]")) {
                String string2 = string.substring(0, string.length() - 2);
                clazz = Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
                clazz = Array.newInstance(clazz, 0).getClass();
            } else {
                clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            }
        }
        return clazz;
    }

    protected static Class forNamePrimitive(String string) {
        int n;
        if (string.length() <= 8 && (n = Arrays.binarySearch(PRIMITIVE_NAMES, string)) >= 0) {
            return PRIMITIVES[n];
        }
        return null;
    }

    public static Class[] toTypeArray(String[] stringArray) throws ClassNotFoundException {
        if (stringArray == null) {
            return null;
        }
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = ReflectionUtil.forName(stringArray[i]);
        }
        return classArray;
    }

    public static String[] toTypeNameArray(Class[] classArray) {
        if (classArray == null) {
            return null;
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return stringArray;
    }

    public static Method getMethod(Object object, Object object2, Class[] classArray) throws MethodNotFoundException {
        if (object == null || object2 == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", object, object2, ReflectionUtil.paramString(classArray)));
        }
        String string = object2.toString();
        Method method = ReflectionUtil.getMethod(object.getClass(), string, classArray);
        if (method == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", object, object2, ReflectionUtil.paramString(classArray)));
        }
        return method;
    }

    private static Method getMethod(Class clazz, String string, Class[] classArray) {
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        Class<?> clazz2 = method.getDeclaringClass();
        if (Modifier.isPublic(clazz2.getModifiers())) {
            return method;
        }
        for (Class<?> clazz3 : clazz2.getInterfaces()) {
            method = ReflectionUtil.getMethod(clazz3, string, classArray);
            if (method == null) continue;
            return method;
        }
        Class<?> clazz4 = clazz2.getSuperclass();
        if (clazz4 != null && (method = ReflectionUtil.getMethod(clazz4, string, classArray)) != null) {
            return method;
        }
        return null;
    }

    protected static final String paramString(Class[] classArray) {
        if (classArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(classArray[i].getName()).append(", ");
            }
            if (stringBuffer.length() > 2) {
                stringBuffer.setLength(stringBuffer.length() - 2);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static PropertyDescriptor getPropertyDescriptor(Object object, Object object2) throws ELException, PropertyNotFoundException {
        String string = ELSupport.coerceToString(object2);
        Object var3_3 = null;
        try {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!propertyDescriptorArray[i].getName().equals(string)) continue;
                return propertyDescriptorArray[i];
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new ELException((Throwable)introspectionException);
        }
        throw new PropertyNotFoundException(MessageFactory.get("error.property.notfound", object, string));
    }
}

