/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2.search;

import oracle.ideimpl.palette2.search.SearchMatcherStrategy;

public class SimpleContainsSearchStrategy
implements SearchMatcherStrategy {
    @Override
    public boolean matches(String searchToken, String targetItem) {
        if (searchToken != null && targetItem != null) {
            String normalizedSearchToken = SimpleContainsSearchStrategy.trimEmptySpacesBetweenTokens(searchToken.trim());
            String normalizedTargetItem = SimpleContainsSearchStrategy.trimEmptySpacesBetweenTokens(targetItem.trim());
            if (normalizedTargetItem.toLowerCase().contains(normalizedSearchToken.toLowerCase())) {
                return true;
            }
        }
        return false;
    }

    private static String trimEmptySpacesBetweenTokens(String spacedOutTokens) {
        StringBuilder tokensSeparatedWithSingleSpace = new StringBuilder();
        for (String token : spacedOutTokens.split(" ")) {
            if (!SimpleContainsSearchStrategy.hasAtLeastOneNonwhiteSpace(token)) continue;
            tokensSeparatedWithSingleSpace.append(token.trim());
        }
        return tokensSeparatedWithSingleSpace.toString();
    }

    private static boolean hasAtLeastOneNonwhiteSpace(String token) {
        char[] arr$ = token.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (Character.isWhitespace(c.charValue())) continue;
            return true;
        }
        return false;
    }
}

