/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.Component;
import java.util.Collection;
import oracle.ide.controller.ContextMenu;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.palette2.DefaultPaletteGroup;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.view.View;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteAugmentedItem;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteDockable;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteWindowImpl;
import oracle.ideimpl.palette2.SearchGroupUI;
import oracle.ideimpl.palette2.SearchSection;

public class SearchDockable
extends DockableWindow
implements PaletteDockable {
    public static final String VIEW_NAME = "PALETTE2_SEARCH";
    public static final String SEARCHGROUP_NAME = "SearchResultsGroup";
    private DefaultPaletteGroup _searchGroup;
    private SearchSection _searchSection;
    private PaletteGroupUI groupWindow;
    private String _cachedViewState;

    public SearchDockable() {
        super("PALETTEFACTORY.PALETTE2_SEARCH");
        this.createSearchGroup();
        this._cachedViewState = "list";
    }

    public int getDefaultVisibility(Layout layout) {
        return 32;
    }

    private void createSearchGroup() {
        this._searchGroup = new DefaultPaletteGroup(SEARCHGROUP_NAME, "Search results", SEARCHGROUP_NAME, "search");
        this._searchSection = new SearchSection("", "SearchResultsGroup.Section");
        this._searchGroup.addSection(this._searchSection);
    }

    public String getTabName() {
        return PaletteArb.getString(55);
    }

    public void hideResults() {
        ((PaletteWindowImpl)PaletteWindowImpl.getInstance()).removeDrawer((Dockable)this);
    }

    public void showSearchResults(Collection<PaletteAugmentedItem> paletteItems) {
        this._searchSection.removeAllItems();
        for (PaletteAugmentedItem item : paletteItems) {
            this._searchSection.addItem(item.getPaletteItem(), item.getPageName(), item.getGroupName());
        }
        if (this.groupWindow == null) {
            this.groupWindow = new SearchGroupUI(this._cachedViewState);
        }
        this.groupWindow.setData(this._searchGroup);
        PaletteWindowImpl paletteWindow = (PaletteWindowImpl)PaletteWindowImpl.getInstance();
        paletteWindow.addCloseableDrawer(this, 0);
        paletteWindow.expand((View)this);
        paletteWindow.setSearchThread(null);
        paletteWindow.updateDrawerHandlesVisibility();
    }

    public Component getGUI() {
        if (this.groupWindow == null) {
            this.groupWindow = new SearchGroupUI(this._cachedViewState);
        }
        return this.groupWindow;
    }

    public String getTitleName() {
        return this.getTabName();
    }

    @Override
    public void setData(PaletteGroup paletteGroup) {
    }

    @Override
    public String getViewState() {
        return null;
    }

    @Override
    public void toggleViewState() {
    }

    public ContextMenu getContextMenu() {
        return PaletteControllerUI.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idecomponentpalette_html");
    }
}

