/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.ide.extension.ExtensionRegistry;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.docking.DrawerWindow;
import oracle.ide.docking.DrawerWindowConfig;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.palette2.Palette;
import oracle.ide.palette2.PaletteConsumer;
import oracle.ide.palette2.PaletteEvent;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteListener;
import oracle.ide.palette2.PaletteManager;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePageProvider;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import oracle.ide.palette2.PaletteSection;
import oracle.ide.palette2.PaletteWindow;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.ideimpl.palette2.AllPages;
import oracle.ideimpl.palette2.CompositePalettePage;
import oracle.ideimpl.palette2.DeclaredPages;
import oracle.ideimpl.palette2.MyComponentsPageProvider;
import oracle.ideimpl.palette2.Palette1Provider;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteDockable;
import oracle.ideimpl.palette2.PaletteDockableFactory;
import oracle.ideimpl.palette2.PaletteHook;
import oracle.ideimpl.palette2.PaletteManagerImpl;
import oracle.ideimpl.palette2.PaletteSelectionElement;
import oracle.ideimpl.palette2.SearchThread;

public class PaletteWindowImpl
extends PaletteWindow
implements EditorListener,
ViewListener,
PalettePagesListener,
ActionListener,
Dockable,
DockableListener {
    protected ArrayList<PaletteListener> paletteListeners;
    private static final PaletteWindow _singleton = new PaletteWindowImpl();
    private final PaletteManager paletteManager = PaletteManager.getPaletteManager();
    private final PaletteControllerUI paletteController = PaletteControllerUI.getInstance();
    private final Palette palette = Palette.getInstance();
    private final List<PalettePages> providerPages = new ArrayList<PalettePages>();
    private List<String> palette1PageExclusions = new ArrayList<String>();
    private final List<PreferredPage> preferredPages = new ArrayList<PreferredPage>();
    private String currentPageSelection;
    private static boolean OPENED = false;
    private final List<String> pageList = new ArrayList<String>();
    private final PaletteComboBox pageComboBox = new PaletteComboBox(PaletteWindowImpl.getComboBoxModel(Collections.EMPTY_LIST));
    private JPanel _topSearchComponent;
    private JTextField _searchField;
    private ToolButton _startSearchButton;
    private ToolButton _stopSearchButton;
    private JLabel _searchingLabel;
    private JProgressBar _progressBar;
    private SearchThread _searchThread;
    private Editor _currentEditor = null;
    private View _currentView = null;
    private static boolean _isView = false;
    private String savedPageName = null;
    private static boolean _dockableHidden = true;
    private static boolean editorListenerAdded = false;
    private Collection<PaletteConsumer> _consumers = null;
    private DrawerWindow _drawerWindow;
    private PropertyChangeListener _editorReadyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("DELAY_PALETTE_LOAD".equals(evt.getPropertyName()) && Boolean.FALSE == evt.getNewValue() && evt.getSource() instanceof Editor) {
                Editor ed = (Editor)evt.getSource();
                ed.removePropertyChangeListener((PropertyChangeListener)this);
                if (ed == PaletteWindowImpl.this.getEditor()) {
                    PaletteWindowImpl.this.synchronizeWithEditor(ed, true);
                }
            }
        }
    };
    private FocusTraversalPolicy defaultFocusTraversalPolicy = new LayoutFocusTraversalPolicy();
    private boolean m_selectionChangedEventWasFired = false;
    private EditorComponentPalettePageSelectorStrategy pageSelectionStrategy = new EditorComponentPalettePageSelectorStrategy();
    private boolean showTypeInProgress = false;

    public PaletteWindowImpl() {
        super(PaletteWindowImpl.viewId());
        DockStation.getDockStation().addDockableListener((DockableListener)this, (Dockable)this);
        this.paletteListeners = new ArrayList();
        this.registerPageProviders();
        this.pageComboBox.addActionListener(this.paletteController);
    }

    @Override
    public PaletteItem getFocusedItem() {
        return this.paletteController.getCurrentlyFocusedPaletteItem();
    }

    private void createDrawerWindow() {
        DrawerWindowConfig c = new DrawerWindowConfig();
        c.icon(this.getTabIcon());
        c.tabName(PaletteArb.getString(1));
        c.titleName(PaletteArb.getString(0));
        c.topComponent((JComponent)this.createTopComponent());
        c.type(this.getType());
        this._drawerWindow = new DrawerWindow(this.getId(), (View)this, c);
        this._drawerWindow.expandOneDrawerAtATime();
        this._drawerWindow.hideHandleIfOnlyOneDrawerShown();
        Container drawerWindow = (Container)this._drawerWindow.getGUI();
        drawerWindow.setFocusTraversalPolicy(new PaletteWindowFocusTraversalPolicy());
        drawerWindow.setFocusCycleRoot(true);
    }

    public Controller getController() {
        return this._drawerWindow != null ? this._drawerWindow.getController() : this.paletteController;
    }

    private void registerPageProviders() {
        PaletteHook hook = (PaletteHook)ExtensionRegistry.getExtensionRegistry().getHook(PaletteHook.NAME);
        if (hook == null) {
            this.printError("oracle.ide.palette2: ExtensionRegistry getHook failed to find PaletteHook. \n");
            return;
        }
        List<Class> providers = hook.getProviderClasses();
        if (providers == null) {
            this.printError("oracle.ide.palette2 error: no extension palette page providers found.");
        } else {
            this.registerPageProviders(providers);
        }
        this.palette1PageExclusions = hook.getPalette1PageExclusions();
    }

    private void registerPageProviders(List<Class> providers) {
        PalettePageProvider declaredPalette1PageProvider = null;
        String declaredPalette1PageProviderClassName = PaletteArb.getString(5);
        for (Class provider : providers) {
            try {
                PalettePageProvider declaredPageProvider = (PalettePageProvider)provider.newInstance();
                if (provider.getName().equals(declaredPalette1PageProviderClassName)) {
                    declaredPalette1PageProvider = declaredPageProvider;
                    continue;
                }
                this.addPageProvider(declaredPageProvider);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {}
        }
        if (declaredPalette1PageProvider != null) {
            this.addPageProvider(declaredPalette1PageProvider);
        }
    }

    private void printError(String errorMessage) {
    }

    private void consumerListeners() {
        this._consumers = ((PaletteManagerImpl)this.paletteManager).getPaletteConsumers();
        if (this._consumers == null) {
            return;
        }
        for (PaletteConsumer consumer : this._consumers) {
            consumer.getConsumerView().addViewListener((ViewListener)this);
        }
    }

    public Component getGUI() {
        if (this._consumers == null) {
            this.consumerListeners();
        }
        Component gui = this.drawerWindowGUI();
        if (this.m_selectionChangedEventWasFired || this._synchronizePalette(this.getEditor())) {
            return gui;
        }
        return null;
    }

    private Component drawerWindowGUI() {
        if (this._drawerWindow == null) {
            this.createDrawerWindow();
        }
        return this._drawerWindow.getGUI();
    }

    private JPanel createTopComponent() {
        if (this._topSearchComponent == null) {
            this._topSearchComponent = new JPanel(new GridBagLayout());
            Insets insets = new Insets(2, 2, 2, 2);
            this._topSearchComponent.add((Component)this.pageComboBox, this.constraintsForPageComboBox(insets));
            this._topSearchComponent.add((Component)this.searchToolbar(), this.constraintsForToolbar(insets));
            this._searchingLabel = new JLabel(PaletteArb.getString(54));
            this._topSearchComponent.add((Component)this._searchingLabel, this.constraintsForSearchingLabel(insets));
            this._progressBar = new JProgressBar(0, 0, 100);
            this._topSearchComponent.add((Component)this._progressBar, this.constraintsForProgressBar(insets));
            this._topSearchComponent.setVisible(false);
        }
        this.setSearchThread(null);
        return this._topSearchComponent;
    }

    private GridBagConstraints constraintsForPageComboBox(Insets insets) {
        return new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, insets, 0, 0);
    }

    private Toolbar searchToolbar() {
        Toolbar toolbar = new Toolbar();
        toolbar.add((Component)new JLabel(IdeArb.getIcon((int)111)));
        JPanel panelSearch = new JPanel(new BorderLayout());
        this._searchField = new JTextField(30);
        this._searchField.setBorder(BorderFactory.createEmptyBorder());
        this._searchField.addActionListener(this);
        panelSearch.add((Component)this._searchField, "Center");
        toolbar.add((Component)panelSearch);
        this._startSearchButton = toolbar.add((ToggleAction)this.localAction(PaletteManagerImpl.SEARCH_GO_ID));
        this._stopSearchButton = toolbar.add((ToggleAction)this.localAction(PaletteManagerImpl.SEARCH_STOP_ID));
        return toolbar;
    }

    private IdeAction localAction(int cmdId) {
        return IdeAction.newLocalAction((int)cmdId, (View)this);
    }

    private Object constraintsForToolbar(Insets insets) {
        return new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, insets, 0, 0);
    }

    private Object constraintsForSearchingLabel(Insets insets) {
        return new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0);
    }

    private Object constraintsForProgressBar(Insets insets) {
        return new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0);
    }

    private void addPageProvider(PalettePageProvider declaredPageProvider) {
        this.palette.addPalettePageProvider(declaredPageProvider);
    }

    public static PaletteWindow getInstance() {
        return _singleton;
    }

    public void dockableShown(DockableEvent e) {
        _dockableHidden = false;
        super.dockableShown(e);
        this._synchronizePalette(this.getEditor());
    }

    public void dockableHidden(DockableEvent e) {
        _dockableHidden = true;
        this._currentEditor = null;
        super.dockableHidden(e);
    }

    public PaletteItem getSelectedItem() {
        return this.paletteController.getSelectedItem();
    }

    @Override
    public void unSelectSelectedItem() {
        this.paletteController.unSelectSelectedItem(false);
    }

    public String getSelectedPageName() {
        return this.pageComboBox.getSelectedString();
    }

    public PalettePage getSelectedPage() {
        return this.getPageFromProviderList(this.getSelectedPageName());
    }

    public void selectionChanged() {
        if (this.m_selectionChangedEventWasFired) {
            return;
        }
        this.m_selectionChangedEventWasFired = true;
        String pageToShow = this.pageComboBox.getSelectedString();
        this.showPage(pageToShow);
        PalettePage palettePage = this.getSelectedPage();
        if (palettePage != null) {
            this.fireSelectionChanged(new PaletteEvent(palettePage, "PALETTE2_SELECTION_CHANGED"));
        }
        if (this.pageSelectionStrategy != null && !this.showTypeInProgress) {
            this.pageSelectionStrategy.setLRUPage(this.getEditor(), pageToShow);
        }
        this.m_selectionChangedEventWasFired = false;
    }

    private void clearContext() {
        this.clearPalettePages(this.providerPages);
        this.pageList.clear();
        this.preferredPages.clear();
    }

    private void clearPalettePages(List<PalettePages> providerPages) {
        for (PalettePages p : providerPages) {
            p.removePalettePagesListener(this);
        }
        providerPages.clear();
    }

    public void stateChange(int newState) {
        switch (newState) {
            case 1: {
                if (OPENED || !(OPENED = this._synchronizePalette(this.getEditor()))) break;
                this.firePaletteOpened(new PaletteEvent(this.paletteManager, "PALETTE2_OPENED"));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (!OPENED) break;
                this.firePaletteClosed(new PaletteEvent(this.paletteManager, "PALETTE2_CLOSED"));
                this.clearContext();
            }
        }
        super.stateChange(newState);
    }

    public View getEditor() {
        if (_isView) {
            return this._currentView;
        }
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor == null || editor.getContext() == null || editor.getContext().getNode() == null) {
            editor = null;
        }
        return editor;
    }

    private boolean _synchronizePalette(View view) {
        if (!editorListenerAdded) {
            EditorManager.getEditorManager().addEditorListener((EditorListener)this);
            editorListenerAdded = true;
        }
        if (view instanceof Editor) {
            return this.synchronizeWithEditor((Editor)view);
        }
        return this.synchronizeWithView(view);
    }

    private boolean synchronizeWithEditor(Editor editor) {
        return this.synchronizeWithEditor(editor, false);
    }

    private boolean synchronizeWithEditor(Editor editor, boolean forceShowType) {
        boolean sameEditor;
        boolean bl = sameEditor = this._currentEditor == editor;
        if (this._currentEditor != null) {
            this._currentEditor.removePropertyChangeListener(this._editorReadyListener);
        }
        if (editor == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PaletteWindowImpl.this.showPageInactive();
                }
            });
        }
        this._currentEditor = editor;
        if (Boolean.TRUE == editor.getEditorAttribute("DELAY_PALETTE_LOAD")) {
            editor.addPropertyChangeListener(this._editorReadyListener);
            this.showPageLoading();
            return true;
        }
        if (!sameEditor || forceShowType) {
            this.showType(true, (View)editor);
        }
        return true;
    }

    private boolean synchronizeWithView(View view) {
        this._currentView = view;
        this.showType(true, view);
        return true;
    }

    private boolean refreshPalettePages(View editor) {
        if (editor == null) {
            return false;
        }
        Context context = editor.getContext();
        List<PalettePageProvider> palettePageProviders = this.palette.getPalettePageProviders();
        if (palettePageProviders == null) {
            return false;
        }
        this.clearContext();
        TreeSet provList = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        PalettePageProvider myComponentsPageProvider = null;
        for (PalettePageProvider pageProvider : palettePageProviders) {
            if (pageProvider.getClass().getName().equals(MyComponentsPageProvider.class.getName())) {
                myComponentsPageProvider = pageProvider;
                continue;
            }
            PalettePages provPages = null;
            try {
                provPages = pageProvider.createPalettePages(context);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (provPages == null) continue;
            this.addProvider(provPages, provList);
        }
        try {
            if (provList.size() > 1) {
                this.pageList.add(PaletteArb.getString(57));
            }
            this.pageList.addAll(provList);
            if (myComponentsPageProvider != null) {
                PalettePages provPages = null;
                try {
                    provPages = myComponentsPageProvider.createPalettePages(context);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                if (provPages != null) {
                    this.addProvider(provPages, provList);
                    this.pageList.add(PaletteArb.getString(8));
                }
            }
            this.removePalettePagesWithoutPaletteItems();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void addProvider(PalettePages provPages, SortedSet provList) {
        this.providerPages.add(provPages);
        provPages.addPalettePagesListener(this);
        Collection<PalettePage> providerPalettePages = provPages.getPages();
        if (providerPalettePages != null) {
            PalettePage preferredPage = provPages.getPreferredPage();
            if (preferredPage != null) {
                this.preferredPages.add(new PreferredPage(preferredPage, provPages.getPreferredPageRank()));
            }
            for (PalettePage providerPage : providerPalettePages) {
                String name = providerPage.getName();
                if (provList.contains(name)) continue;
                provList.add(name);
            }
        }
    }

    @Override
    public void palettePagesChanged(Set<PalettePage> addedPages, Set<PalettePage> removedPages, Set<PalettePage> updatedPages) {
        boolean refreshPageList = false;
        boolean refreshCurrentPage = false;
        final String currentPage = this.pageComboBox.getSelectedString();
        if (addedPages != null && !addedPages.isEmpty()) {
            refreshPageList = true;
            for (PalettePage palettePage : addedPages) {
                if (!palettePage.getName().equals(currentPage)) continue;
                refreshCurrentPage = true;
                break;
            }
        }
        if (removedPages != null && !removedPages.isEmpty() && !refreshCurrentPage) {
            refreshPageList = true;
            for (PalettePage palettePage : removedPages) {
                if (!palettePage.getName().equals(currentPage)) continue;
                refreshCurrentPage = true;
                break;
            }
        }
        if (updatedPages != null && !refreshCurrentPage) {
            for (PalettePage palettePage : updatedPages) {
                if (palettePage == null || !palettePage.getName().equals(currentPage)) continue;
                refreshCurrentPage = true;
                break;
            }
        }
        if (refreshPageList) {
            final HashSet<PalettePage> adds = new HashSet<PalettePage>();
            if (addedPages != null) {
                adds.addAll(addedPages);
            }
            final HashSet<PalettePage> removed = new HashSet<PalettePage>();
            if (removedPages != null) {
                removed.addAll(removedPages);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PaletteWindowImpl.this.updatePageList(adds, removed);
                    PaletteWindowImpl.this.showType(false, null);
                }
            });
            return;
        }
        if (refreshCurrentPage) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PaletteWindowImpl.this.showPage(currentPage);
                    }
                });
            } else {
                this.showPage(currentPage);
            }
        }
    }

    private void updatePageList(Set<PalettePage> addedPages, Set<PalettePage> removedPages) {
        TreeSet<String> provList = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        boolean appendMyComponents = false;
        for (String pageName : this.pageList) {
            if (pageName.equals(PaletteArb.getString(57))) continue;
            if (pageName.equals(PaletteArb.getString(8))) {
                appendMyComponents = true;
                continue;
            }
            provList.add(pageName);
        }
        if (addedPages != null && !addedPages.isEmpty()) {
            for (PalettePage page : addedPages) {
                provList.add(page.getName());
            }
        }
        if (removedPages != null && !removedPages.isEmpty()) {
            for (PalettePage page : removedPages) {
                provList.remove(page.getName());
            }
        }
        this.pageList.clear();
        if (provList.size() > 1) {
            this.pageList.add(PaletteArb.getString(57));
        }
        this.pageList.addAll(provList);
        if (appendMyComponents) {
            this.pageList.add(PaletteArb.getString(8));
        }
        this.removePalettePagesWithoutPaletteItems();
    }

    private void removePalettePagesWithoutPaletteItems() {
        ArrayList<String> pagesToBeRemoved = new ArrayList<String>();
        for (String pageName : this.pageList) {
            if (PaletteArb.getString(8).equals(pageName) || PaletteArb.getString(57).equals(pageName)) continue;
            boolean foundAtLeastOneItemUnderPage = false;
            PalettePage palettePage = this.getPageFromProviderList(pageName);
            if (palettePage == null) continue;
            Iterator<PaletteGroup> paletteGroupIterator = palettePage.getGroups().iterator();
            while (!foundAtLeastOneItemUnderPage && paletteGroupIterator.hasNext()) {
                PaletteGroup paletteGroup = paletteGroupIterator.next();
                Iterator<PaletteSection> paletteSectionIterator = paletteGroup.getSections().iterator();
                while (!foundAtLeastOneItemUnderPage && paletteSectionIterator.hasNext()) {
                    PaletteSection paletteSection = paletteSectionIterator.next();
                    if (paletteSection.getItems() == null || paletteSection.getItems().size() <= 0) continue;
                    foundAtLeastOneItemUnderPage = true;
                }
            }
            if (foundAtLeastOneItemUnderPage) continue;
            pagesToBeRemoved.add(pageName);
        }
        this.pageList.removeAll(pagesToBeRemoved);
    }

    public List<PalettePages> getProviderPages() {
        return Collections.unmodifiableList(this.providerPages);
    }

    public List<String> getPageList() {
        return Collections.unmodifiableList(this.pageList);
    }

    public PalettePages getPalette1ProviderPages() {
        for (PalettePages provPages : this.providerPages) {
            if (!(provPages instanceof Palette1Provider)) continue;
            return provPages;
        }
        return null;
    }

    public List<String> getPalette1PageExclusions() {
        return this.palette1PageExclusions;
    }

    public void showType(boolean refresh, View editor) {
        if (this.showTypeInProgress || refresh && !this.refreshPalettePages(editor)) {
            return;
        }
        if (this.pageList.size() > 0) {
            this.showTypeInProgress = true;
            String pageToShow = null;
            this.pageComboBox.setModel(PaletteWindowImpl.getComboBoxModel(this.pageList));
            String string = pageToShow = editor != null ? this.pageSelectionStrategy.getPage(editor) : this.pageSelectionStrategy.getPage();
            if (pageToShow != null) {
                this.pageComboBox.setSelectedItem(pageToShow);
            }
            this.showTypeInProgress = false;
        } else {
            this.showPageInactive();
        }
    }

    private String firstPage() {
        String page = this.pageComboBox.getItemAt(0).toString();
        if (page.equals(PaletteArb.getString(57))) {
            return this.pageComboBox.getItemAt(1).toString();
        }
        return page;
    }

    private void showPage(String pageToShow) {
        if (this.currentPageSelection == null || this.currentPageSelection.length() <= 0) {
            this.currentPageSelection = pageToShow;
        } else if (!this.currentPageSelection.equals(pageToShow)) {
            this.currentPageSelection = pageToShow;
        }
        PalettePage palettePage = this.getPageFromProviderList(pageToShow);
        if (palettePage == null || this.getEditor() == null) {
            this.showPageInactive();
            return;
        }
        View editor = this.getEditor();
        if (this._topSearchComponent != null) {
            this._topSearchComponent.setVisible(true);
        }
        PaletteDockableFactory.getInstance().hideDockables();
        this.showGroups(palettePage, editor);
    }

    void hide(View view) {
        this._drawerWindow.hide(view);
    }

    private void showPageLoading() {
        this.showPageInactive(PaletteArb.getString(62));
    }

    private void showPageInactive() {
        this.showPageInactive(PaletteArb.getString(53));
    }

    private void showPageInactive(String type) {
        ViewId viewId = new ViewId("PALETTEFACTORY", type);
        Dockable dockable = DockStation.getDockStation().getDockable(viewId);
        if (dockable == null) {
            dockable = PaletteDockableFactory.getInstance().getDockable(viewId);
            this.addDrawerThatCanHideHandle(dockable);
        }
        PaletteDockableFactory.getInstance().hideDockables();
        this._topSearchComponent.setVisible(false);
        if (dockable instanceof View) {
            this._drawerWindow.show((View)dockable);
        }
        this.updateDrawerHandlesVisibility();
    }

    private boolean isShowForGroupType(PaletteGroup paletteGroup, View editor) {
        Object object = editor = editor == null ? this._currentEditor : editor;
        if (editor == null) {
            return false;
        }
        List showForTypes = (List)paletteGroup.getData("showForTypes");
        if (showForTypes == null) {
            return false;
        }
        Context context = editor.getContext();
        if (context == null) {
            return false;
        }
        Node node = context.getNode();
        if (node == null) {
            return false;
        }
        String fileType = DeclaredPages.getSuffix(node.getURL());
        if (fileType == null) {
            return false;
        }
        for (String type : showForTypes) {
            if (!DeclaredPages.isCorrectNode(fileType, type)) continue;
            return true;
        }
        return false;
    }

    private PalettePage getPageFromProviderList(String name) {
        int size;
        ArrayList<PalettePage> palettePageList = new ArrayList<PalettePage>();
        if (name != null) {
            if (name.equals(PaletteArb.getString(57))) {
                Collection<PalettePage> palettePages = AllPages.getInstance().getPages();
                Iterator<PalettePage> i = palettePages.iterator();
                palettePageList.add(i.next());
            } else {
                for (PalettePages provPages : Collections.unmodifiableList(this.providerPages)) {
                    for (PalettePage p : provPages.getPages()) {
                        if (!p.getName().equals(name)) continue;
                        palettePageList.add(p);
                    }
                }
            }
        }
        if ((size = palettePageList.size()) == 0) {
            return null;
        }
        return palettePageList.size() == 1 ? (PalettePage)palettePageList.get(0) : new CompositePalettePage(palettePageList.toArray(new PalettePage[size]));
    }

    private void showGroups(PalettePage palettePage, View editor) {
        if (this.getEditor() == null || this._drawerWindow == null) {
            return;
        }
        Context context = this.getEditor().getContext();
        Collection<PaletteGroup> paletteGroups = palettePage.getGroups();
        for (PaletteGroup paletteGroup : paletteGroups) {
            String name = palettePage.getName();
            String gName = paletteGroup.getName();
            if (gName != null && gName.length() > 0) {
                name = name + "-" + gName;
            }
            ViewId viewId = new ViewId("PALETTEFACTORY", name);
            Dockable dockable = DockStation.getDockStation().getDockable(viewId);
            if (dockable == null) {
                dockable = PaletteDockableFactory.getInstance().getDockable(viewId);
                if (dockable instanceof PaletteDockable) {
                    ((PaletteDockable)dockable).setData(paletteGroup);
                    if (paletteGroups.size() == 1) {
                        this.addDrawerThatCanHideHandle(dockable);
                        continue;
                    }
                    if (!paletteGroup.isVisible(context)) {
                        DrawerConfig config = new DrawerConfig(paletteGroup.getName(), DrawerConfig.State.HIDDEN);
                        this.addDrawer(dockable, config);
                        continue;
                    }
                    this.addDrawer(dockable);
                    if (this.isShowForGroupType(paletteGroup, editor)) {
                        this._drawerWindow.expand((View)((DockableWindow)dockable));
                        continue;
                    }
                    List<View> collapseList = Collections.singletonList((View)dockable);
                    this._drawerWindow.togglePanelsWithoutAnimation(null, collapseList);
                    continue;
                }
                name = name != null && name.length() > 0 ? name : "null";
                continue;
            }
            View view = null;
            if (dockable instanceof PaletteDockable) {
                view = (View)dockable;
            }
            if (dockable instanceof DockableWindow) {
                view = this.undecorateIfNecessary(dockable);
            }
            ((PaletteDockable)view).setData(paletteGroup);
            if (paletteGroup.isVisible(context)) {
                this._drawerWindow.show(view);
                continue;
            }
            this._drawerWindow.hide(view);
        }
        this.repaintGUI();
        this.updateDrawerHandlesVisibility();
    }

    private void addDrawer(Dockable w) {
        if (this._drawerWindow != null) {
            this._drawerWindow.addDrawer((DockableWindow)w);
        }
    }

    private void addDrawer(Dockable w, DrawerConfig config) {
        if (this._drawerWindow != null) {
            this._drawerWindow.addDrawer((View)((DockableWindow)w), config);
        }
    }

    private void addDrawerThatCanHideHandle(Dockable w) {
        DockableWindow dw = (DockableWindow)w;
        if (this._drawerWindow != null) {
            this._drawerWindow.addDrawerThatCanHideHandle(dw);
            this._drawerWindow.expand((View)dw);
        }
    }

    void addDrawer(Dockable w, int index) {
        if (this._drawerWindow != null) {
            this._drawerWindow.addDrawer((DockableWindow)w, index);
        }
    }

    void updateDrawerHandlesVisibility() {
        this._drawerWindow.updateDrawerHandlesVisibility();
    }

    void addCloseableDrawer(DockableWindow view, int index) {
        this._drawerWindow.addCloseableDrawer(view, index);
    }

    View undecorateIfNecessary(Dockable dockable) {
        return this._drawerWindow.undecorateIfNecessary((DockableWindow)dockable);
    }

    void removeDrawer(Dockable w) {
        this._drawerWindow.removeIfPresent((View)w);
    }

    private void repaintGUI() {
        if (this.getGUI() != null) {
            this.getGUI().repaint();
        }
    }

    private static ComboBoxModel getComboBoxModel(Collection initialData) {
        DefaultComboBoxModel comboBoxModel = new DefaultComboBoxModel();
        for (Object data : initialData) {
            comboBoxModel.addElement(data);
        }
        return comboBoxModel;
    }

    @Override
    public void addPaletteListener(PaletteListener paletteListener) {
        if (this.paletteListeners == null) {
            this.paletteListeners = new ArrayList();
        }
        this.paletteListeners.add(paletteListener);
    }

    @Override
    public void removePaletteListener(PaletteListener paletteListener) {
        this.paletteListeners.remove(paletteListener);
    }

    public void firePaletteOpened(PaletteEvent event) {
        for (PaletteListener l : this.paletteListeners) {
            l.paletteOpened(event);
        }
    }

    public void firePaletteClosed(PaletteEvent event) {
        for (PaletteListener l : this.paletteListeners) {
            l.paletteClosed(event);
        }
    }

    public void fireSelectionChanged(PaletteEvent event) {
        try {
            this.fireEvent(new PaletteListenerHandler(){

                @Override
                public void handle(PaletteListener l, PaletteEvent event) {
                    l.selectionChanged(event);
                }
            }, event);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fireItemSelected(PaletteEvent event) {
        this.updateSelection();
        this.fireEvent(new PaletteListenerHandler(){

            @Override
            public void handle(PaletteListener l, PaletteEvent event) {
                l.itemSelected(event);
            }
        }, event);
    }

    public void fireItemUnselected(PaletteEvent event) {
        this.fireEvent(new PaletteListenerHandler(){

            @Override
            public void handle(PaletteListener l, PaletteEvent event) {
                l.itemUnselected(event);
            }
        }, event);
    }

    public void fireStickyModeActivated(PaletteEvent event) {
        this.fireEvent(new PaletteListenerHandler(){

            @Override
            public void handle(PaletteListener l, PaletteEvent event) {
                l.stickyModeActivated(event);
            }
        }, event);
    }

    public void fireStickyModeDeactivated(PaletteEvent event) {
        this.fireEvent(new PaletteListenerHandler(){

            @Override
            public void handle(PaletteListener l, PaletteEvent event) {
                l.stickyModeDeactivated(event);
            }
        }, event);
    }

    private void fireEvent(PaletteListenerHandler handler, PaletteEvent event) {
        ArrayList<PaletteListener> listeners = this.cloneToAvoidConcurrentModificationException(this.paletteListeners);
        for (PaletteListener l : listeners) {
            handler.handle(l, event);
        }
    }

    private ArrayList<PaletteListener> cloneToAvoidConcurrentModificationException(ArrayList<PaletteListener> source) {
        return (ArrayList)source.clone();
    }

    public void editorOpened(Editor editor) {
    }

    public void editorActivated(Editor editor) {
        _isView = false;
        if (!_dockableHidden) {
            this.synchronizeWithEditor(editor);
        }
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        if (editor != null && editor == this._currentEditor) {
            this._currentEditor = null;
            this._currentView = null;
            this.clearContext();
        }
        if (this.isVisible()) {
            if (EditorManager.getEditorManager().getAllEditors().size() == 0) {
                this.pageComboBox.setModel(PaletteWindowImpl.getComboBoxModel(this.pageList));
                this.showPageInactive();
            } else {
                Editor ed = EditorManager.getEditorManager().getCurrentEditor();
                if (ed != null) {
                    this.synchronizeWithEditor(ed);
                } else {
                    this.showPageInactive();
                }
            }
        }
        this.pageSelectionStrategy.setLRUPage((View)editor, null);
    }

    public void viewActivated(ViewEvent e) {
        _isView = true;
        View vw = e.getView();
        if (!_dockableHidden) {
            this.synchronizeWithView(vw);
        }
    }

    public void viewDeactivated(ViewEvent e) {
    }

    public void viewClosed(ViewEvent e) {
        View vw = e.getView();
        if (vw != null && vw == this._currentView) {
            this._currentView = null;
            this._currentEditor = null;
            _isView = false;
            this.clearContext();
            this.pageComboBox.setModel(PaletteWindowImpl.getComboBoxModel(this.pageList));
            this.showPageInactive();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._searchField == source) {
            this.doSearch();
        }
    }

    public void doSearch() {
        String searchPredicate = this._searchField.getText().trim();
        this._searchField.selectAll();
        SearchThread searchThread = new SearchThread(this, searchPredicate);
        this.runSearch(searchThread);
    }

    private void runSearch(SearchThread searchThread) {
        this.setSearchThread(searchThread);
        try {
            searchThread.setPriority(Thread.currentThread().getPriority() - 1);
            searchThread.start();
        }
        catch (RuntimeException e) {
            this.setSearchThread(null);
            throw e;
        }
    }

    void expand(View view) {
        this._drawerWindow.togglePanelsWithAnimation(Collections.singletonList(view), null);
    }

    void setSearchThread(SearchThread searchThread) {
        boolean isSearching = searchThread != null;
        this._startSearchButton.setVisible(!isSearching);
        this._searchField.setEnabled(!isSearching);
        this._stopSearchButton.setVisible(isSearching);
        this._searchingLabel.setVisible(isSearching);
        this._progressBar.setVisible(isSearching);
        this._searchThread = searchThread;
        if (!isSearching) {
            this._searchField.requestFocus();
        }
    }

    public void stopSearch() {
        this._searchThread.abortSearch();
    }

    public void setSearchProgress(int progress, int total) {
        BoundedRangeModel model = this._progressBar.getModel();
        model.setRangeProperties(progress, 0, 0, total, false);
        this._progressBar.repaint();
    }

    public PaletteItem getItem(String providerId, String itemId) {
        PalettePages provPages;
        PaletteItem pItem = null;
        Iterator<PalettePages> i$ = this.providerPages.iterator();
        while (i$.hasNext() && (pItem = (provPages = i$.next()).getItem(providerId, itemId)) == null) {
        }
        return pItem;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idecomponentpalette_html");
    }

    public int getDefaultVisibility(Layout layout) {
        String showPaletteProperty = layout.getProperty("Layout.ShowPalette", null);
        boolean showPalette1 = Boolean.valueOf(showPaletteProperty);
        String raisePaletteProperty = layout.getProperty("Layout.RaisePalette", showPalette1 ? "true" : "false");
        boolean raisePalette1 = Boolean.valueOf(raisePaletteProperty);
        String showPalette2Property = layout.getProperty("Layout.ShowPalette2", null);
        boolean showPalette2 = Boolean.valueOf(showPalette2Property);
        String raisePalette2Property = layout.getProperty("Layout.RaisePalette2", showPalette2 ? "true" : "false");
        boolean raisePalette2 = Boolean.valueOf(raisePalette2Property);
        boolean showPalette = showPalette1 | showPalette2;
        boolean raisePalette = raisePalette1 | raisePalette2;
        return (showPalette ? 1 : 0) | (raisePalette ? 4 : 0);
    }

    public String getTabName() {
        return PaletteArb.getString(0);
    }

    public Icon getTabIcon() {
        return PaletteArb.getIcon(2);
    }

    public String getTitleName() {
        return PaletteArb.getString(0);
    }

    public String getUniqueName() {
        return "PALETTEFACTORY.PALETTE";
    }

    public void loadLayout(PropertyAccess p) {
        if (Ide.isStarting()) {
            this.savedPageName = p.getProperty("pageSelection", "");
        }
    }

    public void saveLayout(PropertyAccess p) {
        this.removeSearchResults();
        p.setProperty("pageSelection", this.getSelectedPageName());
    }

    private void removeSearchResults() {
        ViewId viewId = new ViewId("PALETTEFACTORY", "PALETTE2_SEARCH");
        Dockable searchResults = DockStation.getDockStation().getDockable(viewId);
        if (searchResults == null) {
            return;
        }
        this.removeDrawer(searchResults);
    }

    public String getMenuTitle() {
        return this.getTabName();
    }

    @Override
    public ContextMenu getContextMenu() {
        return this.paletteController.getContextMenu();
    }

    protected Element[] getSelectionFromUI() {
        PaletteItem paletteItem = this.getSelectedItem();
        if (paletteItem == null) {
            return new Element[0];
        }
        PaletteSelectionElement element = new PaletteSelectionElement(paletteItem);
        return new Element[]{element};
    }

    public class PaletteComboBox
    extends JComboBox {
        private static final String DFT_NAME = "ComponentPaletteComboBox";
        String lastSelection;

        public PaletteComboBox(ComboBoxModel model) {
            super(model);
            this.setName(DFT_NAME);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PaletteWindowImpl.this._drawerWindow != null && PaletteWindowImpl.this._drawerWindow.getGUI() != null) {
                        PaletteWindowImpl.this._drawerWindow.getGUI().repaint();
                    }
                }
            });
        }

        public String getSelectedString() {
            return (String)this.getSelectedItem();
        }
    }

    private class PreferredPage {
        final PalettePage page;
        final float rank;

        PreferredPage(PalettePage page, float rank) {
            this.page = page;
            this.rank = rank;
        }
    }

    private static interface PaletteListenerHandler {
        public void handle(PaletteListener var1, PaletteEvent var2);
    }

    private class EditorComponentPalettePageSelectorStrategy {
        private ConcurrentHashMap<PalettePageKey, String> editor2ActivePage = new ConcurrentHashMap();

        private EditorComponentPalettePageSelectorStrategy() {
        }

        public String getPage(View view) {
            String pageToShow = null;
            PalettePageKey ppk = new PalettePageKey(view);
            if (this.editor2ActivePage.containsKey(ppk)) {
                pageToShow = this.editor2ActivePage.get(ppk);
            }
            if (!PaletteWindowImpl.this.pageList.contains(pageToShow)) {
                pageToShow = this.getPage();
            }
            return pageToShow;
        }

        public String getPage() {
            String pageToShow = null;
            if (!this.hasSavedPage()) {
                if (PaletteWindowImpl.this.preferredPages != null && !PaletteWindowImpl.this.preferredPages.isEmpty()) {
                    String preferredPageName = null;
                    float preferredPageRank = -1.0f;
                    for (PreferredPage preferredPage : PaletteWindowImpl.this.preferredPages) {
                        float rank = preferredPage.rank;
                        if (rank <= preferredPageRank) continue;
                        String name = preferredPage.page.getName();
                        if (!PaletteWindowImpl.this.pageList.contains(name)) continue;
                        preferredPageRank = rank;
                        preferredPageName = name;
                    }
                    pageToShow = preferredPageName;
                } else {
                    pageToShow = PaletteWindowImpl.this.getSelectedPageName() != null && PaletteWindowImpl.this.pageList.contains(PaletteWindowImpl.this.getSelectedPageName()) ? PaletteWindowImpl.this.getSelectedPageName() : PaletteWindowImpl.this.firstPage();
                }
            } else {
                pageToShow = PaletteWindowImpl.this.savedPageName;
                PaletteWindowImpl.this.savedPageName = null;
            }
            return pageToShow;
        }

        private boolean hasSavedPage() {
            return PaletteWindowImpl.this.savedPageName != null && PaletteWindowImpl.this.pageList.contains(PaletteWindowImpl.this.savedPageName);
        }

        public void setLRUPage(View view, String page) {
            if (view == null) {
                return;
            }
            if (view instanceof Editor) {
                Editor editor = (Editor)view;
                PalettePageKey ppk = new PalettePageKey((View)editor);
                if (page != null) {
                    this.editor2ActivePage.put(ppk, page);
                } else {
                    this.removeById(editor.getTitleLabel());
                }
            } else {
                PalettePageKey ppk = new PalettePageKey(view);
                if (page != null) {
                    this.editor2ActivePage.put(ppk, page);
                } else {
                    this.removeById(view.getId());
                }
            }
        }

        private void removeById(String id) {
            for (PalettePageKey nextPPK : this.editor2ActivePage.keySet()) {
                if (!nextPPK.title.equals(id)) continue;
                this.editor2ActivePage.remove(nextPPK);
            }
        }
    }

    private class PalettePageKey {
        String title;
        Class editorClass;

        PalettePageKey(View view) {
            if (view instanceof Editor) {
                Editor editor = (Editor)view;
                assert (editor.getTitleLabel() != null);
                this.title = editor.getTitleLabel();
                if (this.title.endsWith("*")) {
                    this.title = this.title.substring(0, this.title.length() - 1);
                }
                this.editorClass = editor.getClass();
            } else {
                assert (view.getId() != null);
                this.title = view.getId();
                this.editorClass = view.getClass();
            }
        }

        public boolean equals(Object obj) {
            if (obj != null) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof PalettePageKey) {
                    return this.title.equals(((PalettePageKey)obj).title) && this.editorClass.equals(((PalettePageKey)obj).editorClass);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.title.hashCode() + this.editorClass.hashCode();
        }
    }

    public class PaletteWindowFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private int FORWARD = 1;
        private int BACKWARD = -1;

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            List<View> selectedPageViews;
            Component componentFollowingInTabTraversalSequence = null;
            componentFollowingInTabTraversalSequence = aComponent == PaletteWindowImpl.this.pageComboBox ? PaletteWindowImpl.this._searchField : (aComponent == PaletteWindowImpl.this._searchField ? ((selectedPageViews = this.currentShowingPageViews()).size() > 0 ? this.sendFocusToView(selectedPageViews.get(0), aContainer, aComponent, this.FORWARD) : this.getLastComponent(aContainer)) : (aComponent == PaletteWindowImpl.this._drawerWindow.getMinimizerTray() ? PaletteWindowImpl.this.pageComboBox : this.findDrawerCandidate(aContainer, aComponent, aComponent, this.FORWARD)));
            return componentFollowingInTabTraversalSequence != null ? componentFollowingInTabTraversalSequence : this.getLastComponent(aContainer);
        }

        private List<View> currentShowingPageViews() {
            List views = PaletteWindowImpl.this._drawerWindow.drawerViews();
            ArrayList<View> selectedPageViews = new ArrayList<View>();
            if (PaletteWindowImpl.this.getSelectedPageName() != null) {
                for (View d : views) {
                    ViewId id = new ViewId(d.getId());
                    String pageName = id.getName().substring(0, Math.min(PaletteWindowImpl.this.getSelectedPageName().length(), id.getName().length()));
                    if (!pageName.equals(PaletteWindowImpl.this.getSelectedPageName()) && !id.getName().equals("PALETTE2_SEARCH") || !PaletteWindowImpl.this._drawerWindow.showing(d)) continue;
                    selectedPageViews.add(d);
                }
            }
            return selectedPageViews;
        }

        private Component sendFocusToView(View theView, Container aContainer, Component aComponent, int inc) {
            Component defaultComponentToReceiveFocus;
            PaletteWindowImpl.this._drawerWindow.activate(theView, true);
            PaletteWindowImpl.this._drawerWindow.expand(theView);
            Component component = defaultComponentToReceiveFocus = inc == this.BACKWARD ? PaletteWindowImpl.this.defaultFocusTraversalPolicy.getComponentBefore(aContainer, aComponent) : PaletteWindowImpl.this.defaultFocusTraversalPolicy.getComponentAfter(aContainer, aComponent);
            if (SwingUtilities.isDescendingFrom(defaultComponentToReceiveFocus, theView.getGUI())) {
                return defaultComponentToReceiveFocus;
            }
            return theView.getGUI();
        }

        private Component findDrawerCandidate(Container aContainer, Component aComponent, Component afterComponent, int inc) {
            List<View> selectedPageViews = this.currentShowingPageViews();
            if (selectedPageViews.size() > 0) {
                ListIterator<View> lIterator;
                View previousView = null;
                ListIterator<View> listIterator = lIterator = inc == this.BACKWARD ? selectedPageViews.listIterator(selectedPageViews.size()) : selectedPageViews.listIterator();
                while (inc == this.BACKWARD ? lIterator.hasPrevious() : lIterator.hasNext()) {
                    Component defaultComponentToReceiveFocus;
                    View nextViewInList;
                    View view = nextViewInList = inc == this.BACKWARD ? lIterator.previous() : lIterator.next();
                    if (nextViewInList.getGUI() == afterComponent) {
                        previousView = nextViewInList;
                        continue;
                    }
                    if (previousView != null) {
                        return this.sendFocusToView(nextViewInList, aContainer, aComponent, inc);
                    }
                    if (!SwingUtilities.isDescendingFrom(afterComponent, nextViewInList.getGUI())) continue;
                    Component component = defaultComponentToReceiveFocus = inc == this.BACKWARD ? PaletteWindowImpl.this.defaultFocusTraversalPolicy.getComponentBefore(aContainer, aComponent) : PaletteWindowImpl.this.defaultFocusTraversalPolicy.getComponentAfter(aContainer, aComponent);
                    if (SwingUtilities.isDescendingFrom(defaultComponentToReceiveFocus, nextViewInList.getGUI())) {
                        return defaultComponentToReceiveFocus;
                    }
                    previousView = nextViewInList;
                }
                if (previousView != null) {
                    PaletteWindowImpl.this._drawerWindow.activate(previousView, false);
                    return inc == this.BACKWARD ? PaletteWindowImpl.this._searchField : this.getLastComponent(aContainer);
                }
            }
            return this.getDefaultComponent(aContainer);
        }

        private Component fetchLastDrawer(Container aContainer, Component aComponent) {
            List<View> selectedPageViews = this.currentShowingPageViews();
            if (selectedPageViews.size() > 0) {
                return this.sendFocusToView(selectedPageViews.get(selectedPageViews.size() - 1), aContainer, aComponent, this.BACKWARD);
            }
            return PaletteWindowImpl.this._searchField;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            Component componentPriorInTabTraversalSequence = null;
            componentPriorInTabTraversalSequence = aComponent == PaletteWindowImpl.this.pageComboBox ? (PaletteWindowImpl.this._drawerWindow.getMinimizerTray() != null && PaletteWindowImpl.this._drawerWindow.getMinimizerTray().isFocusable() ? PaletteWindowImpl.this._drawerWindow.getMinimizerTray() : this.fetchLastDrawer(aContainer, aComponent)) : (aComponent == PaletteWindowImpl.this._searchField ? PaletteWindowImpl.this.pageComboBox : (aComponent == PaletteWindowImpl.this._drawerWindow.getMinimizerTray() ? this.fetchLastDrawer(aContainer, aComponent) : this.findDrawerCandidate(aContainer, aComponent, aComponent, this.BACKWARD)));
            return componentPriorInTabTraversalSequence != null ? componentPriorInTabTraversalSequence : PaletteWindowImpl.this._searchField;
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return PaletteWindowImpl.this.pageComboBox;
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return PaletteWindowImpl.this.pageComboBox;
        }

        @Override
        public Component getInitialComponent(Window window) {
            return PaletteWindowImpl.this.pageComboBox;
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            Component lastComponent = PaletteWindowImpl.this._drawerWindow.getMinimizerTray();
            if (lastComponent == null || !lastComponent.isFocusable()) {
                lastComponent = this.getFirstComponent(aContainer);
            }
            return lastComponent;
        }
    }
}

