/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteItemUI;

public class PaletteSectionUI {
    protected PaletteSection paletteSection;
    protected PaletteGroupUI paletteGroupUI;
    protected JPanel midPanel;
    protected String showState;
    protected SectionSeparator sectionSeparator = null;
    protected List<PaletteItemUI> itemUI = new ArrayList<PaletteItemUI>();

    public PaletteSectionUI(JPanel midPanel, String showState, PaletteSection section, PaletteGroupUI groupUI) {
        this.paletteSection = section;
        this.paletteGroupUI = groupUI;
        this.midPanel = midPanel;
        this.showState = showState;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void jbInit() throws Exception {
        String name = this.paletteSection.getName();
        if (name != null && name.length() > 0) {
            this.sectionSeparator = new SectionSeparator(name, this, this.showState);
            this.midPanel.add(this.sectionSeparator);
        }
        this.initItems();
    }

    protected void initItems() {
        Collection<PaletteItem> paletteItems = this.paletteSection.getItems();
        this.itemUI.clear();
        for (PaletteItem paletteItem : paletteItems) {
            PaletteItemUI item = new PaletteItemUI(paletteItem, this, this.showState, null, null);
            this.itemUI.add(item);
            this.midPanel.add(item);
        }
    }

    public PaletteGroupUI getPaletteGroupUI() {
        return this.paletteGroupUI;
    }

    public PaletteSection getPaletteSection() {
        return this.paletteSection;
    }

    public void setShowState(String showState) {
        this.showState = showState;
        if (this.sectionSeparator != null) {
            this.sectionSeparator.setShowState(showState);
        }
        for (PaletteItemUI item : this.itemUI) {
            item.setShowState(showState);
        }
    }

    public void showAsUnselected() {
        for (PaletteItemUI item : this.itemUI) {
            item.showAsUnselected();
        }
    }

    public PaletteItemUI getItemWithFocus() {
        for (PaletteItemUI item : this.itemUI) {
            if (!item.hasFocus()) continue;
            return item;
        }
        return null;
    }

    public List<PaletteItemUI> getPaletteItems() {
        return this.itemUI;
    }

    class SectionSeparator
    extends JLabel
    implements MouseListener {
        private static final float LABEL_HEIGHT_FUGDE_FACTOR = 1.2f;
        private static final float LABEL_WIDTH_FUGDE_FACTOR = 1.5f;
        private static final int OFFSET = 15;
        private PaletteSectionUI sectionUI;
        private PaletteControllerUI paletteController;
        private boolean _tryPopupInMousePressed;
        private String showState;
        private Border defaultBorder;

        public SectionSeparator() {
            this.paletteController = PaletteControllerUI.getInstance();
            this._tryPopupInMousePressed = false;
        }

        public SectionSeparator(String text, PaletteSectionUI sectionUI, String showState) {
            super(text);
            this.paletteController = PaletteControllerUI.getInstance();
            this._tryPopupInMousePressed = false;
            this.sectionUI = sectionUI;
            this.showState = showState;
            this.setVerticalTextPosition(0);
            this.setHorizontalAlignment(2);
            this.addMouseListener(this);
            this.defaultBorder = BorderFactory.createLineBorder(this.getBackground(), 3);
            this.setBorder(this.defaultBorder);
            this.setFocusable(false);
        }

        public PaletteSectionUI getSectionUI() {
            return this.sectionUI;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setShowState(String showState) {
            this.showState = showState;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Dimension d = this.getSize();
            int y = (d.height - 3) / 2;
            g.setColor(Color.white);
            g.drawLine(1, y, d.width - 1, y);
            g.drawLine(0, ++y, 1, y);
            g.setColor(Color.gray);
            g.drawLine(d.width - 1, y, d.width, y);
            g.drawLine(1, ++y, d.width - 1, y);
            String text = this.getText();
            if (text.length() == 0) {
                return;
            }
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            y = (d.height + fm.getAscent()) / 2;
            int w = fm.stringWidth(text);
            g.setColor(this.getBackground());
            g.fillRect(10, 0, 15 + w, d.height);
            g.setColor(this.getForeground());
            g.drawString(text, 15, y);
        }

        private void tryPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.paletteController.tryPopup(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PaletteItemUI pI = this.paletteController.getSelectedItemUI();
            if (pI != null) {
                this.paletteController.setSelectedWindowUI((PaletteItemUI)null);
            } else {
                PaletteSectionUI pS = this.paletteController.getSelectedSectionUI();
                if (pS != null && pS != this.sectionUI) {
                    this.paletteController.setSelectedWindowUI((PaletteSectionUI)null);
                }
            }
            boolean bl = this._tryPopupInMousePressed = e.isPopupTrigger();
            if (this._tryPopupInMousePressed) {
                this.paletteController.unSelectSelectedItem(true);
                this.paletteController.setSelectedWindowUI(this.sectionUI);
                this.tryPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this._tryPopupInMousePressed) {
                if (e.isPopupTrigger()) {
                    this.paletteController.setSelectedWindowUI(this.sectionUI);
                    this.tryPopup(e);
                } else {
                    this.paletteController.setSelectedWindowUI(this.sectionUI);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public synchronized void add(PopupMenu popup) {
            super.add(popup);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.getGraphics() == null) {
                return new Dimension(120, 40);
            }
            return new Dimension("icon".equals(this.showState) && PaletteSectionUI.this.getPaletteGroupUI() != null ? PaletteSectionUI.this.getPaletteGroupUI().getWidth() : (int)Math.ceil((float)this.getGraphics().getFontMetrics().stringWidth(super.getText()) * 1.5f), (int)Math.ceil((float)this.getGraphics().getFontMetrics().getHeight() * 1.2f));
        }
    }
}

