/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PaletteTransferable;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetItem;
import oracle.ideimpl.palette2.MyComponentsPages;
import oracle.ideimpl.palette2.Palette1Provider;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteSectionUI;
import oracle.ideimpl.palette2.PaletteWindowImpl;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.dnd.DndUtils;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

public class PaletteItemUI
extends JPanel {
    private PaletteItem paletteItem;
    private PaletteSectionUI paletteSectionUI;
    private ItemUI itemUI;
    private String pageName;
    private String groupName;
    private String viewState;
    private Color mouseoverBackground;
    private Color mouseoverForeground;
    private Color selectedForeground;
    private Color selectedBackground;
    private Color enabledForeground;
    private Color enabledBackground;
    private Color disabledForeground;
    private Color disabledBackground;
    private boolean _hasFocus;
    static final Logger _logger = Logger.getLogger(PaletteItemUI.class.getName());
    static final String PALETTEITEM = "paletteitem";
    static final String ENABLED = "enabled";
    static final String MOUSEOVER = "mouseover";
    static final String SELECTED = "selected";
    static final String BACKGROUND = "background";
    static final String FOREGROUND = "foreground";
    static final String LF_ENABLED_BG = "MenuItem.background";
    static final String LF_ENABLED_FG = "MenuItem.foreground";
    static final String LF_DISABLED_BG = "MenuItem.background";
    static final String LF_DISABLED_FG = "MenuItem.disabledForeground";
    static final String LF_SELECTED_BG = "MenuItem.selectionBackground";
    static final String LF_SELECTED_FG = "MenuItem.selectionForeground";
    static final String LF_MOUSEOVER_BG = "MenuItem.selectionBackground";
    static final String LF_MOUSEOVER_FG = "MenuItem.selectionForeground";

    public PaletteItemUI(PaletteItem item, PaletteSectionUI sectionUI, String viewState, String pageName, String groupName) {
        this.paletteItem = item;
        this.paletteSectionUI = sectionUI;
        this.viewState = viewState;
        this.pageName = pageName;
        this.groupName = groupName;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.initColors();
        this.setBackground(this.enabledBackground);
        this.itemUI = new ItemUI(this.viewState, this);
        this.add((Component)this.itemUI, "Center");
        this.addKeyListener(this.paletteSectionUI.getPaletteGroupUI());
    }

    public PaletteItem getPaletteItem() {
        return this.paletteItem;
    }

    public PaletteSectionUI getPaletteSectionUI() {
        return this.paletteSectionUI;
    }

    public void showAsUnselected() {
        this.itemUI.setAndShowAsUnselected();
    }

    public void setShowState(String newViewState) {
        this.itemUI.showState(newViewState);
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public boolean hasFocus() {
        return this._hasFocus;
    }

    void addFocusListenerWithoutPropagationToParent(FocusListener l) {
        if (l == null) {
            return;
        }
        super.addFocusListener(l);
        if (this.itemUI != null) {
            this.itemUI.addFocusListener(l);
        }
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        this.addFocusListenerWithoutPropagationToParent(l);
        this.propagateFocusListenerToParent(l);
    }

    private void propagateFocusListenerToParent(FocusListener l) {
        Container parent = this.getParent();
        if (!(parent instanceof PaletteGroupUI.CenterPanel)) {
            return;
        }
        PaletteGroupUI.CenterPanel centerPanel = (PaletteGroupUI.CenterPanel)parent;
        centerPanel.addFocusListener(l, this);
    }

    private void initColors() {
        if (Themes.isThemed()) {
            ThemeProperties tp = Themes.getActiveTheme().getStateProperties(PALETTEITEM, ENABLED);
            this.enabledBackground = tp.getColor(BACKGROUND);
            this.enabledForeground = tp.getColor(FOREGROUND);
            tp = Themes.getActiveTheme().getStateProperties(PALETTEITEM, SELECTED);
            this.selectedBackground = tp.getColor(BACKGROUND);
            this.selectedForeground = tp.getColor(FOREGROUND);
            tp = Themes.getActiveTheme().getStateProperties(PALETTEITEM, MOUSEOVER);
            this.mouseoverBackground = tp.getColor(BACKGROUND);
            this.mouseoverForeground = tp.getColor(FOREGROUND);
        } else {
            UIDefaults def = UIManager.getLookAndFeelDefaults();
            this.enabledBackground = def.getColor("MenuItem.background");
            this.enabledForeground = def.getColor(LF_ENABLED_FG);
            this.selectedForeground = def.getColor("MenuItem.selectionForeground");
            this.selectedBackground = def.getColor("MenuItem.selectionBackground");
            this.mouseoverForeground = def.getColor("MenuItem.selectionForeground");
            this.mouseoverBackground = def.getColor("MenuItem.selectionBackground");
        }
    }

    private class ItemUI
    extends JLabel
    implements MouseListener,
    DragSourceListener,
    DragGestureListener {
        private Border defaultBorder;
        private DragSource _dragSource;
        private boolean _tryPopupInMousePressed = false;
        private boolean _selected = false;
        private PaletteControllerUI paletteController = PaletteControllerUI.getInstance();
        private PaletteItemUI paletteItemUI;
        private boolean dragEventWasCancelled = false;

        public ItemUI(String viewState, PaletteItemUI paletteItemUI2) {
            this.paletteItemUI = paletteItemUI2;
            this.decorate();
            this.setIcon(PaletteItemUI.this.paletteItem.getIcon());
            String name = PaletteItemUI.this.paletteItem.getName();
            if (viewState.equals("list")) {
                StringBuffer newName = new StringBuffer(name);
                if (PaletteItemUI.this.pageName != null && PaletteItemUI.this.pageName.length() > 0) {
                    newName.append(" (").append(PaletteItemUI.this.pageName);
                    if (PaletteItemUI.this.groupName != null && PaletteItemUI.this.groupName.length() > 0) {
                        newName.append(".").append(PaletteItemUI.this.groupName);
                    }
                    newName.append(")");
                }
                this.setText(newName.toString());
            } else {
                this.setText("");
            }
            if (this.getAccessibleContext().getAccessibleIcon() != null && name != null) {
                this.getAccessibleContext().getAccessibleIcon()[0].setAccessibleIconDescription(name);
                this.getAccessibleContext().setAccessibleName(name);
                this.getAccessibleContext().setAccessibleDescription(name);
            }
            this.resetHighlight();
            this.defaultBorder = BorderFactory.createEmptyBorder(2, 3, 2, 3);
            this.setBorder(this.defaultBorder);
            this.setRequestFocusEnabled(false);
            this.setFocusable(true);
            KeyStroke[] forwardKeys = new KeyStroke[]{KeyStroke.getKeyStroke(40, 0, false)};
            KeyStroke[] backwardKeys = new KeyStroke[]{KeyStroke.getKeyStroke(38, 0, false)};
            this.setFocusTraversalKeys(0, new HashSet<KeyStroke>(Arrays.asList(forwardKeys)));
            this.setFocusTraversalKeys(1, new HashSet<KeyStroke>(Arrays.asList(backwardKeys)));
            this.addFocusListener();
            this._dragSource = new DragSource();
            this._dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        }

        @Override
        protected void processComponentKeyEvent(KeyEvent e) {
            if (e.getID() != 401) {
                return;
            }
            if (e.getKeyCode() == 9) {
                Container cont = PaletteItemUI.this.getParent();
                Component[] children = cont.getComponents();
                if (children == null || children.length == 0) {
                    return;
                }
                if (e.isShiftDown()) {
                    children[0].transferFocusBackward();
                } else {
                    Component c = children[children.length - 1];
                    if (c instanceof PaletteItemUI) {
                        ((PaletteItemUI)c).itemUI.transferFocus();
                    } else {
                        children[children.length - 1].transferFocus();
                    }
                }
            }
        }

        private void addFocusListener() {
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    PaletteItemUI.this._hasFocus = true;
                    ItemUI.this.highlight();
                    ItemUI source = ItemUI.this;
                    Rectangle sourceBounds = source.getBounds();
                    JViewport viewportInHierarchy = ItemUI.this.viewPortInHierarchy(source);
                    if (viewportInHierarchy == null) {
                        return;
                    }
                    Rectangle convertedSourceBounds = SwingUtilities.convertRectangle(source, sourceBounds, viewportInHierarchy);
                    viewportInHierarchy.scrollRectToVisible(convertedSourceBounds);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    PaletteItemUI.this._hasFocus = false;
                    ItemUI.this.resetHighlight();
                }
            });
        }

        private JViewport viewPortInHierarchy(Component start) {
            for (Component c = start; c != null; c = c.getParent()) {
                if (!(c instanceof JViewport)) continue;
                return (JViewport)c;
            }
            return null;
        }

        private final void decorate() {
            this.setOpaque(true);
            this.setVerticalTextPosition(0);
            this.setHorizontalAlignment(2);
            this.addMouseListener(this);
            this.addKeyListener(PaletteItemUI.this.paletteSectionUI.getPaletteGroupUI());
            this.setToolTipText(this._getToolText());
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            int x = (int)this.getAlignmentX();
            int y = (int)this.getAlignmentY();
            return new Point(x, y + 50);
        }

        private String _getToolText() {
            String toolTip = "";
            toolTip = PaletteItemUI.this.paletteItem.getDescription();
            toolTip = toolTip == null || toolTip.length() == 0 ? PaletteItemUI.this.paletteItem.getName() : this.maybeConvertToHtml(toolTip);
            return toolTip;
        }

        private String maybeConvertToHtml(String toolTip) {
            if (!toolTip.matches("^\\s?<\\s?[hH][tT][Mm][Ll]\\s?>.*")) {
                if (toolTip.length() > 241) {
                    toolTip = toolTip.substring(0, 241) + "...";
                }
                if (toolTip.indexOf("\n") >= 0) {
                    toolTip = toolTip.replace("\n", "<br>");
                    return "<html>" + toolTip + "</html>";
                }
            }
            return toolTip;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getModifiers() == 16) {
                return;
            }
            if (!this.isSelected() && e.getClickCount() == 0) {
                this.highlight();
            }
        }

        private void highlight() {
            this.setBackground(PaletteItemUI.this.mouseoverBackground);
            this.setForeground(PaletteItemUI.this.mouseoverForeground);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PaletteItemUI pI = this.paletteController.getSelectedItemUI();
            if (pI != null && pI != this.paletteItemUI) {
                PaletteSectionUI psui = this.paletteController.getSelectedSectionUI();
                if (psui != null) {
                    psui.showAsUnselected();
                }
                if (pI != null) {
                    pI.showAsUnselected();
                }
                this.paletteController.setSelectedWindowUI((PaletteItemUI)null);
                this.paletteController.setSelectedWindowUI((PaletteSectionUI)null);
            } else {
                PaletteSectionUI pS = this.paletteController.getSelectedSectionUI();
                if (pS != null) {
                    pS.showAsUnselected();
                    this.paletteController.setSelectedWindowUI((PaletteSectionUI)null);
                }
            }
            this.setAndShowAsSelected();
            this._tryPopupInMousePressed = e.isPopupTrigger();
            if (this._tryPopupInMousePressed) {
                this.paletteController.setSelectedWindowUI(this.paletteItemUI, "PALETTE2_BUTTON2_PRESSED");
                this.tryPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.dragEventWasCancelled) {
                this.dragEventWasCancelled = false;
            } else if (e.isShiftDown() || e.getClickCount() == 2) {
                this.paletteController.setSelectedWindowUI(this.paletteItemUI);
                this.paletteController.setStickyMode(true);
                this.setSelected(true);
            } else if (!this._tryPopupInMousePressed) {
                if (e.isPopupTrigger()) {
                    this.paletteController.setSelectedWindowUI(this.paletteItemUI, "PALETTE2_BUTTON2_RELEASED");
                    this.tryPopup(e);
                } else {
                    if (this.paletteController.getStickyMode()) {
                        this.paletteController.setStickyMode(false);
                    }
                    if (e.isControlDown()) {
                        PaletteItemUI selectedItemUI = this.paletteController.getSelectedItemUI();
                        if (this.paletteItemUI == selectedItemUI) {
                            this.setAndShowAsUnselected();
                            this.paletteController.setSelectedWindowUI((PaletteItemUI)null);
                        } else {
                            this.setAndShowAsSelected();
                            this.paletteController.setSelectedWindowUI(this.paletteItemUI);
                        }
                    } else {
                        this.setAndShowAsSelected();
                        this.paletteController.setSelectedWindowUI(this.paletteItemUI);
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getModifiers() == 16) {
                return;
            }
            this.resetHighlight();
        }

        private void tryPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.paletteController.tryPopup(e);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
            if (event.getDropSuccess()) {
                MyComponentsPages.getInstance().addToRecentlyUsed(PaletteItemUI.this.getPaletteItem(), PaletteItemUI.this.getPageName(), PaletteItemUI.this.getGroupName(), true);
                EditorManager.getEditorManager().activateCurrentEditorFrame();
            } else {
                this.dragEventWasCancelled = true;
            }
            this.setAndShowAsUnselected();
            this.paletteController.setSelectedWindowUI(null, "PALETTE2_ITEM_DRAG_DROPPED");
        }

        protected void setAndShowAsUnselected() {
            this.setSelected(false);
            this.resetHighlight();
        }

        protected void setAndShowAsSelected() {
            List<PaletteItemUI> paletteItems = PaletteItemUI.this.paletteSectionUI.getPaletteGroupUI().getAllPaletteItemUIs();
            for (PaletteItemUI paletteItemUI : paletteItems) {
                if (paletteItemUI.itemUI == null || !paletteItemUI.itemUI.isSelected()) continue;
                paletteItemUI.itemUI.setAndShowAsUnselected();
            }
            this.setSelected(true);
            this.resetHighlight();
        }

        private void resetHighlight() {
            Color fg;
            Color bg;
            if (this.isSelected()) {
                bg = PaletteItemUI.this.selectedBackground;
                fg = PaletteItemUI.this.selectedForeground;
            } else if (this.isEnabled()) {
                bg = PaletteItemUI.this.enabledBackground;
                fg = PaletteItemUI.this.enabledForeground;
            } else {
                bg = PaletteItemUI.this.disabledBackground;
                fg = PaletteItemUI.this.disabledForeground;
            }
            this.setBackground(bg);
            this.setForeground(fg);
        }

        protected void showState(String state) {
            if (state.equals("list")) {
                String name = PaletteItemUI.this.paletteItem.getName();
                if (PaletteItemUI.this.pageName != null && PaletteItemUI.this.pageName.length() > 0) {
                    String appendText = String.format(" (%s.%s)", String.valueOf(PaletteItemUI.this.pageName), String.valueOf(PaletteItemUI.this.groupName));
                    name = name + appendText;
                }
                this.setText(name);
            } else {
                this.setText("");
            }
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Transferable trans;
            this.paletteController.setSelectedWindowUI(this.paletteItemUI, "PALETTE2_ITEM_DRAG_SELECTED");
            if (PaletteItemUI.this.paletteItem.getProviderId().equalsIgnoreCase(PaletteArb.getString(5))) {
                PalettePages palette1Pages = ((PaletteWindowImpl)PaletteWindowImpl.getInstance()).getPalette1ProviderPages();
                if (palette1Pages != null) {
                    Palette1Provider prov = (Palette1Provider)((Object)palette1Pages);
                    prov.dragGestureRecognized(this._dragSource, dge);
                }
                return;
            }
            boolean rightClick = false;
            InputEvent triggerEvent = dge.getTriggerEvent();
            if (4 == triggerEvent.getModifiers() || 8 == triggerEvent.getModifiers()) {
                rightClick = true;
            }
            if ((trans = this.getTrans(rightClick, triggerEvent)) != null) {
                this._dragSource.startDrag(dge, null, trans, this);
            } else {
                AugmentableTransferable transferable = TransferUtils.createTransferable();
                if (dge != null) {
                    DndUtils.addTriggerEvent((AugmentableTransferable)transferable, (InputEvent)dge.getTriggerEvent());
                }
                if (!(PaletteItemUI.this.paletteItem instanceof MyComponentsCodeSnippetItem)) {
                    transferable.augment(PaletteItem.PALETTE_ITEM_FLAVOR, (Object)PaletteItemUI.this.paletteItem, 0.5f, null);
                } else {
                    transferable.augment(DataFlavor.stringFlavor, ((MyComponentsCodeSnippetItem)PaletteItemUI.this.paletteItem).getData("codeSnippet"), 0.5f, null);
                }
                try {
                    this._dragSource.startDrag(dge, null, (Transferable)transferable, this);
                }
                catch (InvalidDnDOperationException idndoe) {
                    idndoe.printStackTrace();
                    _logger.log(Level.WARNING, "Workaround for exception reported as 6434909 ( reproducible rarely under Linux )", idndoe);
                }
            }
        }

        private Transferable getTrans(boolean rightClick, InputEvent triggerEvent) {
            String editor = (String)PaletteItemUI.this.paletteItem.getData("editor");
            if (editor == null) {
                return null;
            }
            try {
                Object o = Class.forName(editor).newInstance();
                if (o instanceof PaletteTransferable) {
                    PaletteTransferable pT = (PaletteTransferable)o;
                    Context context = new Context();
                    context.setProperty("paletteItem", (Object)PaletteItemUI.this.paletteItem);
                    pT.setContext(context);
                    return (Transferable)o;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return null;
        }

        public void setSelected(boolean s) {
            this._selected = s;
        }

        public boolean isSelected() {
            return this._selected;
        }
    }
}

