/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureElementVisitor;
import oracle.ide.extension.HashStructureHook;
import oracle.ideimpl.palette2.DeclaredPage;
import oracle.ideimpl.palette2.DeclaredPageModel;
import oracle.javatools.data.HashStructure;

public final class PaletteHook
extends HashStructureHook {
    private volatile DeclaredPageModel m_hookModel = null;
    private volatile List<String> m_palette1PageExclusions = null;
    private volatile List<DeclaredPage> m_pages = null;
    private Map<String, HashStructureElementVisitor> m_extensions2HashVisitor = Collections.synchronizedMap(new HashMap());
    private volatile List<Class> m_providerClasses = null;
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "palette-hook");
    public static final ElementName PAGE_PROVIDER_NAME = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "pageProvider");
    public static final ElementName PROVIDER_CLASS_NAME = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "providerClassName");

    private void loadHookModel() {
        assert (this.m_hookModel == null);
        this.m_hookModel = DeclaredPageModel.newInstance(this.getHashStructure());
    }

    private Boolean alreadyLoadedHookModel() {
        return this.m_hookModel != null;
    }

    private void disposeHookModelIfFullyInitialized() {
        if (this.m_palette1PageExclusions != null && this.m_pages != null && this.m_providerClasses != null) {
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeclaredPage> getPages() {
        List<DeclaredPage> pagesResult = this.m_pages;
        if (pagesResult == null) {
            PaletteHook paletteHook = this;
            synchronized (paletteHook) {
                if (!this.alreadyLoadedHookModel().booleanValue()) {
                    this.loadHookModel();
                }
                if ((pagesResult = this.m_pages) == null) {
                    this.m_pages = pagesResult = this.m_hookModel.getPages();
                }
                this.disposeHookModelIfFullyInitialized();
            }
        }
        return pagesResult;
    }

    private List<Class> loadAndGetProviderClasses() {
        ArrayList<Class> providerClasses = new ArrayList<Class>();
        for (String extensionId : this.m_extensions2HashVisitor.keySet()) {
            List providers = this.m_extensions2HashVisitor.get(extensionId).getHashStructure().getAsList("providerClassName");
            if (providers == null) continue;
            ClassLoader cLoader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
            if (cLoader == null) {
                cLoader = Thread.currentThread().getContextClassLoader();
            }
            for (HashStructure className : providers) {
                String clazz = className.getString("#text");
                try {
                    Class<?> cl = Class.forName(clazz, true, cLoader);
                    providerClasses.add(cl);
                }
                catch (ClassNotFoundException e) {}
            }
        }
        return providerClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class> getProviderClasses() {
        List<Class> providerClassesResult = this.m_providerClasses;
        if (providerClassesResult == null) {
            PaletteHook paletteHook = this;
            synchronized (paletteHook) {
                if (!this.alreadyLoadedHookModel().booleanValue()) {
                    this.loadHookModel();
                }
                if ((providerClassesResult = this.m_providerClasses) == null) {
                    this.m_providerClasses = providerClassesResult = this.loadAndGetProviderClasses();
                }
                this.disposeHookModelIfFullyInitialized();
            }
        }
        return providerClassesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPalette1PageExclusions() {
        List<String> exclusionsResult = this.m_palette1PageExclusions;
        if (exclusionsResult == null) {
            PaletteHook paletteHook = this;
            synchronized (paletteHook) {
                if (!this.alreadyLoadedHookModel().booleanValue()) {
                    this.loadHookModel();
                }
                if ((exclusionsResult = this.m_palette1PageExclusions) == null) {
                    this.m_palette1PageExclusions = exclusionsResult = this.m_hookModel.getPalette1PageExclusions();
                }
                this.disposeHookModelIfFullyInitialized();
            }
        }
        return exclusionsResult;
    }

    public void start(ElementStartContext context) {
        HashStructureElementVisitor hashStructureElementVisitor;
        super.start(context);
        if (!this.m_extensions2HashVisitor.containsKey(context.getExtension().getID())) {
            hashStructureElementVisitor = new HashStructureElementVisitor();
            this.m_extensions2HashVisitor.put(context.getExtension().getID(), hashStructureElementVisitor);
        } else {
            hashStructureElementVisitor = this.m_extensions2HashVisitor.get(context.getExtension().getID());
        }
        context.registerChildVisitor(PAGE_PROVIDER_NAME, (ElementVisitor)hashStructureElementVisitor);
    }
}

