/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.MessageFormat;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteSection;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetSection;
import oracle.ideimpl.palette2.MyComponentsFavoritesSection;
import oracle.ideimpl.palette2.MyComponentsGroup;
import oracle.ideimpl.palette2.MyComponentsPages;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteAugmentedSection;
import oracle.javatools.dialogs.MessageDialog;

public class MyComponentsSectionDialog
implements VetoableChangeListener {
    private JEWTDialog _dlg;
    private SectionNamePanel _panel;
    private MyComponentsGroup paletteGroup;
    private PaletteAugmentedSection augSection;

    public boolean invoke(PaletteGroup group, PaletteAugmentedSection section) {
        String caption;
        this.paletteGroup = (MyComponentsGroup)group;
        this.augSection = section;
        this._panel = new SectionNamePanel();
        if (this.augSection == null) {
            caption = PaletteArb.getString(33);
        } else {
            caption = PaletteArb.getString(34);
            this._panel.setName(this.augSection.getName());
        }
        this._dlg = new JEWTDialog((Frame)Ide.getMainWindow(), caption, 7);
        this._dlg.setContent((Component)this._panel);
        this._dlg.pack();
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._dlg.getContent(), "f1_cpnewsection_html");
        boolean result = this._dlg.runDialog();
        this._dlg.removeVetoableChangeListener((VetoableChangeListener)this);
        this._dlg.dispose();
        return result;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && (this.augSection == null ? !this.addSection() : !this.updateSection())) {
            throw new PropertyVetoException("no", evt);
        }
    }

    private boolean addSection() {
        boolean canContinue = true;
        String message = "";
        if (this._panel.getName().trim().length() == 0) {
            message = PaletteArb.getString(36);
            canContinue = false;
            this._panel.getNameFld().requestFocus();
        } else if (this.sectionNameInUse(this._panel.getName())) {
            message = PaletteArb.format(37, this._panel.getName());
            canContinue = false;
            this._panel.getNameFld().requestFocus();
        }
        if (!canContinue) {
            MessageDialog.error((Component)this._dlg, (Object)message, (String)PaletteArb.getString(0), null);
            return false;
        }
        MyComponentsPages compPages = MyComponentsPages.getInstance();
        String groupName = this.paletteGroup.getName();
        String sectionName = this._panel.getName();
        if (groupName.equals(PaletteArb.getString(10))) {
            String sectionId = compPages.getIdentifier(5, sectionName);
            MyComponentsFavoritesSection favSection = new MyComponentsFavoritesSection(this._panel.getName(), sectionId);
            compPages.addSection(10, favSection, true);
        } else {
            String sectionId = compPages.getIdentifier(6, sectionName);
            MyComponentsCodeSnippetSection snippetSection = new MyComponentsCodeSnippetSection(this._panel.getName(), sectionId);
            compPages.addSection(14, snippetSection, true);
        }
        return true;
    }

    private boolean updateSection() {
        boolean canContinue = true;
        String message = "";
        if (this._panel.getName().trim().length() == 0) {
            message = PaletteArb.getString(36);
            canContinue = false;
            this._panel.getNameFld().requestFocus();
        } else {
            String panelName = this._panel.getName();
            if (!this.augSection.getName().equalsIgnoreCase(panelName) && this.sectionNameInUse(panelName)) {
                String messageFormat = PaletteArb.getString(37);
                message = MessageFormat.format(messageFormat, '\'' + panelName + '\'');
                canContinue = false;
                this._panel.getNameFld().requestFocus();
            }
        }
        if (!canContinue) {
            MessageDialog.error((Component)this._dlg, (Object)message, (String)PaletteArb.getString(0), null);
            return false;
        }
        if (!this.augSection.getName().equalsIgnoreCase(this._panel.getName())) {
            MyComponentsPages compPages = MyComponentsPages.getInstance();
            String groupName = this.paletteGroup.getName();
            String sectionName = this._panel.getName();
            int comp = groupName.equals(PaletteArb.getString(10)) ? 10 : 14;
            compPages.renameSection(comp, this.augSection.getName(), sectionName);
        }
        return true;
    }

    private boolean areEqual(String name1, String name2) {
        boolean ret = false;
        if (name1 == null) {
            if (name2 == null) {
                ret = true;
            }
        } else if (name2 != null && name1.equalsIgnoreCase(name2)) {
            ret = true;
        }
        return ret;
    }

    private boolean sectionNameInUse(String name) {
        if (this.paletteGroup != null) {
            Collection<PaletteSection> paletteSections = this.paletteGroup.getSections();
            for (PaletteSection section : paletteSections) {
                if (!this.areEqual(section.getName(), name)) continue;
                return true;
            }
        }
        return false;
    }

    private class SectionNamePanel
    extends JPanel
    implements ActionListener {
        JLabel _nameLbl = new JLabel();
        JTextField _nameFld = new JTextField();
        BorderLayout borderLayout = new BorderLayout(5, 0);

        public SectionNamePanel() {
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.setLayout(this.borderLayout);
            this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
            ResourceUtils.resLabel((JLabel)this._nameLbl, (Component)this._nameFld, (String)PaletteArb.getString(35));
            this.add((Component)this._nameLbl, "West");
            this.add((Component)this._nameFld, "Center");
        }

        @Override
        public String getName() {
            return this._nameFld.getText();
        }

        @Override
        public void setName(String name) {
            this._nameFld.setText(name);
        }

        public JTextField getNameFld() {
            return this._nameFld;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

