/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.ide.palette2.DefaultPaletteItem;
import oracle.ide.palette2.PaletteItem;
import oracle.ideimpl.palette2.PaletteAugmentedItem;
import oracle.ideimpl.palette2.PaletteAugmentedSection;

public class MyComponentsRecentlyUsedSection
extends PaletteAugmentedSection {
    public static final String SECTION_SECTIONID = "sectiomId";
    private HashMap sectionData = new HashMap();
    private List<PaletteAugmentedItem> paletteItems = new ArrayList<PaletteAugmentedItem>();
    private String name;

    public MyComponentsRecentlyUsedSection() {
    }

    public MyComponentsRecentlyUsedSection(String name, String sectionId) {
        if (name != null && name.length() > 0) {
            this.setName(name);
        }
        if (sectionId != null && sectionId.length() > 0) {
            this.setData(SECTION_SECTIONID, sectionId);
        }
    }

    @Override
    public boolean usesAugmentedItem() {
        return true;
    }

    @Override
    public Object getData(Object key) {
        Object data = this.sectionData.get(key);
        return data;
    }

    @Override
    protected void setData(Object key, Object data) {
        this.sectionData.put(key, data);
    }

    @Override
    public PaletteItem getItem(String itemId) {
        PaletteItem paletteItem = null;
        for (PaletteAugmentedItem iterItem : this.paletteItems) {
            PaletteItem pItem = iterItem.getPaletteItem();
            String defId = pItem.getItemId();
            if (defId == null || !defId.equals(itemId)) continue;
            paletteItem = pItem;
            break;
        }
        return paletteItem;
    }

    @Override
    public void addItem(PaletteItem item) {
    }

    @Override
    public void insertItem(PaletteItem item, String beforeItemId) {
    }

    @Override
    public void addItem(PaletteItem item, String pageName, String groupName) {
        if (this.findItem(item.getProviderId(), item.getItemId()) != null) {
            return;
        }
        PaletteAugmentedItem augItem = new PaletteAugmentedItem(item, pageName, groupName);
        this.paletteItems.add(0, augItem);
    }

    private PaletteAugmentedItem findItem(String providerId, String itemId) {
        for (int i = 0; i < this.paletteItems.size(); ++i) {
            PaletteAugmentedItem augItem = this.paletteItems.get(i);
            PaletteItem pItem = augItem.getPaletteItem();
            if (!pItem.getProviderId().equals(providerId) || !pItem.getItemId().equals(itemId)) continue;
            return augItem;
        }
        return null;
    }

    @Override
    public void insertItem(PaletteItem item, String pageName, String groupName, String beforeItemId) {
    }

    @Override
    public boolean removeItem(PaletteItem item) {
        PaletteAugmentedItem aItem = this.findItem(item.getProviderId(), item.getItemId());
        if (aItem != null) {
            return this.paletteItems.remove(aItem);
        }
        return false;
    }

    @Override
    protected void removeAllItems() {
        this.paletteItems.clear();
    }

    @Override
    public Collection<PaletteItem> getItems() {
        return null;
    }

    @Override
    public Collection<PaletteAugmentedItem> getAugmentedItems(boolean reverseOrder) {
        if (reverseOrder) {
            int last = this.paletteItems.size() - 1;
            ArrayList<PaletteAugmentedItem> revItems = new ArrayList<PaletteAugmentedItem>();
            for (int i = last; i >= 0; --i) {
                revItems.add(this.paletteItems.get(i));
            }
            return Collections.unmodifiableList(revItems);
        }
        return Collections.unmodifiableList(this.paletteItems);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MyComponentsRecentlyUsedSection) {
            return this.equalsImpl((MyComponentsRecentlyUsedSection)obj);
        }
        return false;
    }

    private boolean equalsImpl(MyComponentsRecentlyUsedSection section) {
        String thisSectionId = (String)this.getData(SECTION_SECTIONID);
        String pageSectionId = (String)section.getData(SECTION_SECTIONID);
        return this.areEqual(this.name, section.getName()) && thisSectionId.equals(pageSectionId);
    }

    public String toString() {
        String temp = String.format("DefaultSection[ name=%s, sectionId=%s] \n", String.valueOf(this.getName()), String.valueOf(this.getData(SECTION_SECTIONID)));
        Collection<PaletteItem> items = this.getItems();
        for (PaletteItem x : items) {
            DefaultPaletteItem y = (DefaultPaletteItem)x;
            temp = temp + y.toString();
        }
        return temp;
    }
}

