/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.ide.palette2.DefaultPaletteItem;
import oracle.ide.palette2.PaletteItem;
import oracle.ideimpl.palette2.PaletteAugmentedItem;
import oracle.ideimpl.palette2.PaletteAugmentedSection;

public class MyComponentsFavoritesSection
extends PaletteAugmentedSection {
    public static final String SECTION_SECTIONID = "sectiomId";
    private HashMap sectionData = new HashMap();
    private List<PaletteAugmentedItem> paletteItems = new ArrayList<PaletteAugmentedItem>();
    private String name;

    public MyComponentsFavoritesSection() {
    }

    public MyComponentsFavoritesSection(String name, String sectionId) {
        if (name != null && name.length() > 0) {
            this.setName(name);
        }
        if (sectionId != null && sectionId.length() > 0) {
            this.setData(SECTION_SECTIONID, sectionId);
        }
    }

    @Override
    public boolean usesAugmentedItem() {
        return true;
    }

    @Override
    public Object getData(Object key) {
        Object data = this.sectionData.get(key);
        return data;
    }

    @Override
    protected void setData(Object key, Object data) {
        this.sectionData.put(key, data);
    }

    @Override
    public PaletteItem getItem(String itemId) {
        PaletteItem paletteItem = null;
        for (PaletteAugmentedItem iterItem : this.paletteItems) {
            PaletteItem pItem = iterItem.getPaletteItem();
            String defId = pItem.getItemId();
            if (defId == null || !defId.equals(itemId)) continue;
            paletteItem = pItem;
            break;
        }
        return paletteItem;
    }

    @Override
    public void addItem(PaletteItem item) {
    }

    @Override
    public void insertItem(PaletteItem item, String beforeItemId) {
    }

    @Override
    public void addItem(PaletteItem item, String pageName, String groupName) {
        for (PaletteAugmentedItem iterItem : this.paletteItems) {
            PaletteItem pItem = iterItem.getPaletteItem();
            if (!pItem.equals(item)) continue;
            return;
        }
        PaletteAugmentedItem augItem = new PaletteAugmentedItem(item, pageName, groupName);
        this.paletteItems.add(augItem);
    }

    @Override
    public void insertItem(PaletteItem item, String pageName, String groupName, String beforeItemId) {
        PaletteAugmentedItem augItem = new PaletteAugmentedItem(item, pageName, groupName);
        boolean inserted = false;
        int idx = 0;
        for (PaletteAugmentedItem iterItem : this.paletteItems) {
            PaletteItem pItem = iterItem.getPaletteItem();
            if (pItem.getItemId().equals(beforeItemId)) {
                this.paletteItems.add(idx, augItem);
                inserted = true;
                break;
            }
            ++idx;
        }
        if (!inserted) {
            this.addItem(item, pageName, groupName);
        }
    }

    @Override
    public boolean removeItem(PaletteItem item) {
        if (item == null || !(item instanceof PaletteItem)) {
            return false;
        }
        for (PaletteAugmentedItem iterItem : this.paletteItems) {
            PaletteItem pItem = iterItem.getPaletteItem();
            if (!pItem.equals(item)) continue;
            return this.paletteItems.remove(iterItem);
        }
        return false;
    }

    @Override
    protected void removeAllItems() {
        this.paletteItems.clear();
    }

    @Override
    public Collection<PaletteItem> getItems() {
        return null;
    }

    @Override
    public Collection<PaletteAugmentedItem> getAugmentedItems(boolean reverseOrder) {
        return Collections.unmodifiableList(this.paletteItems);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MyComponentsFavoritesSection) {
            return this.equalsImpl((MyComponentsFavoritesSection)obj);
        }
        return false;
    }

    private boolean equalsImpl(MyComponentsFavoritesSection section) {
        String thisSectionId = (String)this.getData(SECTION_SECTIONID);
        String pageSectionId = (String)section.getData(SECTION_SECTIONID);
        return this.areEqual(this.name, section.getName()) && thisSectionId.equalsIgnoreCase(pageSectionId);
    }

    public String toString() {
        String temp = String.format("DefaultSection[ name=%s, sectionId=%s] \n", String.valueOf(this.getName()), String.valueOf(this.getData(SECTION_SECTIONID)));
        Collection<PaletteItem> items = this.getItems();
        for (PaletteItem x : items) {
            DefaultPaletteItem y = (DefaultPaletteItem)x;
            temp = temp + y.toString();
        }
        return temp;
    }
}

