/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;
import oracle.ide.util.PropertyAccess;
import oracle.ideimpl.palette2.MyComponentsGroupUI;
import oracle.ideimpl.palette2.PaletteAugmentedItem;
import oracle.ideimpl.palette2.PaletteAugmentedSection;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteDockable;

public class MyComponentsDockable
extends DockableWindow
implements PaletteDockable,
Controller {
    private PaletteGroup paletteGroup;
    private String _cachedName;
    private String _cachedViewState;
    private MyComponentsGroupUI groupWindow;

    public MyComponentsDockable(String viewName) {
        super("PALETTEFACTORY." + viewName);
    }

    public int getDefaultVisibility(Layout layout) {
        return 32;
    }

    public Controller getController() {
        return this;
    }

    public String getTabName() {
        return this._cachedName;
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public void saveLayout(PropertyAccess p) {
        p.setProperty("NAME", this._cachedName);
        p.setProperty("VIEWSTATE", this.getViewState());
    }

    public void loadLayout(PropertyAccess p) {
        this._cachedName = p.getProperty("NAME", "");
        this.setViewState(p.getProperty("VIEWSTATE", "list"));
    }

    public Component getGUI() {
        if (this.groupWindow == null) {
            this.groupWindow = new MyComponentsGroupUI(this.getViewState());
            if (this.paletteGroup != null) {
                this.groupWindow.setData(this.paletteGroup);
            }
        }
        this.groupWindow.requestFocus();
        return this.groupWindow;
    }

    @Override
    public void setData(PaletteGroup paletteGroup) {
        this.paletteGroup = paletteGroup;
        this._cachedName = paletteGroup.getName();
        if (this.groupWindow != null) {
            this.groupWindow.setData(paletteGroup);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return false;
    }

    @Override
    public String getViewState() {
        if (this._cachedViewState == null) {
            this._cachedViewState = "list";
        }
        return this._cachedViewState;
    }

    protected void setViewState(String vwState) {
        this._cachedViewState = vwState == null || vwState.length() == 0 ? "list" : vwState;
    }

    @Override
    public void toggleViewState() {
        if (this.groupWindow != null) {
            if (this.getViewState().equals("list")) {
                this.setViewState("icon");
            } else {
                this.setViewState("list");
            }
            this.groupWindow.toggleView(this.getViewState());
        }
    }

    protected boolean isGroupEmpty() {
        Collection<PaletteSection> sections = this.paletteGroup.getSections();
        for (PaletteSection section : sections) {
            Collection<PaletteAugmentedItem> augItems = ((PaletteAugmentedSection)section).getAugmentedItems(false);
            if (augItems != null) {
                Iterator<PaletteAugmentedItem> i$ = augItems.iterator();
                if (!i$.hasNext()) continue;
                PaletteAugmentedItem augItem = i$.next();
                return false;
            }
            Collection<PaletteItem> paletteItems = section.getItems();
            Iterator<PaletteItem> i$ = paletteItems.iterator();
            if (!i$.hasNext()) continue;
            PaletteItem paletteItem = i$.next();
            return false;
        }
        return true;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idecomponentpalette_html");
    }

    public ContextMenu getContextMenu() {
        return PaletteControllerUI.getInstance().getContextMenu();
    }
}

