/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ide.extension.ExtensionRegistry;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.IdeSettings;
import oracle.ide.model.Node;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette2.DefaultPaletteGroup;
import oracle.ide.palette2.DefaultPaletteItem;
import oracle.ide.palette2.DefaultPalettePage;
import oracle.ide.palette2.DefaultPaletteSection;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePage;
import oracle.ide.palette2.PalettePageContext;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import oracle.ideimpl.palette2.DeclaredGroup;
import oracle.ideimpl.palette2.DeclaredItem;
import oracle.ideimpl.palette2.DeclaredPage;
import oracle.ideimpl.palette2.DeclaredPageProvider;
import oracle.ideimpl.palette2.DeclaredSection;
import oracle.ideimpl.palette2.PaletteHook;
import oracle.javatools.data.PropertyStorage;

public class DeclaredPages
extends PalettePages {
    private static final String DECLAREDPROVIDER_ID = DeclaredPageProvider.class.getName();
    private static final DefaultPalettePage.ShowForTypeRecord NULL_SHOW_FOR_TYPE_RECORD = new DefaultPalettePage.ShowForTypeRecord(null);
    protected List<PalettePagesListener> palettePagesListeners;
    protected List<PalettePage> palettePages = new ArrayList<PalettePage>();
    private PalettePage _preferredPage;

    public DeclaredPages(Context context) {
        URL url = null;
        Node node = context.getNode();
        if (node != null) {
            url = context.getNode().getURL();
        }
        if (url == null) {
            return;
        }
        String pageType = DeclaredPages.getSuffix(url);
        String[] keys = TechnologyScopeConfiguration.getInstance((PropertyStorage)context.getProject()).getTechnologyScope().getTechnologyKeys();
        int nuScopes = keys != null ? keys.length : 0;
        PaletteHook hook = (PaletteHook)ExtensionRegistry.getExtensionRegistry().getHook(PaletteHook.NAME);
        List<DeclaredPage> dclPages = hook.getPages();
        if (dclPages != null) {
            for (DeclaredPage dclPage : dclPages) {
                List<String> technologyScopes = dclPage.getTechnologyScopes();
                if (dclPage.getShowForTypes() != null || dclPage.getType() != null) {
                    DefaultPalettePage.ShowForTypeRecord rec = this._getShowForTypeRecord(dclPage, pageType);
                    if (rec.docType == null) continue;
                    if (nuScopes == 0 || technologyScopes == null) {
                        this.addPage(dclPage, this._isPreferredPage(rec, pageType));
                        continue;
                    }
                    if (!this._checkTechnologyScopes(keys, technologyScopes)) continue;
                    this.addPage(dclPage, this._isPreferredPage(rec, pageType));
                    continue;
                }
                if (nuScopes > 0 && technologyScopes != null) {
                    if (!this._checkTechnologyScopes(keys, technologyScopes)) continue;
                    this.addPage(dclPage, false);
                    continue;
                }
                String pageContext = dclPage.getPageContext();
                if (pageContext == null || pageContext.length() <= 0) continue;
                try {
                    PalettePageContext dclContext = (PalettePageContext)Class.forName(pageContext).newInstance();
                    if (!dclContext.showPage(context)) continue;
                    this.addPage(dclPage, dclContext.isPreferred(context));
                }
                catch (Exception ex) {}
            }
        }
    }

    @Override
    public Collection<PalettePage> getPages() {
        return Collections.unmodifiableList(this.palettePages);
    }

    @Override
    public PaletteItem getItem(String providerId, String itemId) {
        PaletteItem paletteItem;
        block2: {
            PalettePage palettePage;
            DefaultPalettePage defPage;
            if (providerId == null || providerId.length() == 0 || itemId == null || itemId.length() == 0) {
                return null;
            }
            paletteItem = null;
            if (!providerId.equals(DECLAREDPROVIDER_ID)) break block2;
            Iterator<PalettePage> i$ = this.palettePages.iterator();
            while (i$.hasNext() && (paletteItem = (defPage = (DefaultPalettePage)(palettePage = i$.next())).getItem(itemId)) == null) {
            }
        }
        return paletteItem;
    }

    @Override
    public PalettePage getPreferredPage() {
        return this._preferredPage;
    }

    @Override
    public void addPalettePagesListener(PalettePagesListener listener) {
        if (this.palettePagesListeners == null) {
            this.palettePagesListeners = new ArrayList<PalettePagesListener>();
        }
        if (!this.palettePagesListeners.contains(listener)) {
            this.palettePagesListeners.add(listener);
        }
    }

    @Override
    public void removePalettePagesListener(PalettePagesListener listener) {
        if (this.palettePagesListeners != null) {
            this.palettePagesListeners.remove(listener);
        }
    }

    private void addPage(DeclaredPage dclPage, boolean asPreferredPage) {
        Collection<DeclaredGroup> groups;
        DefaultPalettePage page = new DefaultPalettePage(new DefaultPalettePage.PageRecord(dclPage.getName(), dclPage.getDescription(), dclPage.getIcon(), dclPage.getPageId(), dclPage.getPageEditor(), dclPage.getProjectConfiguration(), dclPage.getShowForTypes(), dclPage.getTechnologyScopes(), dclPage.getType(), dclPage.getPageContext()));
        if (asPreferredPage && this._preferredPage == null) {
            this._preferredPage = page;
        }
        if ((groups = dclPage.getGroups()) != null) {
            for (DeclaredGroup dclGroup : groups) {
                DefaultPaletteGroup dfltGroup = new DefaultPaletteGroup(dclGroup.getName(), dclGroup.getDescription(), dclGroup.getIcon(), dclGroup.getGroupId(), dclGroup.getGroupEditor(), dclGroup.getProjectConfiguration(), dclGroup.getShowForTypes(), dclGroup.getTechnologyScopes(), dclGroup.getType());
                page.addGroup(dfltGroup);
                Collection<DeclaredSection> sections = dclGroup.getSections();
                if (sections == null) continue;
                for (DeclaredSection dclSection : sections) {
                    DefaultPaletteSection dfltSection = new DefaultPaletteSection(dclSection.getName(), dclSection.getSectionId());
                    dfltGroup.addSection(dfltSection);
                    Collection<DeclaredItem> items = dclSection.getItems();
                    if (items == null) continue;
                    for (DeclaredItem dclItem : items) {
                        DefaultPaletteItem dfltItem = new DefaultPaletteItem(dclItem.getName(), dclItem.getDescription(), dclItem.getIcon(), dclItem.getItemId(), DECLAREDPROVIDER_ID, dclItem.getEditor(), dclItem.getTechnologyScopes(), dclItem.getType(), dclItem.getInfo(), dclItem.getClassPath(), dclItem.getClassName(), dclItem.getLibrary(), dclItem.getWeight(), dclItem.getHelpable(), dclItem.getSearchTextContext());
                        dfltSection.addItem(dfltItem);
                    }
                }
            }
        }
        this.palettePages.add(page);
    }

    static String getSuffix(URL url) {
        String suffix = URLFileSystem.getSuffix((URL)url);
        int period = suffix.lastIndexOf(".");
        if (period != -1) {
            return suffix.substring(period + 1);
        }
        return "";
    }

    static boolean isCorrectNode(String suffix, String type) {
        if (suffix == null || type == null) {
            return false;
        }
        IdeSettings ideSettings = Ide.getSettings();
        if (ideSettings == null) {
            return false;
        }
        DocumentExtensions ext = (DocumentExtensions)ideSettings.getData("document-extensions-options");
        if (ext == null) {
            return false;
        }
        DocumentExtensions.DocRecord rec = ext.findDocumentFromExtension("." + type);
        if (rec == null) {
            return false;
        }
        for (DocumentExtensions.ExtInfo info : rec.getExtensions()) {
            String extension = info.getExtension();
            if (!extension.equals("." + suffix)) continue;
            return true;
        }
        return false;
    }

    private DefaultPalettePage.ShowForTypeRecord _getShowForTypeRecord(DeclaredPage dclPage, String pageType) {
        List<DefaultPalettePage.ShowForTypeRecord> types = dclPage.getShowForTypes();
        if (types == null) {
            types.add(new DefaultPalettePage.ShowForTypeRecord(dclPage.getType()));
        }
        for (DefaultPalettePage.ShowForTypeRecord type : types) {
            if (!DeclaredPages.isCorrectNode(type.docType, pageType)) continue;
            return type;
        }
        return NULL_SHOW_FOR_TYPE_RECORD;
    }

    private boolean _checkTechnologyScopes(String[] keys, List<String> technologyScopes) {
        if (technologyScopes == null) {
            return false;
        }
        List<String> keyList = Arrays.asList(keys);
        for (String scope : technologyScopes) {
            if (!keyList.contains(scope)) continue;
            return true;
        }
        return false;
    }

    private boolean _isPreferredPage(DefaultPalettePage.ShowForTypeRecord rec, String pageType) {
        if (rec.docType.equals(pageType)) {
            return rec.asPreferredPage;
        }
        return false;
    }
}

