/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ide.log.LogManager;
import oracle.ideimpl.palette2.DeclaredPage;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

class DeclaredPageModel
extends HashStructureAdapter {
    private DeclaredPageModel(HashStructure hash) {
        super(hash);
    }

    static DeclaredPageModel newInstance(HashStructure hash) {
        return new DeclaredPageModel(hash);
    }

    List<String> getProviders() {
        List data = this._hash.getAsList("pageProvider");
        if (data == null) {
            return null;
        }
        ArrayList<String> providers = new ArrayList<String>();
        for (HashStructure h : data) {
            List data2 = h.getAsList("providerClassName");
            for (HashStructure h2 : data2) {
                providers.add(h2.getString("#text"));
            }
        }
        return Collections.unmodifiableList(providers);
    }

    List<DeclaredPage> getPages() {
        List data = this._hash.getAsList("page");
        if (data == null) {
            return null;
        }
        ArrayList<DeclaredPage> pages = new ArrayList<DeclaredPage>(data.size());
        for (HashStructure h : data) {
            pages.add(DeclaredPage.getInstance(h));
        }
        return Collections.unmodifiableList(pages);
    }

    List<String> getPalette1PageExclusions() {
        List data = this._hash.getAsList("palette1PageExclusions");
        if (data == null) {
            return null;
        }
        ArrayList<String> pageNames = new ArrayList<String>();
        for (HashStructure h : data) {
            List data2 = h.getAsList("pageName");
            for (HashStructure h2 : data2) {
                pageNames.add(h2.getString("#text"));
            }
        }
        return Collections.unmodifiableList(pageNames);
    }

    void toLog() {
        List<DeclaredPage> pages;
        List<String> providers = this.getProviders();
        if (providers != null) {
            for (String provider : providers) {
                String temp = String.format("PageProvider [ classname=%s ] \n", provider);
                try {
                    LogManager.getLogManager().getMsgPage().log((Object)temp);
                }
                catch (Exception ex) {}
            }
        }
        if ((pages = this.getPages()) != null) {
            for (DeclaredPage w : pages) {
                try {
                    LogManager.getLogManager().getMsgPage().log((Object)(w.toString() + "\n"));
                }
                catch (Exception ex) {}
            }
        }
    }
}

