/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public final class DeclaredItem
extends HashStructureAdapter {
    private DeclaredItem(HashStructure hash) {
        super(hash);
    }

    public static DeclaredItem getInstance(HashStructure hash) {
        return new DeclaredItem(hash);
    }

    public String getName() {
        return this._hash.getString("name/#text");
    }

    public String getDescription() {
        return this._hash.getString("description/#text");
    }

    public String getIcon() {
        return this._hash.getString("icon/#text");
    }

    public String getInfo() {
        return this._hash.getString("info/#text");
    }

    public String getClassPath() {
        String classPath = null;
        HashStructure hashClass = this._hash.getHashStructure("classInfo");
        if (hashClass != null) {
            classPath = hashClass.getString("classPath/#text");
        }
        return classPath;
    }

    public String getClassName() {
        String className = null;
        HashStructure hashClass = this._hash.getHashStructure("classInfo");
        if (hashClass != null) {
            className = hashClass.getString("className/#text");
        }
        return className;
    }

    public String getType() {
        return this._hash.getString("type/#text");
    }

    public String getItemId() {
        return this._hash.getString("itemId/#text");
    }

    public String getEditor() {
        return this._hash.getString("Editor/#text");
    }

    public List<String> getTechnologyScopes() {
        List data = this._hash.getAsList("technologyScopes");
        if (data == null) {
            return null;
        }
        ArrayList<String> scopes = new ArrayList<String>();
        for (HashStructure h : data) {
            List data2 = h.getAsList("technologyScope");
            for (HashStructure h2 : data2) {
                scopes.add(h2.getString("#text"));
            }
        }
        return Collections.unmodifiableList(scopes);
    }

    public String getLibrary() {
        return this._hash.getString("library/#text");
    }

    public String getHelpable() {
        return this._hash.getString("helpable/#text");
    }

    public String getWeight() {
        return this._hash.getString("weight/#text");
    }

    public String getSearchTextContext() {
        return this._hash.getString("searchTextContext/#text");
    }

    public String toString() {
        String temp = String.format("DeclaredItem[ name=%s, description=%s, itemId=%s, info=%s, TechnologyScope=%s, Type=%s, Library=%s, ClassPath=%s, ClassName=%s ] \n", String.valueOf(this.getName()), String.valueOf(this.getDescription()), String.valueOf(this.getItemId()), String.valueOf(this.getInfo()), String.valueOf(this.getTechnologyScopes()), String.valueOf(this.getType()), String.valueOf(this.getLibrary()), String.valueOf(this.getClassPath()), String.valueOf(this.getClassName()));
        return temp;
    }
}

