/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.palette2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import oracle.ide.palette2.DefaultPaletteItem;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;

public class DefaultPaletteSection
extends PaletteSection {
    public static final String SECTION_SECTIONID = "sectiomId";
    private HashMap sectionData = new HashMap();
    private List<PaletteItem> paletteItems = new ArrayList<PaletteItem>();
    private String name;

    public DefaultPaletteSection() {
    }

    public DefaultPaletteSection(String name, String sectionId) {
        if (name != null && name.length() > 0) {
            this.setName(name);
        }
        if (sectionId != null && sectionId.length() > 0) {
            this.setData(SECTION_SECTIONID, sectionId);
        }
    }

    @Override
    public Object getData(Object key) {
        Object data = this.sectionData.get(key);
        return data;
    }

    protected void setData(Object key, Object data) {
        this.sectionData.put(key, data);
    }

    public PaletteItem getItem(String itemId) {
        PaletteItem paletteItem = null;
        for (PaletteItem iterItem : this.paletteItems) {
            String defId = iterItem.getItemId();
            if (defId == null || !defId.equals(itemId)) continue;
            paletteItem = iterItem;
            break;
        }
        return paletteItem;
    }

    public void addItem(PaletteItem item) {
        for (PaletteItem iterItem : this.paletteItems) {
            if (!iterItem.equals(item)) continue;
            return;
        }
        this.paletteItems.add(item);
    }

    public void removeItem(PaletteItem item) {
        if (item == null || !(item instanceof PaletteItem)) {
            return;
        }
        for (PaletteItem iterItem : this.paletteItems) {
            if (!iterItem.equals(item)) continue;
            this.paletteItems.remove(iterItem);
            break;
        }
    }

    protected void removeAllItems() {
        this.paletteItems.clear();
    }

    @Override
    public Collection<PaletteItem> getItems() {
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                int result;
                String s2;
                float value1 = 0.0f;
                float value2 = 0.0f;
                PaletteItem p1 = (PaletteItem)o1;
                PaletteItem p2 = (PaletteItem)o2;
                String s1 = (String)p1.getData("weight");
                if (s1 != null && s1.length() > 0) {
                    value1 = Float.parseFloat(s1.trim());
                }
                if ((s2 = (String)p2.getData("weight")) != null && s2.length() > 0) {
                    value2 = Float.parseFloat(s2.trim());
                }
                if ((result = Float.compare(value1, value2)) == 0) {
                    result = String.CASE_INSENSITIVE_ORDER.compare(p1.getName(), p2.getName());
                }
                return result;
            }
        };
        Collections.sort(this.paletteItems, comparator);
        return Collections.unmodifiableList(this.paletteItems);
    }

    public List<PaletteItem> getPaletteItems() {
        return Collections.unmodifiableList(this.paletteItems);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DefaultPaletteSection) {
            return this.equalsImpl((DefaultPaletteSection)obj);
        }
        return false;
    }

    private boolean equalsImpl(DefaultPaletteSection section) {
        String thisSectionId = (String)this.getData(SECTION_SECTIONID);
        String pageSectionId = (String)section.getData(SECTION_SECTIONID);
        return this.name.equals(section.getName()) && thisSectionId.equals(pageSectionId);
    }

    public String toString() {
        String temp = String.format("DefaultSection[ name=%s, sectionId=%s] \n", String.valueOf(this.getName()), String.valueOf(this.getData(SECTION_SECTIONID)));
        Collection<PaletteItem> items = this.getItems();
        for (PaletteItem x : items) {
            DefaultPaletteItem y = (DefaultPaletteItem)x;
            temp = temp + y.toString();
        }
        return temp;
    }
}

