/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.util;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.ide.util.MissingIconException;

public abstract class IconDescription {
    private URL _url;

    private IconDescription() {
    }

    public static IconDescription createInstance(final URL url) {
        return new IconDescription(){

            @Override
            protected URL resolveURL() throws MissingIconException {
                return url;
            }
        };
    }

    public static IconDescription createResourceInstance(final ClassLoader loader, final String bundleClass, final String key) {
        return new IconDescription(){

            @Override
            protected URL resolveURL() throws MissingIconException {
                ResourceBundle bundle;
                try {
                    bundle = ResourceBundle.getBundle(bundleClass, Locale.getDefault(), loader);
                }
                catch (MissingResourceException mre) {
                    throw new MissingIconException("Resource bundle " + bundleClass + " not found.", mre);
                }
                try {
                    String path = bundle.getString(key);
                    if (path == null || path.trim().length() == 0) {
                        throw new MissingIconException("Icon key " + key + " has empty value in bundle " + bundleClass);
                    }
                    Class<?> bundleClass2 = bundle.getClass();
                    URL result = bundleClass2.getResource(path);
                    if (result == null) {
                        throw new MissingIconException("Icon path " + path + " does not exist. Specified by key " + key + " in bundle " + bundleClass2);
                    }
                    return result;
                }
                catch (MissingResourceException mre) {
                    throw new MissingIconException("Icon key " + key + " not defined in bundle " + bundleClass, mre);
                }
            }
        };
    }

    public static IconDescription createPathInstance(final ClassLoader loader, final String path) {
        return new IconDescription(){

            @Override
            protected URL resolveURL() throws MissingIconException {
                URL resource = loader.getResource(path);
                if (resource == null) {
                    throw new MissingIconException("Icon path " + path + " not found.");
                }
                return resource;
            }
        };
    }

    protected abstract URL resolveURL() throws MissingIconException;

    public URL getURL() throws MissingIconException {
        if (this._url == null) {
            this._url = this.resolveURL();
        }
        return this._url;
    }
}

