/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.I18NCharVisitor;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.IconVisitor;
import javax.ide.menu.spi.Menu;
import javax.ide.menu.spi.MenuBar;
import javax.ide.menu.spi.PositionableVisitor;
import javax.ide.menu.spi.SectionVisitor;
import javax.ide.util.IconDescription;

class MenuVisitor
extends PositionableVisitor {
    static final ElementName MENU = new ElementName("http://jcp.org/jsr/198/extension-manifest", "menu");
    private static final ElementName LABEL = new ElementName("http://jcp.org/jsr/198/extension-manifest", "label");
    private static final ElementName MNEMONIC = new ElementName("http://jcp.org/jsr/198/extension-manifest", "mnemonic");
    private static final ElementName TOOLTIP = new ElementName("http://jcp.org/jsr/198/extension-manifest", "tooltip");
    private static final ElementName ICONPATH = new ElementName("http://jcp.org/jsr/198/extension-manifest", "iconpath");
    private ElementVisitor _sectionVisitor;

    MenuVisitor() {
    }

    @Override
    protected void positionable(ElementStartContext context, String id, String before, String after) {
        MenuBar menuBar = (MenuBar)context.getScopeData().get("menuBar");
        Menu menu = menuBar.getMenu(id);
        if (menu == null) {
            menu = new Menu(id);
            menuBar.addMenu(menu);
        }
        this.processMenu(context, menu, before, after);
    }

    protected final void processMenu(ElementStartContext context, final Menu menu, String before, String after) {
        if (before != null) {
            menu.setBefore(before);
        } else if (after != null) {
            menu.setAfter(after);
        }
        if (this._sectionVisitor == null) {
            this._sectionVisitor = new SectionVisitor();
        }
        context.getScopeData().put("sectionContainer", menu);
        context.registerChildVisitor(SectionVisitor.SECTION, this._sectionVisitor);
        context.registerChildVisitor(LABEL, new I18NStringVisitor(){

            @Override
            protected void string(ElementContext context, String string) {
                menu.setLabel(string);
            }
        });
        context.registerChildVisitor(MNEMONIC, new I18NCharVisitor(){

            @Override
            protected void characterValue(ElementContext context, char c) {
                menu.setMnemonic(c);
            }
        });
        context.registerChildVisitor(TOOLTIP, new I18NStringVisitor(){

            @Override
            protected void string(ElementContext context, String string) {
                menu.setTooltip(string);
            }
        });
        context.registerChildVisitor(ICONPATH, new IconVisitor(){

            @Override
            protected void icon(ElementContext context, IconDescription icon) {
                menu.setIcon(icon);
            }
        });
    }
}

