/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.io.IOException;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXManifestParser {
    private final DefaultElementContext _context;
    private SAXParser _parser = null;
    private Handler _handler = null;
    private Locator _locator;

    public SAXManifestParser(DefaultElementContext initialContext) {
        this._context = initialContext;
    }

    public ElementContext getContext() {
        return this._context;
    }

    public void parse(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        this.parse(null, inputSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(XMLReader reader, InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        if (reader == null) {
            if (this._parser == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                this._parser = factory.newSAXParser();
            }
            reader = this._parser.getXMLReader();
        }
        if (this._handler == null) {
            this._handler = new Handler();
        }
        reader.setContentHandler(this._handler);
        reader.setErrorHandler(this._handler);
        try {
            reader.parse(inputSource);
        }
        finally {
            this._context.reset();
        }
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXException {
            ElementVisitor visitor = SAXManifestParser.this._context.getVisitorForStartElement(new ElementName(uri, name));
            SAXManifestParser.this._context.beginElement(uri, name, attributes);
            if (visitor != null) {
                this.recordPosition(SAXManifestParser.this._context);
                try {
                    visitor.start(SAXManifestParser.this._context);
                }
                catch (Throwable re) {
                    if (re instanceof ThreadDeath) {
                        throw (ThreadDeath)re;
                    }
                    ExtensionLogRecord r = new ExtensionLogRecord(SAXManifestParser.this._locator, Level.SEVERE, "Exception processing manifest: " + re.getClass().getName() + ":" + re.getMessage());
                    r.setThrown(re);
                    SAXManifestParser.this._context.getLogger().log(r);
                }
            }
            SAXManifestParser.this._context.postBeginElement();
        }

        @Override
        public void endElement(String uri, String name, String qName) throws SAXException {
            SAXManifestParser.this._context.endElement(uri, name);
            ElementVisitor visitor = SAXManifestParser.this._context.getVisitorForEndElement();
            if (visitor != null) {
                this.recordPosition(SAXManifestParser.this._context);
                try {
                    visitor.end(SAXManifestParser.this._context);
                }
                catch (Throwable re) {
                    if (re instanceof ThreadDeath) {
                        throw (ThreadDeath)re;
                    }
                    ExtensionLogRecord r = new ExtensionLogRecord(SAXManifestParser.this._locator, Level.SEVERE, "Exception processing manifest: " + re.getClass().getName() + ":" + re.getMessage());
                    r.setThrown(re);
                    SAXManifestParser.this._context.getLogger().log(r);
                }
            }
            SAXManifestParser.this._context.postEndElement();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            SAXManifestParser.this._context.appendCharacters(ch, start, length);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            SAXManifestParser.this._locator = locator;
        }

        private void recordPosition(ElementContext context) {
            context.getScopeData().put("xml.locator", SAXManifestParser.this._locator);
        }
    }
}

