/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementContext;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.ExtensionSource;
import org.xml.sax.Locator;

public final class ExtensionLogRecord
extends LogRecord {
    private final Locator _locator;

    public ExtensionLogRecord(Locator locator, Level level, String msg) {
        super(level, msg);
        this._locator = ExtensionLogRecord.copyLocator(locator);
        if (this._locator != null) {
            this.setParameters(new Object[]{this._locator});
        }
    }

    public ExtensionLogRecord(ElementContext context, Level level, String msg) {
        this((Locator)context.getScopeData().get("xml.locator"), level, msg);
    }

    public ExtensionLogRecord(Level level, String msg, Extension extension, int lineNumber) {
        this(ExtensionLogRecord.extensionToLocator(extension, lineNumber), level, msg);
    }

    public ExtensionLogRecord(Level level, String msg, Extension extension, int lineNumber, Throwable thrown) {
        this(ExtensionLogRecord.extensionToLocator(extension, lineNumber), level, msg);
        this.setThrown(thrown);
    }

    private static Locator copyLocator(Locator locator) {
        final int lineNumber = locator.getLineNumber();
        final int colNumber = locator.getColumnNumber();
        final String publicId = locator.getPublicId();
        final String systemId = locator.getSystemId();
        return new Locator(){

            @Override
            public String getPublicId() {
                return publicId;
            }

            @Override
            public String getSystemId() {
                return systemId;
            }

            @Override
            public int getLineNumber() {
                return lineNumber;
            }

            @Override
            public int getColumnNumber() {
                return colNumber;
            }
        };
    }

    private static Locator extensionToLocator(final Extension extension, final int lineNumber) {
        return new Locator(){

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                if (extension instanceof DefaultExtension) {
                    ExtensionSource source = ((DefaultExtension)extension).getSource();
                    if (source == null) {
                        return "";
                    }
                    return String.valueOf(source.getManifestURI());
                }
                return "";
            }

            @Override
            public int getLineNumber() {
                return lineNumber;
            }

            @Override
            public int getColumnNumber() {
                return 0;
            }
        };
    }

    public Locator getLocator() {
        return this._locator;
    }
}

