/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.spi.BaseExtensionVisitor;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.DependenciesVisitor;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.extension.spi.LocatorImpl;
import javax.ide.extension.spi.SAXManifestParser;
import javax.ide.util.Version;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DependencyTree {
    private static final String SOURCE = "extSource";
    private final Map _sourcesByExtension;
    private final Map _extensionsById = new HashMap();
    private List _topologicalExtensionList;
    private final Map _unsatisfiedDependencies = new HashMap();
    private final List _cycles = new ArrayList();
    private Object STATE_NOT_VISITED = "notvisited";
    private Object STATE_VISITING = "visiting";
    private Object STATE_VISITED = "visited";

    DependencyTree(List failedSources, Map sourcesByExtension) {
        this._sourcesByExtension = sourcesByExtension;
        DependencyTree.removeDuplicates(sourcesByExtension);
        for (Extension extension : this._sourcesByExtension.keySet()) {
            this._extensionsById.put(extension.getID(), extension);
        }
        TopoSortState state = new TopoSortState();
        for (Extension thisExt : this._sourcesByExtension.keySet()) {
            if (!state.isUnvisited(thisExt)) continue;
            this.topologicalSort(state, thisExt);
        }
        this._topologicalExtensionList = state.getTopoList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Extension, ExtensionSource> loadMinimal(DefaultElementContext initialContext, Collection<ExtensionSource> extensionSources, List<ExtensionSource> failedSources, Logger logger) {
        SAXManifestParser minimalParser = new SAXManifestParser(initialContext);
        ((DefaultElementContext)minimalParser.getContext()).setMessageReporter(logger);
        MinimalExtensionVisitor visitor = new MinimalExtensionVisitor();
        minimalParser.getContext().registerChildVisitor(ExtensionVisitor.ELEMENT, visitor);
        for (ExtensionSource source : extensionSources) {
            minimalParser.getContext().getScopeData().put(SOURCE, source);
            InputStream inputStream = null;
            try {
                inputStream = source.getInputStream();
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setSystemId(source.getManifestURI().toString());
                minimalParser.parse(inputSource);
            }
            catch (ParserConfigurationException pce) {
                throw new IllegalStateException("JAXP is misconfigured", pce);
            }
            catch (SAXException saxe) {
                minimalParser.getContext().getLogger().log(Level.SEVERE, "Failed to process extension source: " + saxe.getLocalizedMessage(), new LocatorImpl(source.getManifestURI().toString()));
                failedSources.add(source);
            }
            catch (FileNotFoundException fnf) {
                fnf.printStackTrace();
                minimalParser.getContext().getLogger().log(Level.SEVERE, source.getName() + " does not contain an extension manifest.", new LocatorImpl(source.getManifestURI().toString()));
            }
            catch (IOException ioe) {
                minimalParser.getContext().getLogger().log(Level.SEVERE, "Failed to process extension source " + source.getName() + ": " + ioe.getLocalizedMessage(), new LocatorImpl(source.getManifestURI().toString()));
                failedSources.add(source);
            }
            finally {
                try {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
                catch (IOException ioe) {
                    minimalParser.getContext().getLogger().log(Level.SEVERE, "Exception closing stream", ioe);
                }
            }
        }
        return visitor.getSourcesByExtension();
    }

    public static DependencyTree buildTree(Collection extensionSources, EnabledExtensionLookup lookup, Logger logger, DefaultElementContext initialContext) {
        ArrayList<ExtensionSource> failedSources = new ArrayList<ExtensionSource>();
        Map<Extension, ExtensionSource> sbe = DependencyTree.loadMinimal(initialContext, extensionSources, failedSources, logger);
        Iterator<Extension> i = sbe.keySet().iterator();
        while (i.hasNext()) {
            Extension e = i.next();
            if (lookup.isExtensionEnabled(e)) continue;
            i.remove();
        }
        return new DependencyTree(failedSources, sbe);
    }

    public static void removeDuplicates(Map sourcesByExtension) {
        HashMap<String, Extension> latestExtensionById = new HashMap<String, Extension>();
        ArrayList<Extension> extensionsToRemove = new ArrayList<Extension>();
        for (Extension extension : sourcesByExtension.keySet()) {
            Extension latest = (Extension)latestExtensionById.get(extension.getID());
            if (latest == null) {
                latestExtensionById.put(extension.getID(), extension);
                continue;
            }
            if (extension.getVersion().compareTo(latest.getVersion()) > 0) {
                extensionsToRemove.add(latest);
                latestExtensionById.put(extension.getID(), extension);
                continue;
            }
            extensionsToRemove.add(extension);
        }
        for (Extension extension : extensionsToRemove) {
            sourcesByExtension.remove(extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void topologicalSort(TopoSortState state, Extension ext) {
        try {
            state.startVisiting(ext);
            for (ExtensionDependency dep : ext.getDependencies()) {
                Extension depExt = (Extension)this._extensionsById.get(dep.getID());
                if (depExt == null || state.isUnsatisfied(depExt) || !this.isVersionSatisfied(dep, depExt)) {
                    state.markUnsatisfiedChain();
                    ArrayList<ExtensionDependency> unsat = (ArrayList<ExtensionDependency>)this._unsatisfiedDependencies.get(ext);
                    if (unsat == null) {
                        unsat = new ArrayList<ExtensionDependency>();
                        this._unsatisfiedDependencies.put(ext, unsat);
                    }
                    unsat.add(dep);
                }
                if (depExt == null) continue;
                if (state.isVisiting(depExt)) {
                    state.markCycleChain(depExt);
                }
                if (!state.isUnvisited(depExt)) continue;
                this.topologicalSort(state, depExt);
            }
        }
        finally {
            if (!state.isUnsatisfied(ext)) {
                state.addToTopo(ext);
            }
            state.endVisiting(ext);
        }
    }

    private boolean isVersionSatisfied(ExtensionDependency dep, Extension ext) {
        if (ext != null) {
            if (dep.getMinimumVersion() != null && dep.getMinimumVersion().compareTo(ext.getVersion()) > 0) {
                return false;
            }
            if (dep.getMaximumVersion() != null && dep.getMaximumVersion().compareTo(ext.getVersion()) < 0) {
                return false;
            }
        }
        return true;
    }

    public List getSortedExtensionIDs() {
        ArrayList<String> idList = new ArrayList<String>(this._topologicalExtensionList.size());
        for (Extension ext : this._topologicalExtensionList) {
            idList.add(ext.getID());
        }
        return Collections.unmodifiableList(idList);
    }

    public Version getResolvedVersion(String id) {
        Extension ext = (Extension)this._extensionsById.get(id);
        return ext.getVersion();
    }

    public Collection getCycles() {
        return this._cycles;
    }

    public Collection getUnsatisfiedExtensions() {
        return Collections.unmodifiableCollection(this._unsatisfiedDependencies.keySet());
    }

    public Collection getUnsatisfiedDependencies(Extension unsatisfied) {
        if (unsatisfied == null) {
            throw new NullPointerException("unsatisfied is null");
        }
        Collection result = (Collection)this._unsatisfiedDependencies.get(unsatisfied);
        if (result == null) {
            throw new IllegalArgumentException("Not in the list of unsatisfied extensions: " + unsatisfied);
        }
        return Collections.unmodifiableCollection(result);
    }

    public ExtensionSource getSource(String id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        Extension extension = (Extension)this._extensionsById.get(id);
        if (extension == null) {
            throw new IllegalArgumentException("Unknown extension id " + id);
        }
        return (ExtensionSource)this._sourcesByExtension.get(extension);
    }

    public static interface EnabledExtensionLookup {
        public boolean isExtensionEnabled(Extension var1);
    }

    private static class MinimalExtensionVisitor
    extends BaseExtensionVisitor {
        private final Map _sourcesByExtension = new HashMap();
        private ElementVisitor _dependenciesVisitor = new DependenciesVisitor();

        private MinimalExtensionVisitor() {
        }

        public Map getSourcesByExtension() {
            return this._sourcesByExtension;
        }

        @Override
        public void start(ElementStartContext start) {
            DefaultExtension ext = this.processExtension(start);
            if (ext != null) {
                start.registerChildVisitor(DependenciesVisitor.ELEMENT, this._dependenciesVisitor);
            }
        }

        @Override
        public void extension(ElementContext context, Extension extension) {
            ExtensionSource source = (ExtensionSource)context.getScopeData().get(DependencyTree.SOURCE);
            if (extension != null) {
                this._sourcesByExtension.put(extension, source);
            }
        }

        @Override
        public void addToClasspath(ElementContext context, Extension extension, URI classpathEntry) {
        }
    }

    private class TopoSortState {
        private Map _stateByExtension = new HashMap();
        private Set _unsatisfied = new HashSet();
        private List _currentlyVisiting = new ArrayList();
        private List _topoList = new ArrayList();

        private TopoSortState() {
        }

        public List getTopoList() {
            return this._topoList;
        }

        public boolean isVisiting(Extension extension) {
            return this._stateByExtension.get(extension) == DependencyTree.this.STATE_VISITING;
        }

        public boolean isVisited(Extension extension) {
            return this._stateByExtension.get(extension) == DependencyTree.this.STATE_VISITED;
        }

        public boolean isUnvisited(Extension extension) {
            Object o = this._stateByExtension.get(extension);
            return o == null || o == DependencyTree.this.STATE_NOT_VISITED;
        }

        public void addUnsatisfied(Extension extension) {
            this._unsatisfied.add(extension);
        }

        public boolean isUnsatisfied(Extension extension) {
            return this._unsatisfied.contains(extension);
        }

        public void startVisiting(Extension extension) {
            this._currentlyVisiting.add(extension);
            this._stateByExtension.put(extension, DependencyTree.this.STATE_VISITING);
        }

        public void endVisiting(Extension extension) {
            this._currentlyVisiting.remove(extension);
            this._stateByExtension.put(extension, DependencyTree.this.STATE_VISITED);
        }

        public void markUnsatisfiedChain() {
            Iterator i = this._currentlyVisiting.iterator();
            while (i.hasNext()) {
                this.addUnsatisfied((Extension)i.next());
            }
        }

        public void markCycleChain(Extension current) {
            ArrayList<Extension> al = new ArrayList<Extension>();
            al.addAll(this._currentlyVisiting);
            al.add(current);
            DependencyTree.this._cycles.add(al);
        }

        public void addToTopo(Extension extension) {
            this._topoList.add(extension);
        }
    }
}

