/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.reportactions;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.IResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.ResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.dialogs.jobclass.JobClassDropAction;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobDropAction;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobRunAction;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobStopAction;
import oracle.dbtools.scheduler.dialogs.program.ProgramDropAction;
import oracle.dbtools.scheduler.dialogs.schedule.ScheduleDropAction;
import oracle.dbtools.scheduler.panels.EnableAction;
import oracle.dbtools.scheduler.panels.chain.ChainDropAction;
import oracle.dbtools.scheduler.panels.chain.ChainRunAction;
import oracle.dbtools.scheduler.panels.dbdestination.DBDestinationDropAction;
import oracle.dbtools.scheduler.panels.groups.GroupDropAction;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.sql.CHAR;

public class SchedulerReportAction
extends GridContextMenuItem {
    private int _currentReport = 0;
    private int _ownerCol = -1;
    private static final int JobSelected = 1;
    private static final int ProgramSelected = 2;
    private static final int ScheduleSelected = 3;
    private static final int DatabaseDestinationSelected = 4;
    private static final int ExternalDestinationSelected = 5;
    private static final int GroupSelected = 6;
    private static final int JobClassSelected = 7;
    private static final int WindowSelected = 8;
    private static final int ChainSelected = 9;
    private static final String JobName = "JOB_NAME";
    private static final String ProgramName = "PROGRAM_NAME";
    private static final String ScheduleName = "SCHEDULE_NAME";
    private static final String DatabaseDestinationName = "DATABASE_DESTINATION_NAME";
    private static final String ExternalDestinationName = "EXTERNAL_DESTINATION_NAME";
    private static final String GroupName = "GROUP_NAME";
    private static final String JobClassName = "JOB_CLASS_NAME";
    private static final String WindowName = "WINDOW_NAME";
    private static final String ChainName = "CHAIN_NAME";
    private static final String Owner = "OWNER";
    private static final String JobReport = "/* Scheduler Reports All Jobs";
    private static final String ProgramReport = "/* Scheduler Reports All Programs";
    private static final String ScheduleReport = "/* Scheduler Reports All Schedules";
    private static final String DatabaseDestinationReport = "/* Scheduler Reports All DatabaseDestinations";
    private static final String ExternalDestinationReport = "/* Scheduler Reports All ExternalDestinations";
    private static final String GroupReport = "/* Scheduler Reports All Groups";
    private static final String JobClassReport = "/* Scheduler Reports All Job Classes";
    private static final String WindowReport = "/* Scheduler Reports All Windows";
    private static final String ChainReport = "/* Scheduler Reports All Chains";
    private int _NameCol = -1;
    TableModel _ObjTable = null;
    private String reportObjectname = "";
    private static SchedulerReportAction _instance;
    public static final String SCHEDULER_DROP_TITLE = "SchedulerDropObject";
    public static final int SCHEDULER_DROP_ID;
    public static IdeAction SCHEDULER_DROP;
    public static final String SCHEDULER_ENABLE_DISABLE_TITLE = "SchedulerEnableDisableObject";
    public static final int SCHEDULER_ENABLE_DISABLE_ID;
    public static IdeAction SCHEDULER_ENABLE_DISABLE;
    public static final String JOB_RUN_TITLE = "JobRunObject";
    public static final int JOB_RUN_ID;
    public static IdeAction JOB_RUN;
    public static final String JOB_STOP_TITLE = "JobStopObject";
    public static final int JOB_STOP_ID;
    public static IdeAction JOB_STOP;
    public static final String CHAIN_RUN_TITLE = "ChainRunObject";
    public static final int CHAIN_RUN_ID;
    public static IdeAction CHAIN_RUN;

    private SchedulerReportAction() {
        this.initAction();
    }

    private void initAction() {
        if (SCHEDULER_DROP == null) {
            SCHEDULER_DROP = this.createAction(SCHEDULER_DROP_ID, SchedulerArb.getString("DROP_ACTION"), null);
        }
        if (JOB_RUN == null) {
            JOB_RUN = this.createAction(JOB_RUN_ID, SchedulerArb.getString("JOB_RUN_ACTION"), null);
        }
        if (CHAIN_RUN == null) {
            CHAIN_RUN = this.createAction(CHAIN_RUN_ID, SchedulerArb.getString("CHAIN_RUN_ACTION"), null);
        }
        if (JOB_STOP == null) {
            JOB_STOP = this.createAction(JOB_STOP_ID, SchedulerArb.getString("JOB_STOP_ACTION"), null);
        }
        if (SCHEDULER_ENABLE_DISABLE == null) {
            SCHEDULER_ENABLE_DISABLE = this.createAction(SCHEDULER_ENABLE_DISABLE_ID, SchedulerArb.getString("ENABLE_DISABLE_ACTION"), null);
        }
    }

    public static SchedulerReportAction getInstance() {
        if (_instance == null) {
            _instance = new SchedulerReportAction();
        }
        return _instance;
    }

    private boolean isScheduleReport(String string) {
        if (string.startsWith(JobReport)) {
            this._currentReport = 1;
            this.reportObjectname = JobName;
            return true;
        }
        if (string.startsWith(ProgramReport)) {
            this._currentReport = 2;
            this.reportObjectname = ProgramName;
            return true;
        }
        if (string.startsWith(ScheduleReport)) {
            this._currentReport = 3;
            this.reportObjectname = ScheduleName;
            return true;
        }
        if (string.startsWith(DatabaseDestinationReport)) {
            this._currentReport = 4;
            this.reportObjectname = DatabaseDestinationName;
            return true;
        }
        if (string.startsWith(ExternalDestinationReport)) {
            this._currentReport = 5;
            this.reportObjectname = ExternalDestinationName;
            return true;
        }
        if (string.startsWith(GroupReport)) {
            this._currentReport = 6;
            this.reportObjectname = GroupName;
            return true;
        }
        if (string.startsWith(JobClassReport)) {
            this._currentReport = 7;
            this.reportObjectname = JobClassName;
            return true;
        }
        if (string.startsWith(WindowReport)) {
            this._currentReport = 8;
            this.reportObjectname = WindowName;
            return true;
        }
        if (string.startsWith(ChainReport)) {
            this._currentReport = 9;
            this.reportObjectname = ChainName;
            return true;
        }
        return false;
    }

    protected boolean canShow(ContextMenu contextMenu) {
        IResultSetTableModel iResultSetTableModel;
        String string;
        if (contextMenu.getContext().getEvent().getSource() instanceof ResultSetTable && this.isScheduleReport(string = (iResultSetTableModel = (IResultSetTableModel)this._table.getModel()).getSql())) {
            if (contextMenu.getContext().getEvent().getSource() instanceof ResultSetTable) {
                int n;
                int[] nArray = this._table.getSelectedRows();
                if (nArray.length == 0) {
                    return false;
                }
                int n2 = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
                int n3 = this._table.columnAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
                n2 = this._table.convertRowIndexToModel(n2);
                n3 = this._table.convertColumnIndexToModel(n3);
                String string2 = this._table.getModel().getColumnName(n3);
                this._ObjTable = this._table.getModel();
                String string3 = "";
                this._ownerCol = -1;
                for (n = 0; n < this._ObjTable.getColumnCount(); ++n) {
                    string3 = this._ObjTable.getColumnName(n);
                    if (!string3.equals(Owner)) continue;
                    this._ownerCol = n;
                    break;
                }
                for (n = 0; n < this._ObjTable.getColumnCount(); ++n) {
                    string3 = this._ObjTable.getColumnName(n);
                    if (!string3.equals(this.reportObjectname)) continue;
                    this._NameCol = n;
                    break;
                }
            }
            return true;
        }
        return false;
    }

    protected void createAndShowMenu(ContextMenu contextMenu) {
        String string = SchedulerArb.getString("REPORT_ACTION_MENU");
        JMenu jMenu = contextMenu.createMenu(StringUtils.stripMnemonic((String)string), (float)StringUtils.getMnemonicKeyCode((String)string));
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)SCHEDULER_DROP);
        JMenuItem jMenuItem2 = contextMenu.createMenuItem((ToggleAction)SCHEDULER_ENABLE_DISABLE);
        switch (this._currentReport) {
            case 1: {
                JMenuItem jMenuItem3 = contextMenu.createMenuItem((ToggleAction)JOB_RUN);
                JMenuItem jMenuItem4 = contextMenu.createMenuItem((ToggleAction)JOB_STOP);
                jMenuItem3.setText(SchedulerArb.getString("JOB_RUN_ACTION"));
                jMenuItem4.setText(SchedulerArb.getString("JOB_STOP_ACTION"));
                jMenu.add(jMenuItem3);
                jMenu.add(jMenuItem4);
                jMenuItem.setText(SchedulerArb.getString("DROP_JOB_ACTION"));
                jMenuItem2.setText(SchedulerArb.getString("ENABLE_DISABLE_JOB_ACTION"));
                jMenu.add(jMenuItem2);
                break;
            }
            case 2: {
                jMenuItem.setText(SchedulerArb.getString("DROP_PROGRAM_ACTION"));
                jMenuItem2.setText(SchedulerArb.getString("ENABLE_DISABLE_PROGRAM_ACTION"));
                jMenu.add(jMenuItem2);
                break;
            }
            case 3: {
                jMenuItem.setText(SchedulerArb.getString("DROP_SCHEDULE_ACTION"));
                break;
            }
            case 4: {
                jMenuItem.setText(SchedulerArb.getString("DROP_DBDESTINATION_ACTION"));
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                jMenuItem.setText(SchedulerArb.getString("DROP_GROUP_ACTION"));
                break;
            }
            case 7: {
                jMenuItem.setText(SchedulerArb.getString("DROP_JOBCLASS_ACTION"));
                jMenuItem2.setText(SchedulerArb.getString("ENABLE_DISABLE_JOBCLASS_ACTION"));
                jMenu.add(jMenuItem2);
                break;
            }
            case 8: {
                jMenuItem.setText(SchedulerArb.getString("DROP_SCHEDULE_ACTION"));
                break;
            }
            case 9: {
                JMenuItem jMenuItem5 = contextMenu.createMenuItem((ToggleAction)CHAIN_RUN);
                jMenuItem5.setText(SchedulerArb.getString("CHAIN_RUN_ACTION"));
                jMenu.add(jMenuItem5);
                jMenuItem.setText(SchedulerArb.getString("DROP_CHAIN_ACTION"));
                jMenuItem2.setText(SchedulerArb.getString("ENABLE_DISABLE_CHAIN_ACTION"));
                jMenu.add(jMenuItem2);
                break;
            }
        }
        jMenu.add(jMenuItem);
        contextMenu.add((Component)jMenu);
    }

    private void launchJob(IdeAction ideAction, Context context, String string, String string2, String string3) {
        DBObject dBObject;
        URL uRL;
        URL uRL2 = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string2, (String)"SCHJOB");
        if (uRL2 != null && (uRL = DBURLFormatHelper.getURL((URL)uRL2, (String)string3)) != null && (dBObject = new DBObject(uRL)) != null) {
            ActionDialog actionDialog;
            int n = ideAction.getCommandId();
            if (n == SCHEDULER_DROP_ID) {
                actionDialog = new NewJobDropAction();
                actionDialog.setDBObject(dBObject);
                actionDialog.setContext(context);
                actionDialog.launch();
            }
            if (n == SCHEDULER_ENABLE_DISABLE_ID) {
                actionDialog = new EnableAction();
                actionDialog.setDBObject(dBObject);
                actionDialog.setContext(context);
                actionDialog.launch();
            }
            if (n == JOB_STOP_ID) {
                actionDialog = new NewJobStopAction();
                actionDialog.setDBObject(dBObject);
                actionDialog.setContext(context);
                actionDialog.launch();
            }
            if (n == JOB_RUN_ID) {
                actionDialog = new NewJobRunAction();
                actionDialog.setDBObject(dBObject);
                actionDialog.setContext(context);
                actionDialog.launch();
            }
        }
    }

    private void launchProgram(IdeAction ideAction, Context context, String string, String string2, String string3) {
        DBObject dBObject;
        URL uRL;
        URL uRL2 = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string2, (String)"SCHPROGRAM");
        if (uRL2 != null && (uRL = DBURLFormatHelper.getURL((URL)uRL2, (String)string3)) != null && (dBObject = new DBObject(uRL)) != null) {
            if (ideAction.getCommandId() == SCHEDULER_DROP_ID) {
                ProgramDropAction programDropAction = new ProgramDropAction();
                programDropAction.setDBObject(dBObject);
                programDropAction.setContext(context);
                programDropAction.launch();
            } else {
                EnableAction enableAction = new EnableAction();
                enableAction.setDBObject(dBObject);
                enableAction.setContext(context);
                enableAction.launch();
            }
        }
    }

    private void launchSchedule(IdeAction ideAction, Context context, String string, String string2, String string3) {
        DBObject dBObject;
        URL uRL;
        URL uRL2 = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string2, (String)"SCHSCHEDULE");
        if (uRL2 != null && (uRL = DBURLFormatHelper.getURL((URL)uRL2, (String)string3)) != null && (dBObject = new DBObject(uRL)) != null && ideAction.getCommandId() == SCHEDULER_DROP_ID) {
            ScheduleDropAction scheduleDropAction = new ScheduleDropAction();
            scheduleDropAction.setDBObject(dBObject);
            scheduleDropAction.setContext(context);
            scheduleDropAction.launch();
        }
    }

    private void launchDatabaseDestination(IdeAction ideAction, Context context, String string, String string2, String string3) {
        DBObject dBObject;
        URL uRL;
        URL uRL2 = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string2, (String)"SCHDBDESTINATION");
        if (uRL2 != null && (uRL = DBURLFormatHelper.getURL((URL)uRL2, (String)string3)) != null && (dBObject = new DBObject(uRL)) != null && ideAction.getCommandId() == SCHEDULER_DROP_ID) {
            DBDestinationDropAction dBDestinationDropAction = new DBDestinationDropAction();
            dBDestinationDropAction.setDBObject(dBObject);
            dBDestinationDropAction.setContext(context);
            dBDestinationDropAction.launch();
        }
    }

    private void launchExternalDestination(IdeAction ideAction, Context context, String string, String string2, String string3) {
    }

    private void launchGroup(IdeAction ideAction, Context context, String string, String string2, String string3) {
        DBObject dBObject;
        URL uRL;
        URL uRL2 = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string2, (String)"SCHDBDESTGROUP");
        if (uRL2 != null && (uRL = DBURLFormatHelper.getURL((URL)uRL2, (String)string3)) != null && (dBObject = new DBObject(uRL)) != null && ideAction.getCommandId() == SCHEDULER_DROP_ID) {
            GroupDropAction groupDropAction = new GroupDropAction();
            groupDropAction.setDBObject(dBObject);
            groupDropAction.setContext(context);
            groupDropAction.launch();
        }
    }

    private void launchJobClass(IdeAction ideAction, Context context, String string, String string2, String string3) {
        DBObject dBObject;
        URL uRL;
        URL uRL2 = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string2, (String)"SCHJOBCLASS");
        if (uRL2 != null && (uRL = DBURLFormatHelper.getURL((URL)uRL2, (String)string3)) != null && (dBObject = new DBObject(uRL)) != null) {
            if (ideAction.getCommandId() == SCHEDULER_DROP_ID) {
                JobClassDropAction jobClassDropAction = new JobClassDropAction();
                jobClassDropAction.setDBObject(dBObject);
                jobClassDropAction.setContext(context);
                jobClassDropAction.launch();
            } else {
                EnableAction enableAction = new EnableAction();
                enableAction.setDBObject(dBObject);
                enableAction.setContext(context);
                enableAction.launch();
            }
        }
    }

    private void launchWindow(IdeAction ideAction, Context context, String string, String string2, String string3) {
    }

    private void launchChain(IdeAction ideAction, Context context, String string, String string2, String string3) {
        DBObject dBObject;
        URL uRL;
        URL uRL2 = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string2, (String)"SCHCHAIN");
        if (uRL2 != null && (uRL = DBURLFormatHelper.getURL((URL)uRL2, (String)string3)) != null && (dBObject = new DBObject(uRL)) != null) {
            ActionDialog actionDialog;
            int n = ideAction.getCommandId();
            if (n == SCHEDULER_DROP_ID) {
                actionDialog = new ChainDropAction();
                actionDialog.setDBObject(dBObject);
                actionDialog.setContext(context);
                actionDialog.launch();
            }
            if (n == SCHEDULER_ENABLE_DISABLE_ID) {
                actionDialog = new EnableAction();
                actionDialog.setDBObject(dBObject);
                actionDialog.setContext(context);
                actionDialog.launch();
            }
            if (n == CHAIN_RUN_ID) {
                actionDialog = new ChainRunAction();
                actionDialog.setDBObject(dBObject);
                actionDialog.setContext(context);
                actionDialog.launch();
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == SCHEDULER_DROP_ID || n == JOB_RUN_ID || n == JOB_STOP_ID || n == CHAIN_RUN_ID || n == SCHEDULER_ENABLE_DISABLE_ID) {
            String string;
            AbstractRaptorGridModel abstractRaptorGridModel;
            if (this._table != null && (abstractRaptorGridModel = this._table.getGridModel()) != null && abstractRaptorGridModel instanceof ResultSetTableModel && (string = ((ResultSetTableModel)abstractRaptorGridModel).getConnectionName()) != null) {
                int[] nArray = this._table.getSelectedRows();
                String string2 = "";
                String string3 = "";
                Object object = null;
                String string4 = null;
                for (int i = 0; i < nArray.length; ++i) {
                    CHAR cHAR;
                    if (this._ownerCol == -1) {
                        string4 = "SYS";
                    } else {
                        object = this._ObjTable.getValueAt(nArray[i], this._ownerCol);
                        cHAR = (CHAR)object;
                        string4 = cHAR.toString();
                    }
                    object = this._ObjTable.getValueAt(nArray[i], this._NameCol);
                    cHAR = (CHAR)object;
                    String string5 = cHAR.toString();
                    if (i == 0) {
                        string3 = string4;
                        string2 = string5;
                    } else {
                        string2 = string2 + string4 + "\"" + "." + "\"" + string5;
                    }
                    if (i >= nArray.length - 1) continue;
                    string2 = string2 + "\"" + "," + "\"";
                }
                switch (this._currentReport) {
                    case 1: {
                        this.launchJob(ideAction, context, string, string3, string2);
                        break;
                    }
                    case 2: {
                        this.launchProgram(ideAction, context, string, string3, string2);
                        break;
                    }
                    case 3: {
                        this.launchSchedule(ideAction, context, string, string3, string2);
                        break;
                    }
                    case 4: {
                        this.launchDatabaseDestination(ideAction, context, string, string3, string2);
                        break;
                    }
                    case 5: {
                        this.launchExternalDestination(ideAction, context, string, string3, string2);
                        break;
                    }
                    case 6: {
                        this.launchGroup(ideAction, context, string, string3, string2);
                        break;
                    }
                    case 7: {
                        this.launchJobClass(ideAction, context, string, string3, string2);
                        break;
                    }
                    case 8: {
                        this.launchWindow(ideAction, context, string, string3, string2);
                        break;
                    }
                    case 9: {
                        this.launchChain(ideAction, context, string, string3, string2);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    static {
        SCHEDULER_DROP_ID = Ide.findOrCreateCmdID((String)SCHEDULER_DROP_TITLE);
        SCHEDULER_DROP = null;
        SCHEDULER_ENABLE_DISABLE_ID = Ide.findOrCreateCmdID((String)SCHEDULER_ENABLE_DISABLE_TITLE);
        SCHEDULER_ENABLE_DISABLE = null;
        JOB_RUN_ID = Ide.findOrCreateCmdID((String)JOB_RUN_TITLE);
        JOB_RUN = null;
        JOB_STOP_ID = Ide.findOrCreateCmdID((String)JOB_STOP_TITLE);
        JOB_STOP = null;
        CHAIN_RUN_ID = Ide.findOrCreateCmdID((String)CHAIN_RUN_TITLE);
        CHAIN_RUN = null;
    }
}

