/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.schedule;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IdentifierImpl;
import oracle.ide.help.HelpSystem;

public class ScheduleCreateAction
extends ActionDialog {
    String owner = null;
    String schedule_name = null;
    String comments = null;

    protected String getTitle() {
        return SchedulerArb.getString("SCHEDULECREATEDIALOG_TITLE");
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    protected String getQuery(Connection connection, String string) {
        String string2 = DBUtil.getDbVersion((Connection)connection).toCanonicalString();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        return dBMSSchedulerCodeGenerator.generate(string2, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected List<ActionControl> createControls(Connection var1_1) {
        var2_2 = this.getOperation();
        try {
            var3_3 = this.getObjectName();
        }
        catch (Exception var5_4) {
            var3_3 = "null";
        }
        try {
            var4_7 = this.getDBObjectSchemaName();
        }
        catch (Exception var5_5) {
            var4_7 = "null";
        }
        if (var2_2 != Operation.CREATE_NEW) {
            if (Connections.getInstance().lock(var1_1)) {
                var5_6 = null;
                try {
                    var6_8 = new HashMap();
                    var6_8.put("OBJECT_NAME", var3_3);
                    var6_8.put("OBJECT_OWNER", var4_7);
                    var7_11 = DBUtil.getInstance((Connection)var1_1);
                    var7_11.setRaiseError(true);
                    var5_6 = var7_11.executeOracleQuery(this.getQuery(var1_1, "SCHEDULE_DATA"), var6_8);
                    if (var5_6 == null || !(var8_12 = var5_6.getResultSet()).next()) ** GOTO lbl56
                    this.owner = var8_12.getString("OWNER");
                    this.schedule_name = var8_12.getString("SCHEDULE_NAME");
                    this.comments = var8_12.getString("COMMENTS");
                }
                catch (Exception var6_9) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var6_9.getStackTrace()[0].toString(), var6_9);
                }
                finally {
                    if (var5_6 != null) {
                        var5_6.close();
                    }
                    Connections.getInstance().unlock(var1_1);
                }
            }
        } else if (Connections.getInstance().lock(var1_1)) {
            var5_6 = null;
            try {
                var6_8 = new HashMap<K, V>();
                var7_11 = DBUtil.getInstance((Connection)var1_1);
                var7_11.setRaiseError(true);
                var5_6 = var7_11.executeOracleQuery(this.getQuery(var1_1, "SCHEMAS_LIST"), var6_8);
                if (var5_6 != null && (var8_12 = var5_6.getResultSet()).next()) {
                    this.owner = var8_12.getString("user");
                }
            }
            catch (Exception var6_10) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var6_10.getStackTrace()[0].toString(), var6_10);
            }
            finally {
                if (var5_6 != null) {
                    var5_6.close();
                }
                Connections.getInstance().unlock(var1_1);
            }
        }
        var5_6 = null;
        var6_8 = null;
        var7_11 = null;
        switch (1.$SwitchMap$oracle$dbtools$scheduler$panels$schedule$ScheduleCreateAction$Operation[var2_2.ordinal()]) {
            case 1: {
                var5_6 = new TextBoxActionControl("owner", SchedulerArb.getString("CREDENTIALPANEL_SCHEMA_LABEL"), this.owner);
                var5_6.setEditable(false);
                var6_8 = new TextBoxActionControl("name", SchedulerArb.getString("CREDENTIALPANEL_NAME_LABEL"), this.schedule_name);
                var6_8.setEditable(false);
                var7_11 = new TextBoxActionControl("comments", SchedulerArb.getString("CREDENTIALPANEL_DESC_LABEL"), this.comments);
                break;
            }
            case 2: {
                var5_6 = new SqlComboBoxActionControl("owner", SchedulerArb.getString("CREDENTIALPANEL_SCHEMA_LABEL"), var1_1, this.getQuery(var1_1, "SCHEMAS_LIST"), null, this.owner);
                var6_8 = new TextBoxActionControl("name", SchedulerArb.getString("CREDENTIALPANEL_NAME_LABEL"), "");
                var7_11 = new TextBoxActionControl("comments", SchedulerArb.getString("CREDENTIALPANEL_DESC_LABEL"), this.comments);
                break;
            }
            case 3: {
                var5_6 = new SqlComboBoxActionControl("owner", SchedulerArb.getString("CREDENTIALPANEL_SCHEMA_LABEL"), var1_1, this.getQuery(var1_1, "SCHEMAS_LIST"), null, var4_7);
                var6_8 = new TextBoxActionControl("name", SchedulerArb.getString("CREDENTIALPANEL_NAME_LABEL"), this.schedule_name);
                var7_11 = new TextBoxActionControl("comments", SchedulerArb.getString("CREDENTIALPANEL_DESC_LABEL"), this.comments);
            }
        }
        var8_12 = new ArrayList<Object>();
        var8_12.add(var5_6);
        var8_12.add(var6_8);
        var8_12.add(var7_11);
        return var8_12;
    }

    protected String getScript(ActionDialog.Values values) {
        Object object;
        Operation operation = this.getOperation();
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string2 = values.get("owner");
        String string3 = values.get("name");
        String string4 = values.get("comments");
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string2 != null) {
            string2 = string2.trim();
            object = new IdentifierImpl(string2);
            string2 = ((IdentifierImpl)object).getId();
        }
        if (string3 != null) {
            string3 = string3.trim();
            object = new IdentifierImpl(string3);
            string3 = ((IdentifierImpl)object).getId();
        }
        object = new TreeMap<String, String>();
        object.put("owner", string2);
        object.put("name", string3);
        object.put("comments", string4);
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        treeMap.put("owner", ScheduleCreateAction.equals(string2, this.owner) == false);
        treeMap.put("name", ScheduleCreateAction.equals(string3, this.schedule_name) == false);
        treeMap.put("comments", ScheduleCreateAction.equals(string4, this.comments) == false);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", object);
        treeMap2.put("changes", treeMap);
        String string5 = null;
        switch (operation) {
            case UPDATE: {
                string5 = dBMSSchedulerCodeGenerator.generate(string, "SCHEDULE_UPDATE", treeMap2);
                break;
            }
            case CREATE_LIKE: {
                string5 = dBMSSchedulerCodeGenerator.generate(string, "SCHEDULE_CREATE", treeMap2);
                break;
            }
            case CREATE_NEW: {
                string5 = dBMSSchedulerCodeGenerator.generate(string, "SCHEDULE_CREATE", treeMap2);
            }
        }
        return string5;
    }

    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "f1_newScheduleDialog_html");
    }

    private static Boolean equals(Object object, Object object2) {
        if (object == null || object2 == null) {
            return Boolean.FALSE;
        }
        return object.equals(object2);
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        UPDATE;

    }
}

