/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.program;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.common.plsqlpkg.PlSqlPkgSpecParser;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.QualifiedIdentifier;

public class ProgramPropertyPanelModel {
    public static final String SQL_PROG_TYPE_STORED_PROCEDURE = "STORED_PROCEDURE";
    public static final String SQL_PROG_TYPE_PLSQL_BLOCK = "PLSQL_BLOCK";
    public static final String SQL_PROG_TYPE_EXECUTABLE = "EXECUTABLE";
    public static final String PROG_TYPE_STORED_PROCEDURE;
    public static final String PROG_TYPE_REMOTE_STORED_PROCEDURE;
    public static final String PROG_TYPE_PLSQL_BLOCK;
    public static final String PROG_TYPE_EXECUTABLE;
    public static final String OWNER = "owner";
    public static final String PROGRAM_NAME = "program_name";
    public static final String COMMENTS = "comments";
    public static final String PROGRAM_TYPE = "program_type";
    public static final String ENABLED = "enabled";
    public static final String DETACHED = "detached";
    public static final String SCHEDULE_LIMIT = "schedule_limit";
    public static final String PRIORITY = "priority";
    public static final String WEIGHT = "weight";
    public static final String MAX_RUNS = "max_runs";
    public static final String MAX_FAILURES = "max_failures";
    public static final String MAX_RUN_DURATION = "max_run_duration";
    public static final String PROGRAM_ACTION = "program_action";
    public static final String ORIGINAL_NUMBER_OF_ARGUMENTS = "original_number_of_arguments";
    public static final String NUMBER_OF_ARGUMENTS = "number_of_arguments";
    public static final String ARGUMENT_ADDED = "argument_added";
    public static final String ARGUMENT_DELETED = "argument_deleted";
    public static final String ARGUMENT_CLEARED = "argument_cleared";
    public static final String NLS_ENV = "nls_env";
    public static final String PROGRAM_NAME_VALID_MSG = "program_namevalidmsg";
    public static final String COMMENTS_VALID_MSG = "commentsvalidmsg";
    public static final String SCHEMA_LIST = "schemaList";
    public static final String PROCEDURE_LIST = "procedureList";
    public static final String PLSQL_BLOCK = "plsql_block";
    public static final String EXECUTABLE_PATH = "executable_path";
    public static final String EXECUTABLE_ARGUMENTS = "executable_arguments";
    public static final String STORED_PROCEDURE = "stored_procedure";
    public static final String STORED_PROCEDURE_SCHEMA = "stored_procedure_schema";
    public static final String STORED_PROCEDURE_NAME = "stored_procedure_name";
    public static final String STORED_PROC_ARGUMENTS = "stored_proc_arguments";
    public static final String REMOTE_STORED_PROCEDURE = "remote_stored_procedure";
    public static final String REMOTE_STORED_PROC_ARGUMENTS = "remote_stored_proc_arguments";
    public static final String ARGUMENT_POSITION = "argument_position";
    public static final String ARGUMENT_NAME = "argument_name";
    public static final String ARGUMENT_TYPE = "argument_type";
    public static final String DEFAULT_VALUE = "default_value";
    public static final String OUT_ARGUMENT = "out_argument";
    public static final String METADATA_ATTRUBUTE = "metadata_attribute";
    public static final String METADATA_ATTRIBUTE_PREFIX = "META_ATTRIBUTE.";
    public static final Method SCHEMA_LIST_UPDATE_METHOD;
    public static final Method MODEL_UPDATE_METHOD;
    public static final Method SCHEMA_UPDATE_METHOD;
    public static final Method PROG_ARGS_UPDATE_METHOD;
    public static final Method PROCEDURES_UPDATE_METHOD;
    public static final Method PKG_PROCEDURES_UPDATE_METHOD;
    public static final Method PROCEDURE_ARGUMENTS_UPDATE_METHOD;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String program_name;
    private String owner;
    private String comments;
    private Boolean enabled;
    private Boolean detached;
    private Integer schedule_limit;
    private Integer priority;
    private Integer weight;
    private Integer max_runs;
    private Integer max_failures;
    private Long max_run_duration;
    private String nls_env;
    private String program_type;
    private String sqlProgram_type = "PLSQL_BLOCK";
    private List<ProgramArgument> program_arguments = null;
    private List<ProgramArgument> storedProcedure_arguments = new Vector<ProgramArgument>();
    private List<ProgramArgument> remoteStoredProcedure_arguments = new Vector<ProgramArgument>();
    private List<ProgramArgument> executable_arguments = new Vector<ProgramArgument>();
    private static List<String> executable_argument_types;
    private List<String> metadata_attribute_names = new Vector<String>();
    private static List<String> inOutList;
    private String plsql_block;
    private String executablePath;
    private String storedProc;
    private String remoteStoredProc;
    private String program_nameValidMsg;
    private String commentsValidMsg;
    private List<String> schemasList;
    private List<String> proceduresList;
    private int originalNumberOfArguments = 0;
    private int argCount = 1;

    public ProgramPropertyPanelModel() {
        this.program_type = PROG_TYPE_PLSQL_BLOCK;
    }

    public ProgramPropertyPanelModel(ProgramPropertyPanelModel programPropertyPanelModel) {
        this();
        if (programPropertyPanelModel != null) {
            this.program_name = programPropertyPanelModel.program_name;
            this.owner = programPropertyPanelModel.owner;
            this.comments = programPropertyPanelModel.comments;
            this.enabled = programPropertyPanelModel.enabled;
            this.program_name = programPropertyPanelModel.program_name;
            this.setProgram_type(programPropertyPanelModel.program_type);
            this.detached = programPropertyPanelModel.detached;
            this.max_failures = programPropertyPanelModel.max_failures;
            this.max_run_duration = programPropertyPanelModel.max_run_duration;
            this.max_runs = programPropertyPanelModel.max_runs;
            this.weight = programPropertyPanelModel.weight;
            this.argCount = programPropertyPanelModel.argCount;
            this.priority = programPropertyPanelModel.priority;
            this.nls_env = programPropertyPanelModel.nls_env;
            this.schedule_limit = programPropertyPanelModel.schedule_limit;
            this.plsql_block = programPropertyPanelModel.plsql_block;
            this.originalNumberOfArguments = programPropertyPanelModel.originalNumberOfArguments;
            for (ProgramArgument programArgument : programPropertyPanelModel.executable_arguments) {
                this.executable_arguments.add(new ProgramArgument(programArgument));
            }
            this.executablePath = programPropertyPanelModel.executablePath;
            for (ProgramArgument programArgument : programPropertyPanelModel.storedProcedure_arguments) {
                this.storedProcedure_arguments.add(new ProgramArgument(programArgument));
            }
            for (ProgramArgument programArgument : programPropertyPanelModel.remoteStoredProcedure_arguments) {
                this.remoteStoredProcedure_arguments.add(new ProgramArgument(programArgument));
            }
            this.storedProc = programPropertyPanelModel.storedProc;
            this.schemasList = programPropertyPanelModel.schemasList != null ? new Vector<String>(programPropertyPanelModel.schemasList) : null;
            this.proceduresList = programPropertyPanelModel.proceduresList != null ? new Vector<String>(programPropertyPanelModel.proceduresList) : null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    private String getStringFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getString(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private int getIntFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getInt(string);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private long getLongFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getLong(string);
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    public void setModelFromResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet != null && resultSet.next()) {
            String string;
            this.setOwner(this.getStringFromRS(resultSet, "OWNER"));
            this.setProgram_name(this.getStringFromRS(resultSet, "PROGRAM_NAME"));
            this.setProgram_type(this.toLocalProgType(this.getStringFromRS(resultSet, "PROGRAM_TYPE")));
            this.setProgram_action(this.getStringFromRS(resultSet, "PROGRAM_ACTION"));
            if (this.getProgram_type().equals(PROG_TYPE_STORED_PROCEDURE)) {
                string = this.getStoredProcSchemaRaw();
                String string2 = this.getStoredProcName();
                if (string == null) {
                    if (!this.proceduresList.contains(string2)) {
                        this.setRemoteStoredProc(this.getStringFromRS(resultSet, "PROGRAM_ACTION"));
                        this.setProgram_type(PROG_TYPE_REMOTE_STORED_PROCEDURE);
                    }
                } else if (!this.schemasList.contains(string)) {
                    this.setRemoteStoredProc(this.getStringFromRS(resultSet, "PROGRAM_ACTION"));
                    this.setProgram_type(PROG_TYPE_REMOTE_STORED_PROCEDURE);
                }
            }
            this.setEnabled(this.getStringFromRS(resultSet, "ENABLED") == null ? null : Boolean.valueOf(this.getStringFromRS(resultSet, "ENABLED").equalsIgnoreCase("true")));
            this.setDetached(this.getStringFromRS(resultSet, "DETACHED") == null ? null : Boolean.valueOf(this.getStringFromRS(resultSet, "DETACHED").equalsIgnoreCase("true")));
            this.setSchedule_limit(this.getIntFromRS(resultSet, "SCHEDULE_LIMIT"));
            this.setPriority(this.getIntFromRS(resultSet, "PRIORITY"));
            this.setWeight(this.getIntFromRS(resultSet, "WEIGHT"));
            this.setMax_runs(this.getIntFromRS(resultSet, "MAX_RUNS"));
            this.setMax_failures(this.getIntFromRS(resultSet, "MAX_FAILURES"));
            this.setMax_run_duration(this.getLongFromRS(resultSet, "MAX_RUN_DURATION"));
            this.setNls_env(this.getStringFromRS(resultSet, "NLS_ENV"));
            this.setComments(this.getStringFromRS(resultSet, "COMMENTS"));
            this.setOriginalNumberOfArguments(this.getIntFromRS(resultSet, "NUMBER_OF_ARGUMENTS"));
            string = this.getProgram_type();
            if (string == null || string.equals(PROG_TYPE_PLSQL_BLOCK)) {
                this.executable_arguments.clear();
                this.setExecutablePath(null);
                this.storedProcedure_arguments.clear();
                this.remoteStoredProcedure_arguments.clear();
                this.setStoredProc(null);
                this.setRemoteStoredProc(null);
            } else if (string.equals(PROG_TYPE_STORED_PROCEDURE)) {
                this.executable_arguments.clear();
                this.setRemoteStoredProc(this.getStringFromRS(resultSet, "PROGRAM_ACTION"));
                this.setExecutablePath(null);
                this.setPlsql_block(null);
            } else if (string.equals(PROG_TYPE_EXECUTABLE)) {
                this.executable_arguments.clear();
                this.storedProcedure_arguments.clear();
                this.remoteStoredProcedure_arguments.clear();
                this.setPlsql_block(null);
            }
        }
    }

    public void setSchemaFromResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet != null && resultSet.next()) {
            String string = this.getStringFromRS(resultSet, "USER");
            this.setOwner(string);
            this.setStoredProcSchema(string);
        }
    }

    public void setSchemaNameListFromResultSet(ResultSet resultSet) throws SQLException {
        Vector<String> vector = new Vector<String>();
        if (resultSet != null) {
            while (resultSet.next()) {
                vector.add(this.getStringFromRS(resultSet, "USERNAME"));
            }
        }
        this.setSchemasList(vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgArgsFromResultSet(ResultSet resultSet) throws SQLException {
        this.clearProgramArguments();
        if (this.getProgram_type().equals(PROG_TYPE_EXECUTABLE) || this.getProgram_type().equals(PROG_TYPE_STORED_PROCEDURE) || this.getProgram_type().equals(PROG_TYPE_REMOTE_STORED_PROCEDURE)) {
            boolean bl = this.getProgram_type().equals(PROG_TYPE_STORED_PROCEDURE);
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string = this.getStringFromRS(resultSet, "METADATA_ATTRIBUTE");
                    this.createProgramArgument(this.getStringFromRS(resultSet, "ARGUMENT_NAME"), Integer.valueOf(this.getStringFromRS(resultSet, "ARGUMENT_POSITION")) - 1, this.getStringFromRS(resultSet, "ARGUMENT_TYPE"), string == null || string.length() == 0 ? this.getStringFromRS(resultSet, "DEFAULT_VALUE") : METADATA_ATTRIBUTE_PREFIX + string, this.getStringFromRS(resultSet, "OUT_ARGUMENT") == null ? null : Boolean.valueOf(this.getStringFromRS(resultSet, "OUT_ARGUMENT").equalsIgnoreCase("TRUE")));
                    if (!bl) continue;
                    String string2 = this.getProgram_type();
                    try {
                        this.setProgram_type(PROG_TYPE_REMOTE_STORED_PROCEDURE);
                        this.createProgramArgument(this.getStringFromRS(resultSet, "ARGUMENT_NAME"), Integer.valueOf(this.getStringFromRS(resultSet, "ARGUMENT_POSITION")) - 1, this.getStringFromRS(resultSet, "ARGUMENT_TYPE"), string == null || string.length() == 0 ? this.getStringFromRS(resultSet, "DEFAULT_VALUE") : METADATA_ATTRIBUTE_PREFIX + string, this.getStringFromRS(resultSet, "OUT_ARGUMENT") == null ? null : Boolean.valueOf(this.getStringFromRS(resultSet, "OUT_ARGUMENT").equalsIgnoreCase("TRUE")));
                    }
                    finally {
                        this.setProgram_type(string2);
                    }
                }
            }
        } else if (this.getProgram_type().equals(PROG_TYPE_PLSQL_BLOCK)) {
            // empty if block
        }
    }

    public void setProceduresListFromResultSet(ResultSet resultSet) throws SQLException {
        Vector<String> vector = new Vector<String>();
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "OBJECT_NAME");
                if (string == null || vector.contains(string)) continue;
                vector.add(string);
            }
        }
        this.setProceduresList(vector);
    }

    public void setPkgProceduresListFromResultSet(ResultSet resultSet) throws SQLException {
        String string = "";
        String string2 = "";
        String string3 = null;
        String string4 = null;
        PlSqlPkgSpecParser plSqlPkgSpecParser = null;
        Vector<String> vector = new Vector<String>();
        List<Member> list = null;
        if (resultSet != null) {
            while (resultSet.next()) {
                string3 = this.getStringFromRS(resultSet, "OWNER");
                string4 = this.getStringFromRS(resultSet, "NAME");
                if (string3 == null || string4 == null || !string3.equals(string) || !string4.equals(string2)) {
                    if (plSqlPkgSpecParser == null) {
                        plSqlPkgSpecParser = new PlSqlPkgSpecParser();
                    } else {
                        list = plSqlPkgSpecParser.parseMembers();
                        for (Member member : list) {
                            if (!member.type.equals("PROCEDURE")) continue;
                            vector.add(string2 + "." + member.name);
                        }
                    }
                    plSqlPkgSpecParser.reset();
                    string = string3;
                    string2 = string4;
                }
                String string5 = this.getStringFromRS(resultSet, "TEXT");
                plSqlPkgSpecParser.addLine(string5);
            }
            if (plSqlPkgSpecParser != null) {
                list = plSqlPkgSpecParser.parseMembers();
                for (Member member : list) {
                    String string6;
                    if (!member.type.equals("PROCEDURE") || vector.contains(string6 = string2 + "." + member.name)) continue;
                    vector.add(string6);
                }
            }
        }
        if (vector.size() > 0) {
            Member member;
            Iterator<Member> iterator = this.getProceduresList();
            member = new Vector(iterator);
            member.addAll(vector);
            this.setProceduresList((List<String>)member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcedureArgumentsFromResultSet(ResultSet resultSet) throws SQLException {
        this.clearProgramArguments();
        if (resultSet != null) {
            String string = this.getProgram_type();
            this.setProgram_type(PROG_TYPE_STORED_PROCEDURE);
            try {
                this.clearProgramArguments();
                while (resultSet.next()) {
                    String string2 = this.getStringFromRS(resultSet, "ARGUMENT_NAME");
                    int n = this.getIntFromRS(resultSet, "POSITION") - 1;
                    String string3 = this.getStringFromRS(resultSet, "DATA_TYPE");
                    String string4 = this.getStringFromRS(resultSet, "DEFAULT_VALUE");
                    String string5 = this.getStringFromRS(resultSet, "IN_OUT");
                    this.createProgramArgument(string2, n, string3, string4, string5 == null ? false : string5.equalsIgnoreCase("OUT"));
                }
            }
            finally {
                this.setProgram_type(string);
            }
        }
    }

    public void setMetadata_argument_names(String string) {
        this.metadata_attribute_names.clear();
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(";")) {
                this.metadata_attribute_names.add(string2);
            }
        }
    }

    public List<String> getMetadata_argument_names() {
        return this.metadata_attribute_names;
    }

    public void setProgram_name(String string) {
        String string2 = this.program_name;
        this.program_name = string;
        this.firePropertyChange(PROGRAM_NAME, string2, string);
    }

    public String getProgram_name() {
        return this.program_name;
    }

    public void setComments(String string) {
        String string2 = this.comments;
        this.comments = string;
        this.firePropertyChange(COMMENTS, string2, string);
    }

    public String getComments() {
        return this.comments;
    }

    public void setOwner(String string) {
        String string2 = this.owner;
        String string3 = this.getStoredProcSchema();
        this.owner = string;
        this.firePropertyChange(OWNER, string2, string);
        if (string3 == null) {
            String string4 = this.getStoredProcSchema();
            this.firePropertyChange(STORED_PROCEDURE_SCHEMA, string3, string4);
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setSchemasList(List<String> list) {
        List<String> list2 = this.schemasList;
        this.schemasList = list;
        this.firePropertyChange(SCHEMA_LIST, list2, list);
    }

    public List<String> getSchemasList() {
        if (this.schemasList != null) {
            return Collections.unmodifiableList(this.schemasList);
        }
        return Collections.emptyList();
    }

    public void setProceduresList(List<String> list) {
        List<String> list2 = this.proceduresList;
        this.proceduresList = list;
        this.firePropertyChange(PROCEDURE_LIST, list2, list);
    }

    public List<String> getProceduresList() {
        if (this.proceduresList != null) {
            return Collections.unmodifiableList(this.proceduresList);
        }
        return Collections.emptyList();
    }

    public void setProgram_nameValidMsg(String string) {
        String string2 = this.program_nameValidMsg;
        this.program_nameValidMsg = string;
        this.propertyChangeSupport.firePropertyChange(PROGRAM_NAME_VALID_MSG, string2, string);
    }

    public String getProgram_nameValidMsg() {
        return this.program_nameValidMsg;
    }

    public void setCommentsValidMsg(String string) {
        String string2 = this.commentsValidMsg;
        this.commentsValidMsg = string;
        this.propertyChangeSupport.firePropertyChange(COMMENTS_VALID_MSG, string2, string);
    }

    public String getCommentsValidMsg() {
        return this.commentsValidMsg;
    }

    public void setEnabled(Boolean bl) {
        Boolean bl2 = this.enabled;
        this.enabled = bl;
        this.propertyChangeSupport.firePropertyChange(ENABLED, bl2, bl);
    }

    public boolean getEnabled() {
        return this.enabled == null ? true : this.enabled;
    }

    public void setProgram_type(String string) {
        String string2 = this.program_type;
        String string3 = this.getProgram_action();
        this.program_type = string;
        String string4 = this.getProgram_action();
        if (string != null) {
            if (string.equalsIgnoreCase(PROG_TYPE_EXECUTABLE)) {
                this.sqlProgram_type = SQL_PROG_TYPE_EXECUTABLE;
                this.program_arguments = this.executable_arguments;
            }
            if (string.equalsIgnoreCase(PROG_TYPE_PLSQL_BLOCK)) {
                this.sqlProgram_type = SQL_PROG_TYPE_PLSQL_BLOCK;
                this.program_arguments = Collections.emptyList();
            }
            if (string.equalsIgnoreCase(PROG_TYPE_STORED_PROCEDURE)) {
                this.sqlProgram_type = SQL_PROG_TYPE_STORED_PROCEDURE;
                this.program_arguments = this.storedProcedure_arguments;
            }
            if (string.equalsIgnoreCase(PROG_TYPE_REMOTE_STORED_PROCEDURE)) {
                this.sqlProgram_type = SQL_PROG_TYPE_STORED_PROCEDURE;
                this.program_arguments = this.remoteStoredProcedure_arguments;
            }
        }
        this.propertyChangeSupport.firePropertyChange(PROGRAM_TYPE, string2, string);
        this.propertyChangeSupport.firePropertyChange(PROGRAM_ACTION, string3, string4);
    }

    public String getProgram_type() {
        return this.program_type;
    }

    public String getSQLProgram_type() {
        return this.sqlProgram_type;
    }

    public void setProgram_action(String string) {
        if (this.getProgram_type().equalsIgnoreCase(PROG_TYPE_EXECUTABLE)) {
            this.setExecutablePath(string);
        } else if (this.getProgram_type().equalsIgnoreCase(PROG_TYPE_PLSQL_BLOCK)) {
            this.setPlsql_block(string);
        } else if (this.getProgram_type().equalsIgnoreCase(PROG_TYPE_STORED_PROCEDURE)) {
            this.setStoredProc(string);
        } else if (this.getProgram_type().equalsIgnoreCase(PROG_TYPE_REMOTE_STORED_PROCEDURE)) {
            this.setRemoteStoredProc(string);
        }
    }

    public String getProgram_action() {
        if (this.program_type != null) {
            if (this.program_type.equalsIgnoreCase(PROG_TYPE_EXECUTABLE)) {
                return this.getExecutablePath();
            }
            if (this.program_type.equalsIgnoreCase(PROG_TYPE_PLSQL_BLOCK)) {
                return this.getPlsql_block();
            }
            if (this.program_type.equalsIgnoreCase(PROG_TYPE_STORED_PROCEDURE)) {
                return this.getStoredProc();
            }
            if (this.program_type.equalsIgnoreCase(PROG_TYPE_REMOTE_STORED_PROCEDURE)) {
                return this.getRemoteStoredProc();
            }
        }
        return null;
    }

    public int getNumber_of_arguments() {
        return this.program_arguments == null ? 0 : this.program_arguments.size();
    }

    public ProgramArgument createProgramArgument(String string, int n, String string2, String string3, Boolean bl) {
        ProgramArgument programArgument = new ProgramArgument();
        int n2 = n;
        programArgument.argument_name = string;
        programArgument.argument_type = string2;
        programArgument.default_value = string3;
        programArgument.out_argument = bl;
        if (n > this.program_arguments.size()) {
            n2 = this.program_arguments.size();
            this.program_arguments.add(programArgument);
        } else {
            try {
                this.program_arguments.add(n, programArgument);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.propertyChangeSupport.firePropertyChange(ARGUMENT_ADDED, programArgument, (Object)n2);
        this.propertyChangeSupport.firePropertyChange(NUMBER_OF_ARGUMENTS, this.program_arguments.size() - 1, this.program_arguments.size());
        return programArgument;
    }

    public void removeProgramArgument(ProgramArgument programArgument) {
        int n;
        if (programArgument != null && (n = programArgument.getArgument_position()) >= 0) {
            this.removeProgramArgument(n);
        }
    }

    public void removeProgramArgument(int n) {
        if (n >= 0 && n < this.program_arguments.size()) {
            int n2 = this.program_arguments.size();
            ProgramArgument programArgument = this.program_arguments.remove(n);
            this.propertyChangeSupport.firePropertyChange(ARGUMENT_DELETED, programArgument, (Object)n);
            this.propertyChangeSupport.firePropertyChange(NUMBER_OF_ARGUMENTS, n2, this.program_arguments.size());
        }
    }

    public void clearProgramArguments() {
        if (this.program_arguments != null && this.program_arguments.size() > 0) {
            int n = this.program_arguments.size();
            this.program_arguments.clear();
            this.propertyChangeSupport.firePropertyChange(ARGUMENT_CLEARED, null, this.program_arguments);
            this.propertyChangeSupport.firePropertyChange(NUMBER_OF_ARGUMENTS, n, 0);
        }
    }

    public List<ProgramArgument> getProgramArguments() {
        return this.program_arguments;
    }

    public void setDetached(Boolean bl) {
        Boolean bl2 = this.detached;
        this.detached = bl;
        this.propertyChangeSupport.firePropertyChange(DETACHED, bl2, bl);
    }

    public Boolean getDetached() {
        return this.detached;
    }

    public void setSchedule_limit(Integer n) {
        Integer n2 = this.schedule_limit;
        this.schedule_limit = n;
        this.propertyChangeSupport.firePropertyChange(SCHEDULE_LIMIT, n2, n);
    }

    public Integer getSchedule_limit() {
        return this.schedule_limit;
    }

    public void setPriority(Integer n) {
        Integer n2 = this.priority;
        this.priority = n;
        this.propertyChangeSupport.firePropertyChange(PRIORITY, n2, n);
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setWeight(Integer n) {
        Integer n2 = this.weight;
        this.weight = n;
        this.propertyChangeSupport.firePropertyChange(WEIGHT, n2, n);
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setMax_runs(Integer n) {
        Integer n2 = this.max_runs;
        this.max_runs = n;
        this.propertyChangeSupport.firePropertyChange(MAX_RUNS, n2, n);
    }

    public Integer getMax_runs() {
        return this.max_runs;
    }

    public void setMax_failures(Integer n) {
        Integer n2 = this.max_failures;
        this.max_failures = n;
        this.propertyChangeSupport.firePropertyChange(MAX_FAILURES, n2, n);
    }

    public Integer getMax_failures() {
        return this.max_failures;
    }

    public void setMax_run_duration(Long l) {
        Long l2 = this.max_run_duration;
        this.max_run_duration = l;
        this.propertyChangeSupport.firePropertyChange(MAX_RUN_DURATION, l2, l);
    }

    public Long getMax_run_duration() {
        return this.max_run_duration;
    }

    public void setNls_env(String string) {
        String string2 = this.nls_env;
        this.nls_env = string;
        this.propertyChangeSupport.firePropertyChange(NLS_ENV, string2, string);
    }

    public String getNls_env() {
        return this.nls_env;
    }

    public void setStoredProc(String string) {
        String string2 = this.storedProc;
        this.storedProc = string;
        this.propertyChangeSupport.firePropertyChange(STORED_PROCEDURE, string2, string);
        if (this.getProgram_type() == null || this.getProgram_type().equalsIgnoreCase(PROG_TYPE_STORED_PROCEDURE)) {
            this.propertyChangeSupport.firePropertyChange(PROGRAM_ACTION, string2, string);
        }
    }

    public String getStoredProc() {
        return new QualifiedIdentifier(this.storedProc).getId(true);
    }

    public void setStoredProcName(String string) {
        String string2 = this.getStoredProcName();
        String string3 = this.getStoredProcSchema();
        this.setStoredProc((string3 == null ? "" : string3 + ".") + (string == null ? "" : string));
        this.propertyChangeSupport.firePropertyChange(STORED_PROCEDURE_NAME, string2, string);
    }

    public String getStoredProcName() {
        String string = null;
        if (this.storedProc != null) {
            int n = this.storedProc.indexOf(46);
            if (n >= 0) {
                String string2 = this.storedProc.substring(0, n);
                if (this.schemasList != null && this.schemasList.contains(string2)) {
                    if (n + 1 < this.storedProc.length()) {
                        string = this.storedProc.substring(n + 1);
                    }
                } else {
                    string = this.storedProc;
                }
            } else {
                string = this.storedProc;
            }
        }
        return string;
    }

    public void setStoredProcSchema(String string) {
        String string2 = this.getStoredProcSchema();
        String string3 = this.getStoredProcName();
        this.setStoredProc((string == null ? "" : string + ".") + (string3 == null ? "" : string3));
        this.propertyChangeSupport.firePropertyChange(STORED_PROCEDURE_SCHEMA, string2, string);
    }

    public String getStoredProcSchemaRaw() {
        int n;
        String string = null;
        if (this.storedProc != null && (n = this.storedProc.indexOf(46)) >= 0) {
            string = this.storedProc.substring(0, n);
            string = string.replaceAll("\"", "");
        }
        return string;
    }

    public String getStoredProcSchema() {
        String string = this.getOwner();
        if (this.storedProc != null) {
            String string2 = this.getStoredProcSchemaRaw();
            if (this.schemasList != null && this.schemasList.contains(string2)) {
                string = string2;
            }
        }
        return string;
    }

    public void setRemoteStoredProc(String string) {
        String string2 = this.remoteStoredProc;
        this.remoteStoredProc = string;
        this.propertyChangeSupport.firePropertyChange(REMOTE_STORED_PROCEDURE, string2, string);
        if (this.getProgram_type() == null || this.getProgram_type().equalsIgnoreCase(PROG_TYPE_REMOTE_STORED_PROCEDURE)) {
            this.propertyChangeSupport.firePropertyChange(PROGRAM_ACTION, string2, string);
        }
    }

    public String getRemoteStoredProc() {
        return this.remoteStoredProc;
    }

    public void setExecutablePath(String string) {
        String string2 = this.executablePath;
        this.executablePath = string;
        this.propertyChangeSupport.firePropertyChange(EXECUTABLE_PATH, string2, string);
        if (this.getProgram_type() == null || this.getProgram_type().equalsIgnoreCase(PROG_TYPE_EXECUTABLE)) {
            this.propertyChangeSupport.firePropertyChange(PROGRAM_ACTION, string2, string);
        }
    }

    public String getExecutablePath() {
        return this.executablePath;
    }

    public void setPlsql_block(String string) {
        String string2 = this.plsql_block;
        this.plsql_block = string;
        this.propertyChangeSupport.firePropertyChange(PLSQL_BLOCK, string2, string);
        if (this.getProgram_type() == null || this.getProgram_type().equalsIgnoreCase(PROG_TYPE_PLSQL_BLOCK)) {
            this.propertyChangeSupport.firePropertyChange(PROGRAM_ACTION, string2, string);
        }
    }

    public String getPlsql_block() {
        return this.plsql_block;
    }

    public void setArgumentPosition(ProgramArgument programArgument, int n) {
        if (programArgument != null) {
            programArgument.setArgument_position(n);
        }
    }

    public List<ProgramArgument> getExecutableArguments() {
        return this.executable_arguments;
    }

    public List<ProgramArgument> getStoredProcedureArguments() {
        return this.storedProcedure_arguments;
    }

    public List<ProgramArgument> getRemoteStoredProcedureArguments() {
        return this.remoteStoredProcedure_arguments;
    }

    public static List<String> getExecutable_argument_types() {
        return executable_argument_types;
    }

    public static List<String> getInOutList() {
        return inOutList;
    }

    void setArgumentName(ProgramArgument programArgument, String string) {
        if (programArgument != null) {
            if (string.length() == 0) {
                programArgument.setArgument_name(null);
            } else {
                programArgument.setArgument_name(string);
            }
        }
    }

    void setArgumentType(ProgramArgument programArgument, String string) {
        if (programArgument != null && string != null) {
            programArgument.setArgument_type(string);
        }
    }

    void setArgumentDefault(ProgramArgument programArgument, String string) {
        if (programArgument != null) {
            if (string.length() == 0) {
                programArgument.setDefault_value(null);
            } else {
                programArgument.setDefault_value(string);
            }
        }
    }

    void setArgumentInOut(ProgramArgument programArgument, boolean bl) {
        if (programArgument != null) {
            programArgument.setOut_argument(bl);
        }
    }

    public void setOriginalNumberOfArguments(int n) {
        int n2 = this.originalNumberOfArguments;
        this.originalNumberOfArguments = n;
        this.propertyChangeSupport.firePropertyChange(ORIGINAL_NUMBER_OF_ARGUMENTS, n2, n);
    }

    public int getOriginalNumberOfArguments() {
        return this.originalNumberOfArguments;
    }

    private String toLocalProgType(String string) {
        String string2 = null;
        if (string != null) {
            if (string.equals(SQL_PROG_TYPE_EXECUTABLE)) {
                string2 = PROG_TYPE_EXECUTABLE;
            }
            if (string.equals(SQL_PROG_TYPE_PLSQL_BLOCK)) {
                string2 = PROG_TYPE_PLSQL_BLOCK;
            }
            if (string.equals(SQL_PROG_TYPE_STORED_PROCEDURE)) {
                string2 = PROG_TYPE_STORED_PROCEDURE;
            }
        }
        return string2;
    }

    static {
        Method method;
        PROG_TYPE_STORED_PROCEDURE = SchedulerArb.getString("JOB_CREATE_TYPE_STORED_PROCEDURE_BLOCK");
        PROG_TYPE_REMOTE_STORED_PROCEDURE = SchedulerArb.getString("JOB_CREATE_TYPE_REMOTE_STORED_PROCEDURE_BLOCK");
        PROG_TYPE_PLSQL_BLOCK = SchedulerArb.getString("JOB_CREATE_TYPE_PLSQL_BLOCK");
        PROG_TYPE_EXECUTABLE = SchedulerArb.getString("JOB_CREATE_TYPE_EXECUTABLE_BLOCK");
        try {
            method = ProgramPropertyPanelModel.class.getMethod("setModelFromResultSet", ResultSet.class);
        }
        catch (Exception exception) {
            method = null;
        }
        MODEL_UPDATE_METHOD = method;
        try {
            method = ProgramPropertyPanelModel.class.getMethod("setSchemaNameListFromResultSet", ResultSet.class);
        }
        catch (Exception exception) {
            method = null;
        }
        SCHEMA_LIST_UPDATE_METHOD = method;
        try {
            method = ProgramPropertyPanelModel.class.getMethod("setSchemaFromResultSet", ResultSet.class);
        }
        catch (Exception exception) {
            method = null;
        }
        SCHEMA_UPDATE_METHOD = method;
        try {
            method = ProgramPropertyPanelModel.class.getMethod("setProgArgsFromResultSet", ResultSet.class);
        }
        catch (Exception exception) {
            method = null;
        }
        PROG_ARGS_UPDATE_METHOD = method;
        try {
            method = ProgramPropertyPanelModel.class.getMethod("setProceduresListFromResultSet", ResultSet.class);
        }
        catch (Exception exception) {
            method = null;
        }
        PROCEDURES_UPDATE_METHOD = method;
        try {
            method = ProgramPropertyPanelModel.class.getMethod("setPkgProceduresListFromResultSet", ResultSet.class);
        }
        catch (Exception exception) {
            method = null;
        }
        PKG_PROCEDURES_UPDATE_METHOD = method;
        try {
            method = ProgramPropertyPanelModel.class.getMethod("setProcedureArgumentsFromResultSet", ResultSet.class);
        }
        catch (Exception exception) {
            method = null;
        }
        PROCEDURE_ARGUMENTS_UPDATE_METHOD = method;
        executable_argument_types = new Vector<String>();
        executable_argument_types.add("CHAR");
        executable_argument_types.add("VARCHAR2");
        executable_argument_types.add("NCHAR");
        executable_argument_types.add("NVARCHAR2");
        inOutList = new Vector<String>();
        inOutList.add("IN");
        inOutList.add("OUT");
    }

    public class ProgramArgument {
        String argument_name = null;
        String argument_type;
        String default_value;
        Boolean out_argument = Boolean.FALSE;
        boolean updated = false;

        public ProgramArgument() {
        }

        public ProgramArgument(ProgramArgument programArgument) {
            this.argument_name = programArgument.argument_name;
            this.argument_type = programArgument.argument_type;
            this.default_value = programArgument.default_value;
            this.out_argument = programArgument.out_argument;
        }

        public void setArgument_position(int n) {
            if (this.getArgument_position() != n && (n >= 0 || n < ProgramPropertyPanelModel.this.getNumber_of_arguments())) {
                this.updated = true;
                int n2 = this.getArgument_position();
                ProgramPropertyPanelModel.this.program_arguments.remove(n2);
                ProgramPropertyPanelModel.this.program_arguments.add(n, this);
                int n3 = Math.min(n, n2);
                int n4 = Math.max(n, n2);
                for (int i = n3; i <= n4; ++i) {
                    ((ProgramArgument)((ProgramPropertyPanelModel)ProgramPropertyPanelModel.this).program_arguments.get((int)i)).updated = true;
                }
                ProgramPropertyPanelModel.this.propertyChangeSupport.firePropertyChange(ProgramPropertyPanelModel.ARGUMENT_POSITION, n2, this.getArgument_position());
            }
        }

        public int getArgument_position() {
            return ProgramPropertyPanelModel.this.program_arguments.indexOf(this);
        }

        public void setArgument_name(String string) {
            this.updated = true;
            String string2 = this.argument_name;
            this.argument_name = string;
            ProgramPropertyPanelModel.this.propertyChangeSupport.firePropertyChange(ProgramPropertyPanelModel.ARGUMENT_NAME, string2, string);
        }

        public String getArgument_name() {
            return this.argument_name;
        }

        public void setArgument_type(String string) {
            this.updated = true;
            String string2 = this.argument_type;
            this.argument_type = string;
            ProgramPropertyPanelModel.this.propertyChangeSupport.firePropertyChange(ProgramPropertyPanelModel.ARGUMENT_TYPE, string2, string);
        }

        public String getArgument_type() {
            return this.argument_type;
        }

        public void setDefault_value(String string) {
            this.updated = true;
            String string2 = this.default_value;
            this.default_value = string;
            ProgramPropertyPanelModel.this.propertyChangeSupport.firePropertyChange(ProgramPropertyPanelModel.DEFAULT_VALUE, string2, string);
        }

        public String getDefault_value() {
            return this.default_value;
        }

        public String getMetadata_attribute_name() {
            if (this.isMetadata_attribute().booleanValue()) {
                return this.default_value.substring(ProgramPropertyPanelModel.METADATA_ATTRIBUTE_PREFIX.length());
            }
            return null;
        }

        public void setOut_argument(Boolean bl) {
            this.updated = true;
            Boolean bl2 = this.out_argument;
            this.out_argument = bl;
            ProgramPropertyPanelModel.this.propertyChangeSupport.firePropertyChange(ProgramPropertyPanelModel.OUT_ARGUMENT, bl2, bl);
        }

        public Boolean isOut_argument() {
            return this.out_argument;
        }

        public Boolean getMetadata_attribute() {
            return this.isMetadata_attribute();
        }

        public Boolean isMetadata_attribute() {
            Boolean bl = this.default_value != null && this.default_value.toUpperCase().startsWith(ProgramPropertyPanelModel.METADATA_ATTRIBUTE_PREFIX);
            return bl;
        }

        public String toString() {
            return "ARG[" + this.argument_name + "," + this.argument_type + "," + this.default_value + "," + this.out_argument + "," + this.getMetadata_attribute() + "]";
        }

        public void setUpdated(boolean bl) {
            this.updated = bl;
        }

        public boolean isUpdated() {
            return this.updated;
        }
    }
}

