/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.program;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.raptor.ui.controls.FilePathActionControlPanel;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.PanelType;
import oracle.dbtools.scheduler.panels.common.LiveValidationController;
import oracle.dbtools.scheduler.panels.program.ProgramArgumentPanel;
import oracle.dbtools.scheduler.panels.program.ProgramEditorPanel;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelController;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelModel;

public class ProgramPropertyPanel
extends JPanel {
    static String currentDir = System.getProperty("user.dir");
    private boolean showSchema = false;
    private ProgramPropertyPanelModel model;
    private boolean refreshing = false;
    private PanelType panelType = PanelType.UPDATE;
    private ModelPropertyChangeListener modelPropertyChangeListener = new ModelPropertyChangeListener();
    private ProgramPropertyPanelController controller;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel nameLabel = new JLabel();
    private JTextField nameTextField = new JTextField();
    private LiveValidationController nameValidationController = new LiveValidationController(this.nameTextField);
    private JLabel descriptionLabel = new JLabel();
    private JTextField descriptionTextField = new JTextField();
    private JLabel schemasLabel = new JLabel();
    private JComboBox schemaComboBox = new JComboBox();
    private JTextField schemaTextField = new JTextField();
    private Set<String> ignoreNotificationList = new TreeSet<String>();
    private CardLayoutPanel<JComponent> programTypeCardLayoutPanel = null;
    private ProgramEditorPanel plsqlBlockScrollPane = new ProgramEditorPanel("x.pls");
    private JPanel storedProcedurePanel = new JPanel();
    private JPanel remoteStoredProcedurePanel = new JPanel();
    private JPanel executablePanel = new JPanel();
    private JCheckBox enabledCheckBox = new JCheckBox();
    private JLabel enabledLabel = new JLabel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JLabel executableLabel = new JLabel();
    private FilePathActionControlPanel executableChooserTextField;
    private ProgramArgumentPanel exeProgramArgumentPanel = new ProgramArgumentPanel(null);
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private GridBagLayout gridBagLayout4 = new GridBagLayout();
    private JComboBox storedProcedureSchemaComboBox = new JComboBox();
    private JLabel storedProcedureSchemaLabel = new JLabel();
    private JLabel storedProcedureNameLabel = new JLabel();
    private JLabel remoteStoredProcedureNameLabel = new JLabel();
    private JComboBox storedProcedureNameComboBox = new JComboBox();
    private JTextField storedProcedureNameTextField = new JTextField();
    private JTextField remoteStoredProcedureNameTextField = new JTextField();
    private transient DocumentListener remoteStoredProcedureNameTextFieldDocumentListener = null;
    private JTextField storedProcedureSchemaTextField = new JTextField();
    private ProgramArgumentPanel storedProcedureArgumentPanel = new ProgramArgumentPanel(null);
    private ProgramArgumentPanel remoteStoredProcedureArgumentPanel = new ProgramArgumentPanel(null);
    private JLabel storedProcArgsLabel = new JLabel();
    private JLabel remoteStoredProcArgsLabel = new JLabel();
    private JLabel exeProgArgLabel = new JLabel();
    private transient StoredProcedureNameComboBoxActionListener storedProcedureNameComboBoxActionListener = new StoredProcedureNameComboBoxActionListener();
    private transient StoredProcedureSchemaComboBoxActionListener storedProcedureSchemaComboBoxActionListener = new StoredProcedureSchemaComboBoxActionListener();

    private ProgramPropertyPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ProgramPropertyPanel(PanelType panelType, ProgramPropertyPanelModel programPropertyPanelModel, ProgramPropertyPanelController programPropertyPanelController) {
        this();
        this.setPanelType(panelType);
        this.setController(programPropertyPanelController);
        this.setModel(programPropertyPanelModel);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setName("programPropertyPanel");
        this.nameTextField.setName("nameTextField");
        this.descriptionTextField.setName("descriptionTextField");
        this.schemaTextField.setName("schemaTextField");
        this.schemaComboBox.setName("schemaComboBox");
        this.enabledCheckBox.setName("enabledCheckBox");
        this.nameLabel.setName("nameLabel");
        this.nameTextField.setName("nameTextField");
        this.descriptionLabel.setName("descriptionLabel");
        this.descriptionTextField.setName("descriptionTextField");
        this.schemasLabel.setName("schemasLabel");
        this.storedProcedureNameComboBox.setName("storedProcedureNameComboBox");
        this.storedProcedureSchemaTextField.setName("storedProcedureSchemaTextField");
        this.plsqlBlockScrollPane.setName("plsqlBlockScrollPane");
        this.storedProcedurePanel.setName("storedProcedurePanel");
        this.remoteStoredProcedurePanel.setName("remoteStoredProcedurePanel");
        this.executablePanel.setName("executablePanel");
        this.enabledCheckBox.setName("enabledCheckBox");
        this.executableLabel.setName("executableLabel");
        this.exeProgramArgumentPanel.setName("exeProgramArgumentPanel");
        this.storedProcedureSchemaLabel.setName("storedProcedureSchemaLabel");
        this.storedProcedureArgumentPanel.setName("storedProcedureArgumentPanel");
        this.remoteStoredProcedureArgumentPanel.setName("remoteStoredProcedureArgumentPanel");
        this.storedProcedureNameLabel.setName("storedProcedureNameLabel");
        this.remoteStoredProcedureNameLabel.setName("remoteStoredProcedureNameLabel");
        this.storedProcArgsLabel.setName("storedProcArgsLabel");
        this.remoteStoredProcArgsLabel.setName("remoteStoredProcArgsLabel");
        this.storedProcedureSchemaComboBox.setName("storedProcedureSchemaComboBox");
        this.storedProcedureNameComboBox.setName("storedProcedureNameComboBox");
        this.storedProcedureNameTextField.setName("storedProcedureNameTextField");
        this.exeProgramArgumentPanel.setType(ProgramPropertyPanelModel.PROG_TYPE_EXECUTABLE);
        this.storedProcedureArgumentPanel.setType(ProgramPropertyPanelModel.PROG_TYPE_STORED_PROCEDURE);
        this.remoteStoredProcedureArgumentPanel.setType(ProgramPropertyPanelModel.PROG_TYPE_REMOTE_STORED_PROCEDURE);
        this.storedProcedureSchemaLabel.setText(SchedulerArb.getString("PROGRAMPANEL_STORED_PROCEDURE_SCHEMA_LABEL"));
        this.storedProcedureNameLabel.setText(SchedulerArb.getString("PROGRAMPANEL_STORED_PROCEDURE_NAME_LABEL"));
        this.remoteStoredProcedureNameLabel.setText(SchedulerArb.getString("PROGRAMPANEL_STORED_PROCEDURE_NAME_LABEL"));
        this.schemaComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProgramPropertyPanel.this.schemasComboBox_actionPerformed(actionEvent);
            }
        });
        this.storedProcedureSchemaComboBox.addActionListener(this.storedProcedureSchemaComboBoxActionListener);
        this.nameLabel.setText(SchedulerArb.getString("PROGRAMPANEL_NAME_LABEL"));
        this.nameLabel.setLabelFor(this.nameTextField);
        this.descriptionLabel.setText(SchedulerArb.getString("PROGRAMPANEL_DESC_LABEL"));
        this.descriptionLabel.setLabelFor(this.descriptionTextField);
        this.schemasLabel.setText(SchedulerArb.getString("PROGRAMPANEL_SCHEMA_LABEL"));
        this.schemaTextField.setEditable(false);
        this.schemaTextField.setColumns(30);
        this.storedProcedurePanel.setLayout(this.gridBagLayout3);
        this.storedProcedureNameTextField.setColumns(30);
        this.remoteStoredProcedurePanel.setLayout(this.gridBagLayout4);
        this.remoteStoredProcedureNameTextField.setColumns(45);
        this.executablePanel.setLayout(this.gridBagLayout2);
        this.enabledCheckBox.setText(SchedulerArb.getString("PROGRAMPANEL_ENABLED_TEXT"));
        this.enabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProgramPropertyPanel.this.enabledCheckBox_actionPerformed(actionEvent);
            }
        });
        this.executableLabel.setText(SchedulerArb.getString("PROGRAMPANEL_EXECUTABLE_LABEL"));
        this.executableChooserTextField = new FilePathActionControlPanel("", 0, 0);
        this.executableChooserTextField.setName("executableChooserTextField");
        this.executableChooserTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.executableChooserTextField_documentUpdated(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.executableChooserTextField_documentUpdated(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.executableChooserTextField_documentUpdated(documentEvent);
            }
        });
        this.plsqlBlockScrollPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.plsqlBlockTextArea_documentUpdated(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.plsqlBlockTextArea_documentUpdated(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.plsqlBlockTextArea_documentUpdated(documentEvent);
            }
        });
        this.nameTextField.setEditable(false);
        this.nameTextField.setColumns(30);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.nameTextField_documentUpdated(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.nameTextField_documentUpdated(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.nameTextField_documentUpdated(documentEvent);
            }
        });
        this.descriptionTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.descriptionTextField_documentUpdated(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.descriptionTextField_documentUpdated(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.descriptionTextField_documentUpdated(documentEvent);
            }
        });
        Insets insets = this.nameTextField.getInsets();
        int n = this.nameTextField.getFontMetrics(this.nameTextField.getFont()).charWidth('m');
        int n2 = this.nameTextField.getFontMetrics(this.nameTextField.getFont()).getHeight();
        Dimension dimension = new Dimension(n * 30 + insets.left + insets.right, n2 + insets.bottom + insets.top);
        this.nameTextField.setPreferredSize(dimension);
        this.nameTextField.setMinimumSize(dimension);
        this.schemaTextField.setPreferredSize(dimension);
        this.schemaTextField.setMinimumSize(dimension);
        this.remoteStoredProcedureNameTextFieldDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.remoteStoredProcedureNameTextField_documentUpdated(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.remoteStoredProcedureNameTextField_documentUpdated(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ProgramPropertyPanel.this.remoteStoredProcedureNameTextField_documentUpdated(documentEvent);
            }
        };
        this.remoteStoredProcedureNameTextField.getDocument().addDocumentListener(this.remoteStoredProcedureNameTextFieldDocumentListener);
        this.storedProcedureSchemaTextField.setPreferredSize(dimension);
        this.storedProcedureSchemaTextField.setMinimumSize(dimension);
        dimension = new Dimension(n * 60 + insets.left + insets.right, n2 + insets.bottom + insets.top);
        this.storedProcedureNameComboBox.setPreferredSize(dimension);
        this.storedProcedureNameComboBox.setMinimumSize(dimension);
        this.storedProcedureNameTextField.setPreferredSize(dimension);
        this.storedProcedureNameTextField.setMinimumSize(dimension);
        this.remoteStoredProcedureNameTextField.setPreferredSize(dimension);
        this.remoteStoredProcedureNameTextField.setMinimumSize(dimension);
        this.storedProcedureNameComboBox.setEditable(true);
        this.storedProcedureNameComboBox.addActionListener(this.storedProcedureNameComboBoxActionListener);
        this.storedProcArgsLabel.setText(SchedulerArb.getString("PROGRAMPANEL_ARGUMENTS_LABEL"));
        this.remoteStoredProcArgsLabel.setText(SchedulerArb.getString("PROGRAMPANEL_ARGUMENTS_LABEL"));
        this.exeProgArgLabel.setText(SchedulerArb.getString("PROGRAMPANEL_ARGUMENTS_LABEL"));
        this.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        if (this.showSchema) {
            this.add((Component)this.schemaTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.schemasLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        }
        this.add((Component)this.enabledLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.enabledCheckBox, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.descriptionLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.descriptionTextField, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.storedProcedurePanel.add((Component)this.storedProcedureSchemaComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.storedProcedurePanel.add((Component)this.storedProcedureNameComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.storedProcedurePanel.add((Component)this.storedProcedureSchemaLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.storedProcedurePanel.add((Component)this.storedProcedureNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.storedProcedurePanel.add((Component)this.storedProcedureArgumentPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.storedProcedurePanel.add((Component)this.storedProcArgsLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.remoteStoredProcedurePanel.add((Component)this.remoteStoredProcedureNameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.remoteStoredProcedurePanel.add((Component)this.remoteStoredProcedureNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.remoteStoredProcedurePanel.add((Component)this.remoteStoredProcedureArgumentPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.remoteStoredProcedurePanel.add((Component)this.remoteStoredProcArgsLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.executablePanel.add((Component)this.executableLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.executablePanel.add((Component)this.executableChooserTextField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.executablePanel.add((Component)this.exeProgramArgumentPanel, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.executablePanel.add((Component)this.exeProgArgLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.enabledLabel.setText(SchedulerArb.getString("PROGRAMPANEL_ENABLED_LABEL"));
        Hashtable<String, JComponent> hashtable = new Hashtable<String, JComponent>();
        hashtable.put(ProgramPropertyPanelModel.PROG_TYPE_PLSQL_BLOCK, this.plsqlBlockScrollPane);
        hashtable.put(ProgramPropertyPanelModel.PROG_TYPE_STORED_PROCEDURE, this.storedProcedurePanel);
        hashtable.put(ProgramPropertyPanelModel.PROG_TYPE_REMOTE_STORED_PROCEDURE, this.remoteStoredProcedurePanel);
        hashtable.put(ProgramPropertyPanelModel.PROG_TYPE_EXECUTABLE, this.executablePanel);
        this.programTypeCardLayoutPanel = new CardLayoutPanel(hashtable, SchedulerArb.get("PROGRAMPANEL_PROG_TYPE_LABEL"), CardLayoutPanel.Type.TITLE_BORDER);
        this.programTypeCardLayoutPanel.setName("programTypeCardLayoutPanel");
        this.programTypeCardLayoutPanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ProgramPropertyPanel.this.programTypeCardLayoutPane_stateChanged(null);
            }
        });
        this.add((Component)this.programTypeCardLayoutPanel, new GridBagConstraints(0, 4, 3, 1, 0.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
    }

    public void setController(ProgramPropertyPanelController programPropertyPanelController) {
        this.controller = programPropertyPanelController;
        this.exeProgramArgumentPanel.setController(programPropertyPanelController);
        this.storedProcedureArgumentPanel.setController(programPropertyPanelController);
        this.remoteStoredProcedureArgumentPanel.setController(programPropertyPanelController);
    }

    public void setModel(ProgramPropertyPanelModel programPropertyPanelModel) {
        if (this.model != null) {
            this.model.removePropertyChangeListener(this.modelPropertyChangeListener);
        }
        this.model = programPropertyPanelModel;
        if (this.model != null) {
            this.model.addPropertyChangeListener(this.modelPropertyChangeListener);
        }
        this.refresh();
        this.exeProgramArgumentPanel.setModel(programPropertyPanelModel);
        this.exeProgramArgumentPanel.setArguments(programPropertyPanelModel.getExecutableArguments());
        this.storedProcedureArgumentPanel.setModel(programPropertyPanelModel);
        this.storedProcedureArgumentPanel.setArguments(programPropertyPanelModel.getStoredProcedureArguments());
        this.remoteStoredProcedureArgumentPanel.setModel(programPropertyPanelModel);
        this.remoteStoredProcedureArgumentPanel.setArguments(programPropertyPanelModel.getRemoteStoredProcedureArguments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPanelType(PanelType panelType) {
        try {
            if (this.panelType != panelType) {
                switch (this.panelType) {
                    case CREATE: {
                        this.remove(this.schemaComboBox);
                        this.storedProcedurePanel.remove(this.storedProcedureNameComboBox);
                        this.storedProcedurePanel.remove(this.storedProcedureSchemaComboBox);
                        break;
                    }
                    case UPDATE: {
                        this.remove(this.schemaTextField);
                        this.storedProcedurePanel.remove(this.storedProcedureNameComboBox);
                        this.storedProcedurePanel.remove(this.storedProcedureSchemaComboBox);
                        break;
                    }
                    case VIEW: {
                        this.remove(this.schemaTextField);
                        this.storedProcedurePanel.remove(this.storedProcedureNameTextField);
                        this.storedProcedurePanel.remove(this.storedProcedureSchemaTextField);
                    }
                }
                switch (panelType) {
                    case UPDATE: {
                        this.nameTextField.setEditable(false);
                        this.schemaTextField.setEditable(false);
                        this.descriptionTextField.setEditable(true);
                        this.enabledCheckBox.setEnabled(true);
                        this.plsqlBlockScrollPane.setEnabled(true);
                        this.plsqlBlockScrollPane.setEditable(true);
                        this.programTypeCardLayoutPanel.setEnabled(true);
                        this.executableChooserTextField.setEditable(true);
                        if (this.showSchema) {
                            this.add((Component)this.schemaTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
                        }
                        this.storedProcedurePanel.add((Component)this.storedProcedureSchemaComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                        this.storedProcedurePanel.add((Component)this.storedProcedureNameComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                        break;
                    }
                    case CREATE: {
                        this.nameTextField.setEditable(true);
                        this.descriptionTextField.setEditable(true);
                        this.enabledCheckBox.setEnabled(true);
                        this.plsqlBlockScrollPane.setEnabled(true);
                        this.plsqlBlockScrollPane.setEditable(true);
                        this.programTypeCardLayoutPanel.setEnabled(true);
                        this.executableChooserTextField.setEditable(true);
                        if (this.showSchema) {
                            this.add((Component)this.schemaComboBox, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
                        }
                        this.storedProcedurePanel.add((Component)this.storedProcedureSchemaComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                        this.storedProcedurePanel.add((Component)this.storedProcedureNameComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                        break;
                    }
                    case VIEW: {
                        this.nameTextField.setEditable(false);
                        this.schemaTextField.setEditable(false);
                        this.descriptionTextField.setEditable(false);
                        this.enabledCheckBox.setEnabled(false);
                        this.plsqlBlockScrollPane.setEnabled(true);
                        this.plsqlBlockScrollPane.setEditable(false);
                        this.programTypeCardLayoutPanel.setEnabled(false);
                        this.storedProcedureSchemaTextField.setEditable(false);
                        this.storedProcedureNameTextField.setEditable(false);
                        this.executableChooserTextField.setEditable(false);
                        if (this.showSchema) {
                            this.add((Component)this.schemaTextField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
                        }
                        this.storedProcedurePanel.add((Component)this.storedProcedureSchemaTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                        this.storedProcedurePanel.add((Component)this.storedProcedureNameTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                    }
                }
                this.panelType = panelType;
            }
            this.exeProgramArgumentPanel.setPanelType(panelType);
            this.storedProcedureArgumentPanel.setPanelType(panelType);
            this.remoteStoredProcedureArgumentPanel.setPanelType(panelType);
        }
        finally {
            this.validate();
        }
    }

    private void selectProgramType(String string) {
        if (string == null || string.equalsIgnoreCase(ProgramPropertyPanelModel.PROG_TYPE_PLSQL_BLOCK)) {
            this.programTypeCardLayoutPanel.setSelectedItem((Object)ProgramPropertyPanelModel.PROG_TYPE_PLSQL_BLOCK);
        } else if (string.equalsIgnoreCase(ProgramPropertyPanelModel.PROG_TYPE_STORED_PROCEDURE)) {
            this.programTypeCardLayoutPanel.setSelectedItem((Object)ProgramPropertyPanelModel.PROG_TYPE_STORED_PROCEDURE);
        } else if (string.equalsIgnoreCase(ProgramPropertyPanelModel.PROG_TYPE_REMOTE_STORED_PROCEDURE)) {
            this.programTypeCardLayoutPanel.setSelectedItem((Object)ProgramPropertyPanelModel.PROG_TYPE_REMOTE_STORED_PROCEDURE);
        } else if (string.equalsIgnoreCase(ProgramPropertyPanelModel.PROG_TYPE_EXECUTABLE)) {
            this.programTypeCardLayoutPanel.setSelectedItem((Object)ProgramPropertyPanelModel.PROG_TYPE_EXECUTABLE);
        } else {
            this.programTypeCardLayoutPanel.setSelectedItem((Object)ProgramPropertyPanelModel.PROG_TYPE_PLSQL_BLOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void refresh() {
        if (this.model == null) {
            this.nameTextField.setText("");
            this.descriptionTextField.setText("");
            this.enabledCheckBox.setSelected(true);
            this.schemaTextField.setText("");
            this.schemaComboBox.removeAllItems();
            this.executableChooserTextField.setPath("");
            this.plsqlBlockScrollPane.setText("");
            this.storedProcedureNameComboBox.removeAllItems();
            this.storedProcedureNameTextField.setText("");
            this.storedProcedureSchemaComboBox.removeAllItems();
            this.storedProcedureSchemaTextField.setText("");
            this.selectProgramType(null);
            return;
        }
        ProgramPropertyPanelModel programPropertyPanelModel = this.model;
        // MONITORENTER : programPropertyPanelModel
        this.refreshing = true;
        try {
            this.nameTextField.setText(this.model.getProgram_name());
            this.descriptionTextField.setText(this.model.getComments());
            this.enabledCheckBox.setSelected(this.model.getEnabled());
            this.schemaTextField.setText(this.model.getOwner());
            this.plsqlBlockScrollPane.setText(this.model.getPlsql_block());
            this.selectProgramType(this.model.getProgram_type());
            this.executableChooserTextField.setPath(this.model.getExecutablePath());
            this.schemaComboBox.removeAllItems();
            this.storedProcedureNameComboBox.removeAllItems();
            this.storedProcedureNameTextField.setText(this.model.getStoredProcName());
            this.storedProcedureSchemaComboBox.removeAllItems();
            this.storedProcedureSchemaTextField.setText(this.model.getStoredProcSchema());
            this.storedProcedureNameComboBox.removeActionListener(this.storedProcedureNameComboBoxActionListener);
            this.storedProcedureSchemaComboBox.removeActionListener(this.storedProcedureSchemaComboBoxActionListener);
            try {
                DefaultComboBoxModel<Object> defaultComboBoxModel;
                List<String> list = this.model.getSchemasList();
                if (list != null) {
                    defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
                    this.schemaComboBox.setModel(defaultComboBoxModel);
                    defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
                    this.storedProcedureSchemaComboBox.setModel(defaultComboBoxModel);
                }
                if ((list = this.model.getProceduresList()) != null) {
                    defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
                    this.storedProcedureNameComboBox.setModel(defaultComboBoxModel);
                }
                defaultComboBoxModel = this.model.getStoredProcName();
                this.schemaComboBox.setSelectedItem(this.model.getOwner());
                this.storedProcedureNameComboBox.setSelectedItem(defaultComboBoxModel == null ? "" : defaultComboBoxModel);
                this.storedProcedureSchemaComboBox.setSelectedItem(this.model.getStoredProcSchema());
                this.storedProcedureNameComboBox.addActionListener(this.storedProcedureNameComboBoxActionListener);
                this.storedProcedureSchemaComboBox.addActionListener(this.storedProcedureSchemaComboBoxActionListener);
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                this.storedProcedureNameComboBox.addActionListener(this.storedProcedureNameComboBoxActionListener);
                this.storedProcedureSchemaComboBox.addActionListener(this.storedProcedureSchemaComboBoxActionListener);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nameTextField_documentUpdated(DocumentEvent documentEvent) {
        if (this.model != null && this.controller != null) {
            ProgramPropertyPanelModel programPropertyPanelModel = this.model;
            synchronized (programPropertyPanelModel) {
                if (!this.refreshing) {
                    this.ignoreNotificationList.add("program_name");
                    try {
                        this.controller.setProgram_name(this.nameTextField.getText());
                    }
                    finally {
                        this.ignoreNotificationList.remove("program_name");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void descriptionTextField_documentUpdated(DocumentEvent documentEvent) {
        if (this.model != null && this.controller != null) {
            ProgramPropertyPanelModel programPropertyPanelModel = this.model;
            synchronized (programPropertyPanelModel) {
                if (!this.refreshing) {
                    this.ignoreNotificationList.add("comments");
                    try {
                        this.controller.setDescription(this.descriptionTextField.getText());
                    }
                    finally {
                        this.ignoreNotificationList.remove("comments");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schemasComboBox_actionPerformed(ActionEvent actionEvent) {
        if (this.model != null && this.controller != null) {
            ProgramPropertyPanelModel programPropertyPanelModel = this.model;
            synchronized (programPropertyPanelModel) {
                if (!this.refreshing) {
                    this.ignoreNotificationList.add("owner");
                    try {
                        if (this.schemaComboBox.getSelectedIndex() == 0) {
                            this.controller.setOwner(null);
                        } else {
                            this.controller.setOwner((String)this.schemaComboBox.getSelectedItem());
                        }
                    }
                    finally {
                        this.ignoreNotificationList.remove("owner");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enabledCheckBox_actionPerformed(ActionEvent actionEvent) {
        if (this.model != null && this.controller != null) {
            ProgramPropertyPanelModel programPropertyPanelModel = this.model;
            synchronized (programPropertyPanelModel) {
                if (!this.refreshing) {
                    this.ignoreNotificationList.add("enabled");
                    try {
                        this.controller.setEnabled(this.enabledCheckBox.isSelected());
                    }
                    finally {
                        this.ignoreNotificationList.remove("enabled");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storedProcedureSchemaTextField_documentUpdated(DocumentEvent documentEvent) {
        if (this.model != null && this.controller != null) {
            ProgramPropertyPanelModel programPropertyPanelModel = this.model;
            synchronized (programPropertyPanelModel) {
                if (!this.refreshing) {
                    this.ignoreNotificationList.add("stored_procedure");
                    this.ignoreNotificationList.add("program_action");
                    try {
                        this.controller.setStoredProcSchema(this.storedProcedureSchemaTextField.getText());
                    }
                    finally {
                        this.ignoreNotificationList.remove("stored_procedure");
                        this.ignoreNotificationList.remove("program_action");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void plsqlBlockTextArea_documentUpdated(DocumentEvent documentEvent) {
        if (this.model != null && this.controller != null) {
            ProgramPropertyPanelModel programPropertyPanelModel = this.model;
            synchronized (programPropertyPanelModel) {
                if (!this.refreshing) {
                    this.ignoreNotificationList.add("plsql_block");
                    this.ignoreNotificationList.add("program_action");
                    try {
                        this.controller.setPLSQLBlock(this.plsqlBlockScrollPane.getText());
                    }
                    finally {
                        this.ignoreNotificationList.remove("plsql_block");
                        this.ignoreNotificationList.remove("program_action");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteStoredProcedureNameTextField_documentUpdated(DocumentEvent documentEvent) {
        if (this.model != null && this.controller != null) {
            ProgramPropertyPanelModel programPropertyPanelModel = this.model;
            synchronized (programPropertyPanelModel) {
                if (!this.refreshing) {
                    this.ignoreNotificationList.add("remote_stored_procedure");
                    try {
                        this.controller.setRemoteStoredProc(this.remoteStoredProcedureNameTextField.getText());
                    }
                    finally {
                        this.ignoreNotificationList.remove("remote_stored_procedure");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executableChooserTextField_documentUpdated(DocumentEvent documentEvent) {
        if (this.model != null && this.controller != null) {
            ProgramPropertyPanelModel programPropertyPanelModel = this.model;
            synchronized (programPropertyPanelModel) {
                if (!this.refreshing) {
                    this.ignoreNotificationList.add("executable_path");
                    this.ignoreNotificationList.add("program_action");
                    try {
                        this.controller.setExecutablePath(this.executableChooserTextField.getPath());
                    }
                    finally {
                        this.ignoreNotificationList.remove("executable_path");
                        this.ignoreNotificationList.remove("program_action");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storedProcedureSchemaComboBox_actionPerformed(ActionEvent actionEvent) {
        if (this.model != null && this.controller != null) {
            ProgramPropertyPanelModel programPropertyPanelModel = this.model;
            synchronized (programPropertyPanelModel) {
                if (!this.refreshing) {
                    this.ignoreNotificationList.add("stored_procedure");
                    this.ignoreNotificationList.add("stored_procedure_schema");
                    try {
                        this.controller.setStoredProcSchema((String)this.storedProcedureSchemaComboBox.getSelectedItem());
                    }
                    finally {
                        this.ignoreNotificationList.remove("stored_procedure");
                        this.ignoreNotificationList.remove("stored_procedure_schema");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storedProcedureNameComboBox_actionPerformed(ActionEvent actionEvent) {
        if (this.model != null && this.controller != null) {
            ProgramPropertyPanelModel programPropertyPanelModel = this.model;
            synchronized (programPropertyPanelModel) {
                if (!this.refreshing) {
                    this.ignoreNotificationList.add("stored_procedure");
                    try {
                        this.controller.setStoredProcName((String)this.storedProcedureNameComboBox.getSelectedItem());
                    }
                    finally {
                        this.ignoreNotificationList.remove("stored_procedure");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void programTypeCardLayoutPane_stateChanged(ChangeEvent changeEvent) {
        if (this.model != null && this.controller != null) {
            ProgramPropertyPanelModel programPropertyPanelModel = this.model;
            synchronized (programPropertyPanelModel) {
                if (!this.refreshing) {
                    this.ignoreNotificationList.add("program_type");
                    try {
                        String string = (String)this.programTypeCardLayoutPanel.getSelectedItem();
                        this.controller.setProgram_type(string);
                    }
                    finally {
                        this.ignoreNotificationList.remove("program_type");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceProperty(PropertyChangeEvent propertyChangeEvent) {
        block38: {
            try {
                if (this.ignoreNotificationList.contains(propertyChangeEvent.getPropertyName())) {
                    return;
                }
                if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() == null) {
                    return;
                }
                if (propertyChangeEvent.getPropertyName().equals("program_name")) {
                    this.nameTextField.setText((String)propertyChangeEvent.getNewValue());
                    break block38;
                }
                if (propertyChangeEvent.getPropertyName().equals("program_namevalidmsg")) {
                    this.nameValidationController.showError((String)propertyChangeEvent.getNewValue());
                    break block38;
                }
                if (propertyChangeEvent.getPropertyName().equals("owner")) {
                    this.schemaComboBox.setSelectedItem(propertyChangeEvent.getNewValue());
                    this.schemaTextField.setText(propertyChangeEvent.getNewValue() == null ? "" : propertyChangeEvent.getNewValue().toString());
                    break block38;
                }
                if (propertyChangeEvent.getPropertyName().equals("comments")) {
                    this.descriptionTextField.setText((String)propertyChangeEvent.getNewValue());
                    break block38;
                }
                if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                    this.enabledCheckBox.setSelected((Boolean)propertyChangeEvent.getNewValue());
                    break block38;
                }
                if (propertyChangeEvent.getPropertyName().equals("program_action")) break block38;
                if (propertyChangeEvent.getPropertyName().equals("program_type")) {
                    this.selectProgramType((String)propertyChangeEvent.getNewValue());
                    break block38;
                }
                if (propertyChangeEvent.getPropertyName().equals("detached") || propertyChangeEvent.getPropertyName().equals("schedule_limit") || propertyChangeEvent.getPropertyName().equals("priority") || propertyChangeEvent.getPropertyName().equals("weight") || propertyChangeEvent.getPropertyName().equals("max_runs") || propertyChangeEvent.getPropertyName().equals("max_failures") || propertyChangeEvent.getPropertyName().equals("max_run_duration") || propertyChangeEvent.getPropertyName().equals("program_action") || propertyChangeEvent.getPropertyName().equals("number_of_arguments")) break block38;
                if (propertyChangeEvent.getPropertyName().equals("argument_added") || propertyChangeEvent.getPropertyName().equals("argument_cleared") || propertyChangeEvent.getPropertyName().equals("argument_deleted") || propertyChangeEvent.getPropertyName().equals("argument_position")) {
                    if (this.model != null && this.model.getProgram_type() != null) {
                        if (this.model.getProgram_type().equalsIgnoreCase(ProgramPropertyPanelModel.PROG_TYPE_EXECUTABLE)) {
                            this.exeProgramArgumentPanel.serviceProperty(propertyChangeEvent);
                        } else if (this.model.getProgram_type().equalsIgnoreCase(ProgramPropertyPanelModel.PROG_TYPE_STORED_PROCEDURE)) {
                            this.storedProcedureArgumentPanel.serviceProperty(propertyChangeEvent);
                        } else if (this.model.getProgram_type().equalsIgnoreCase(ProgramPropertyPanelModel.PROG_TYPE_REMOTE_STORED_PROCEDURE)) {
                            this.remoteStoredProcedureArgumentPanel.serviceProperty(propertyChangeEvent);
                        }
                    }
                    break block38;
                }
                if (propertyChangeEvent.getPropertyName().equals("plsql_block")) {
                    this.plsqlBlockScrollPane.setText(this.model.getPlsql_block());
                    break block38;
                }
                if (propertyChangeEvent.getPropertyName().equals("executable_path")) {
                    this.executableChooserTextField.setPath((String)propertyChangeEvent.getNewValue());
                    break block38;
                }
                if (propertyChangeEvent.getPropertyName().equals("remote_stored_procedure")) {
                    this.remoteStoredProcedureNameTextField.getDocument().removeDocumentListener(this.remoteStoredProcedureNameTextFieldDocumentListener);
                    try {
                        this.remoteStoredProcedureNameTextField.setText(propertyChangeEvent.getNewValue().toString());
                        break block38;
                    }
                    finally {
                        this.remoteStoredProcedureNameTextField.getDocument().addDocumentListener(this.remoteStoredProcedureNameTextFieldDocumentListener);
                    }
                }
                if (propertyChangeEvent.getPropertyName().equals("stored_procedure")) {
                    this.storedProcedureNameComboBox.removeActionListener(this.storedProcedureNameComboBoxActionListener);
                    this.storedProcedureSchemaComboBox.removeActionListener(this.storedProcedureSchemaComboBoxActionListener);
                    try {
                        String string = this.model.getStoredProcSchema();
                        String string2 = this.model.getStoredProcName();
                        this.storedProcedureNameComboBox.setSelectedItem(string2 == null ? "" : string2);
                        this.storedProcedureNameTextField.setText(string2);
                        if (string == null) {
                            this.storedProcedureSchemaComboBox.setSelectedItem(this.model.getOwner());
                        } else {
                            this.storedProcedureSchemaComboBox.setSelectedItem(string);
                            this.storedProcedureSchemaTextField.setText(string);
                        }
                        break block38;
                    }
                    finally {
                        this.storedProcedureNameComboBox.addActionListener(this.storedProcedureNameComboBoxActionListener);
                        this.storedProcedureSchemaComboBox.addActionListener(this.storedProcedureSchemaComboBoxActionListener);
                    }
                }
                if (propertyChangeEvent.getPropertyName().equals("nls_env")) break block38;
                if (propertyChangeEvent.getPropertyName().equals("schemaList")) {
                    this.schemaComboBox.removeAllItems();
                    this.storedProcedureSchemaComboBox.removeAllItems();
                    List list = (List)propertyChangeEvent.getNewValue();
                    if (list == null) break block38;
                    this.storedProcedureSchemaComboBox.removeActionListener(this.storedProcedureSchemaComboBoxActionListener);
                    try {
                        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
                        this.schemaComboBox.setModel(defaultComboBoxModel);
                        defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
                        this.storedProcedureSchemaComboBox.setModel(defaultComboBoxModel);
                        break block38;
                    }
                    finally {
                        this.storedProcedureSchemaComboBox.addActionListener(this.storedProcedureSchemaComboBoxActionListener);
                    }
                }
                if (!propertyChangeEvent.getPropertyName().equals("procedureList")) break block38;
                this.storedProcedureNameComboBox.removeActionListener(this.storedProcedureNameComboBoxActionListener);
                try {
                    this.storedProcedureNameComboBox.removeAllItems();
                    List list = (List)propertyChangeEvent.getNewValue();
                    if (list != null) {
                        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
                        this.storedProcedureNameComboBox.setModel(defaultComboBoxModel);
                    }
                    if (this.model != null) {
                        this.storedProcedureNameComboBox.setSelectedItem(this.model.getStoredProcName());
                    }
                }
                finally {
                    this.storedProcedureNameComboBox.addActionListener(this.storedProcedureNameComboBoxActionListener);
                }
            }
            catch (Throwable throwable) {
                Logger.getLogger(ProgramPropertyPanel.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
            }
        }
    }

    private class StoredProcedureSchemaComboBoxActionListener
    implements ActionListener {
        private StoredProcedureSchemaComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProgramPropertyPanel.this.storedProcedureSchemaComboBox_actionPerformed(actionEvent);
        }
    }

    private class StoredProcedureNameComboBoxActionListener
    implements ActionListener {
        private StoredProcedureNameComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProgramPropertyPanel.this.storedProcedureNameComboBox_actionPerformed(actionEvent);
        }
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private ModelPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            if (EventQueue.isDispatchThread()) {
                ProgramPropertyPanel.this.serviceProperty(propertyChangeEvent);
            } else {
                try {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProgramPropertyPanel.this.serviceProperty(propertyChangeEvent);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

