/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.newjob;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.scheduler.panels.PanelType;
import oracle.dbtools.scheduler.panels.newjob.NewJobParentPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelController;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModel;

public class NewJobProgramArgumentExecutablePanel
extends NewJobParentPanel
implements LayoutControl {
    private static final boolean DEBUG = false;
    private JButton addButton;
    private JScrollPane argsPositionScrollPane;
    private JTable argsPositionTable;
    private JLabel argumentsLabel;
    private JButton deleteButton;
    private JPanel jobArgPositionPanel;
    private JLabel nameLabel;
    private JTextField programTextField;
    private JPanel topExecPanel;
    String connectionName = null;
    String version = null;
    int serialNumber = 0;

    public NewJobProgramArgumentExecutablePanel(String string, String string2) {
        this.connectionName = string;
        this.version = string2;
        this.initComponents();
    }

    public NewJobProgramArgumentExecutablePanel(PanelType panelType, NewJobPropertyPanelModel newJobPropertyPanelModel, NewJobPropertyPanelController newJobPropertyPanelController, String string, String string2) {
        super(panelType, newJobPropertyPanelModel, newJobPropertyPanelController);
        this.connectionName = string;
        this.version = string2;
        this.initComponents();
        this.refresh();
    }

    private void initComponents() {
        this.topExecPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.programTextField = new JTextField();
        this.argumentsLabel = new JLabel();
        this.jobArgPositionPanel = new JPanel();
        this.argsPositionScrollPane = new JScrollPane();
        this.argsPositionTable = new JTable();
        this.deleteButton = new JButton();
        this.addButton = new JButton();
        this.nameLabel.setText("Name");
        this.programTextField.setName("programTextField");
        this.argumentsLabel.setText("Arguments");
        this.jobArgPositionPanel.add(this.argsPositionScrollPane);
        JobArgumentPositionTableModel jobArgumentPositionTableModel = new JobArgumentPositionTableModel();
        jobArgumentPositionTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                NewJobProgramArgumentExecutablePanel.this.jobArgsPositionTableModelTableChanged(tableModelEvent);
            }
        });
        this.argsPositionTable.setModel(jobArgumentPositionTableModel);
        this.argsPositionTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.argsPositionTable.setName("argsPositionTable");
        this.argsPositionScrollPane.setViewportView(this.argsPositionTable);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobProgramArgumentExecutablePanel.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewJobProgramArgumentExecutablePanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        this.deleteButton.setName("deleteButton");
        this.addButton.setName("addButton");
        this.topExecPanel.setLayout(new GridBagLayout());
        this.topExecPanel.add((Component)this.nameLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        this.topExecPanel.add((Component)this.programTextField, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this.topExecPanel.add((Component)this.argumentsLabel, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.topExecPanel.add((Component)this.argsPositionScrollPane, LayoutControl.GBC.gbc((int)0, (int)2, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.topExecPanel.add((Component)this.addButton, LayoutControl.GBC.gbc((int)0, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this.topExecPanel.add((Component)this.deleteButton, LayoutControl.GBC.gbc((int)1, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.topExecPanel, LayoutControl.GBC.DIALOG_MAIN_PANEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        if (this.model == null) {
            this.programTextField.setText("");
        } else {
            NewJobPropertyPanelModel newJobPropertyPanelModel = this.model;
            synchronized (newJobPropertyPanelModel) {
                this.refreshing = true;
                try {
                    if (this.model.getJobTypeSelection() != null) {
                        if (this.model.getJobTypeSelection().equals(NewJobPropertyPanelModel.JOB_TYPE_EXECUTABLE)) {
                            this.programTextField.setEnabled(true);
                            this.programTextField.setText(this.model.getExecutable());
                            this.programTextField.setEnabled(false);
                        } else {
                            this.programTextField.setEnabled(false);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    this.refreshing = false;
                }
            }
        }
    }

    @Override
    protected void serviceProperty(PropertyChangeEvent propertyChangeEvent) {
        try {
            if (this.ignoreNotificationList.contains(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("set_job_arguments_executable")) {
                this.programTextField.setText(this.model.getExecutable());
                this.programTextField.setEnabled(false);
            } else if (this.model.getJobTypeSelection().equals(NewJobPropertyPanelModel.JOB_TYPE_EXECUTABLE)) {
                this.programTextField.setEnabled(true);
                this.programTextField.setText(this.model.getExecutable());
                this.programTextField.setEnabled(false);
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(NewJobPropertyPanel.class.getName()).log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
        }
    }

    private void jobArgsPositionTableModelTableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getColumn();
        int n2 = tableModelEvent.getFirstRow();
        if (n > -1 && n2 > -1) {
            String string = (String)((DefaultTableModel)this.argsPositionTable.getModel()).getValueAt(n2, n);
            if (n == 0) {
                int n3 = Integer.parseInt(string);
                this.controller.updateJobArgumentAt_ForPosition(n2, n3);
            }
            if (n == 1) {
                this.controller.updateJobArgumentAt_ForValue(n2, string);
            }
        }
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.argsPositionTable.getSelectedRow();
        if (n > 0) {
            ((DefaultTableModel)this.argsPositionTable.getModel()).removeRow(n);
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{"", ""};
        ((DefaultTableModel)this.argsPositionTable.getModel()).addRow(objectArray);
        this.controller.createEmptyJobArgument();
    }

    class JobArgumentPositionTableModel
    extends DefaultTableModel {
        String[] columnHeaders;

        public JobArgumentPositionTableModel() {
            this.columnHeaders = new String[]{"Position", "Value"};
            this.setColumnIdentifiers(this.columnHeaders);
        }

        public JobArgumentPositionTableModel(int n, int n2) {
            super(n, n2);
            this.columnHeaders = new String[]{"Position", "Value"};
            this.setColumnIdentifiers(this.columnHeaders);
        }
    }
}

