/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalContext;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalLocator;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalLocatorImpl;
import oracle.dbtools.scheduler.panels.common.repeatinterval.RepeatIntervalParseException;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseSyntaxHandler;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.RepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Frequency;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ScheduleType;

public class RepeatIntervalController {
    public static final String CLAUSE_SEP_REGEX = "[;]";
    public static final String CLAUSE_NOT_SEP_REGEX = "[^;]";
    public static final String CLAUSE_TAG_REGEX = "[=]";
    public static final String CLAUSE_HEADER_REGEX = "[A-Z]";
    public static final String CLAUSE_TEXT_REGEX = "[^\";]";
    public static final String CLAUSE_REGEX = "((([\"]([^\"]|([\"][\"]))+[\"])|[^\";])+[;]?)";
    public static final String CLAUSE_TYPE_REGEX = "^([A-Z]+[=])";
    protected RepeatIntervalClause[] clauses;
    protected ClauseSyntaxHandler[] syntaxHandlers;
    protected Map<ClauseType, ClauseSyntaxHandler> syntaxHandlerLookup;
    RepeatIntervalModel rim;

    public RepeatIntervalController(RepeatIntervalContext repeatIntervalContext, RepeatIntervalModel repeatIntervalModel) {
        this.rim = repeatIntervalModel;
        this.clauses = repeatIntervalContext.getFactory().getRepeatIntervalClauses(repeatIntervalModel);
        this.syntaxHandlers = new ClauseSyntaxHandler[this.clauses.length];
        this.syntaxHandlerLookup = new HashMap<ClauseType, ClauseSyntaxHandler>();
        int n = 0;
        for (RepeatIntervalClause repeatIntervalClause : this.clauses) {
            ClauseSyntaxHandler clauseSyntaxHandler = repeatIntervalClause.getSyntaxHandler();
            this.syntaxHandlers[n++] = clauseSyntaxHandler;
            this.syntaxHandlerLookup.put(repeatIntervalClause.getClauseType(), clauseSyntaxHandler);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRepeatInterval(String string) throws RepeatIntervalParseException {
        boolean bl = false;
        this.rim.clearAllModels();
        Pattern pattern = Pattern.compile(CLAUSE_REGEX);
        Pattern pattern2 = Pattern.compile(CLAUSE_TYPE_REGEX);
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        RepeatIntervalLocatorImpl repeatIntervalLocatorImpl = new RepeatIntervalLocatorImpl();
        String string2 = "";
        while (matcher.find()) {
            Object object;
            if (n == 0) {
                repeatIntervalLocatorImpl.setColumnNumber(1);
                repeatIntervalLocatorImpl.setLineNumber(1);
            }
            repeatIntervalLocatorImpl.setColumnNumber(repeatIntervalLocatorImpl.getColumnNumber() + string2.length());
            string2 = string.substring(matcher.start(), matcher.end());
            String string3 = string2.endsWith(";") ? string2.substring(0, string2.length() - 1) : string2;
            Matcher matcher2 = pattern2.matcher(string3);
            ClauseType clauseType = null;
            if (matcher2.find()) {
                object = string3.substring(matcher2.start(), matcher2.end() - 1);
                try {
                    clauseType = ClauseType.valueOf((String)object);
                    if (!clauseType.isClauseHeader()) {
                        clauseType = null;
                    } else {
                        if (n != 0 && clauseType == ClauseType.FREQ) {
                            throw new RepeatIntervalParseException(repeatIntervalLocatorImpl, "REPEAT_INTERVAL_EXCEPTION_FREQ_FIRST");
                        }
                        string3 = string3.substring(((String)object).length() + 1);
                    }
                }
                catch (RepeatIntervalParseException repeatIntervalParseException) {
                    throw repeatIntervalParseException;
                }
                catch (Exception exception) {
                    throw new RepeatIntervalParseException((RepeatIntervalLocator)repeatIntervalLocatorImpl, "REPEAT_INTERVAL_EXCEPTION_UNKNOWN_CLAUSE", object);
                }
                if (clauseType == null) {
                    try {
                        ScheduleType scheduleType = ScheduleType.valueOf((String)object);
                        if (!scheduleType.isClauseHeader()) {
                            clauseType = null;
                        }
                        clauseType = ClauseType.EMBEDDEDSCHED;
                    }
                    catch (EnumConstantNotPresentException enumConstantNotPresentException) {
                        throw new RepeatIntervalParseException((RepeatIntervalLocator)repeatIntervalLocatorImpl, "REPEAT_INTERVAL_EXCEPTION_UNKNOWN_CLAUSE", object);
                    }
                }
            } else if (n == 0) {
                clauseType = ClauseType.COMBINEDSCHED;
            }
            if (clauseType != null) {
                object = this.syntaxHandlerLookup.get((Object)clauseType);
                if (object == null) throw new RepeatIntervalParseException((RepeatIntervalLocator)repeatIntervalLocatorImpl, "REPEAT_INTERVAL_EXCEPTION_UNSUPPORTED_CLAUSE", clauseType.toString());
                if (string3.length() <= 0) throw new RepeatIntervalParseException(repeatIntervalLocatorImpl, "REPEAT_INTERVAL_EXCEPTION_SYNTAX");
                object.initialise(string3);
            }
            ++n;
        }
    }

    public StringBuilder buildClause(StringBuilder stringBuilder, String string) {
        if (string == null) {
            string = "";
        }
        Frequency frequency = this.rim.getFreq();
        for (int i = 0; i < this.clauses.length; ++i) {
            RepeatIntervalClause repeatIntervalClause = this.clauses[i];
            ClauseSyntaxHandler clauseSyntaxHandler = this.syntaxHandlers[i];
            if (repeatIntervalClause == null || clauseSyntaxHandler == null) continue;
            ClauseType clauseType = repeatIntervalClause.getClauseType();
            if (frequency == null ? clauseType != ClauseType.COMBINEDSCHED && clauseType != ClauseType.EMBEDDEDSCHED : clauseType == ClauseType.COMBINEDSCHED) continue;
            String string2 = string + clauseType.getClauseHeader();
            if ((stringBuilder = clauseSyntaxHandler.buildClause(stringBuilder, string2)).length() <= 0) continue;
            string = ";";
        }
        return stringBuilder;
    }

    public String getRepeatInterval() {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildClause(stringBuilder, null);
        return stringBuilder.toString();
    }

    public RepeatIntervalClause[] getRepeatIntervalClauses() {
        return (RepeatIntervalClause[])this.clauses.clone();
    }
}

