/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.controls.celleditor.popups.AbstractPopupCellEditor;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OraTIMESTAMPFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.ide.util.ResourceUtils;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;

public class DateTimeCellEditor
extends AbstractPopupCellEditor {
    public static final String TIMESTAMP_STRING_PREFIX = "TO_TIMESTAMP(";
    public static final String TIMESTAMP_STRING_SUFFIX = ")";
    protected DateTimeEditor dateEditor = null;
    protected JButton setTodayButton = new JButton();
    protected JButton setNullButton = new JButton();
    protected JButton setSysdateButton = new JButton();
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected boolean _canChange = false;
    private OraTIMESTAMPFormat tsFormat = null;
    private transient Connection m_conn = null;

    public DateTimeCellEditor() {
    }

    public DateTimeCellEditor(Object object, boolean bl, Connection connection) {
        this._canChange = bl;
        this.m_conn = connection;
        this._canChange = bl;
        if (object == null || object.toString().equals("")) {
            object = new Timestamp(new java.util.Date().getTime());
        } else if (object instanceof DATE) {
            object = ((DATE)object).dateValue();
            object = new Timestamp(((java.util.Date)object).getTime());
        } else {
            try {
                this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraTIMESTAMPFormat();
                String string = object.toString();
                if (string.startsWith(TIMESTAMP_STRING_PREFIX) && string.endsWith(TIMESTAMP_STRING_SUFFIX)) {
                    string = string.substring(TIMESTAMP_STRING_PREFIX.length(), string.length() - TIMESTAMP_STRING_SUFFIX.length());
                }
                String string2 = this.tsFormat.toPattern();
                String string3 = this.convertToSimplifiedDateFormat(string2.toLowerCase(), false);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
                Timestamp timestamp = new Timestamp(simpleDateFormat.parse(string).getTime());
                object = timestamp;
            }
            catch (Exception exception) {
                object = new Timestamp(new java.util.Date().getTime());
            }
        }
        this.createDateTimeEditPanel((Timestamp)object);
    }

    private void createDateTimeEditPanel(Timestamp timestamp) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.createDateEditor(timestamp);
        this.add((Component)this.dateEditor, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(this.getButtonPanel(), gridBagConstraints);
    }

    private void createDateEditor(Timestamp timestamp) {
        try {
            this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_conn)).getOraTIMESTAMPFormat();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (this.tsFormat == null) {
            return;
        }
        String string = this.tsFormat.toPattern().toLowerCase();
        String string2 = this.convertToSimplifiedDateFormat(string, true);
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = new SimpleDateFormat(string2, this.tsFormat.getLocale());
        }
        catch (Exception exception) {
            simpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 0, this.tsFormat.getLocale());
        }
        this.dateEditor = new DateTimeEditor((java.util.Date)timestamp, this.tsFormat.getCalendar(), (DateFormat)simpleDateFormat);
    }

    public JComponent getDefaultComponent() {
        return this.dateEditor;
    }

    protected JPanel getButtonPanel() {
        this.buttonPanel.add((Component)this.getSetTodayButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 5), 0, 0));
        return this.buttonPanel;
    }

    protected JButton getSetTodayButton() {
        ResourceUtils.resButton((AbstractButton)this.setTodayButton, (String)Messages.getString((String)"DateTimeEditPanel.1"));
        this.setTodayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeCellEditor.this.dateEditor.setCalendar(Calendar.getInstance());
            }
        });
        this.setTodayButton.setEnabled(this._canChange);
        return this.setTodayButton;
    }

    protected JButton getSetNullButton() {
        ResourceUtils.resButton((AbstractButton)this.setNullButton, (String)Messages.getString((String)"DateTimeEditPanel.2"));
        this.setNullButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeCellEditor.this.dateEditor.setDate(null);
            }
        });
        return this.setNullButton;
    }

    public Date getDate() {
        return new Date(this.dateEditor.getDate().getTime());
    }

    public Timestamp getTimestamp() {
        long l = this.dateEditor.getCalendar().getTimeInMillis();
        return new Timestamp(l);
    }

    public String getTimestampStr() {
        Calendar calendar = this.dateEditor.getCalendar();
        this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_conn)).getOraTIMESTAMPFormat();
        String string = this.tsFormat.toPattern();
        this.tsFormat.setCalendar(calendar);
        String string2 = this.tsFormat.toPattern();
        String string3 = this.convertToSimplifiedDateFormat(string2.toLowerCase(), false);
        String string4 = this.convertToSimplifiedDateFormat(string2.toLowerCase(), true);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string4);
        String string5 = simpleDateFormat.format(calendar.getTime());
        TimeZone timeZone = calendar.getTimeZone();
        String string6 = timeZone.getDisplayName();
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string3);
        String string7 = simpleDateFormat2.format(calendar.getTime());
        return "TO_TIMESTAMP('" + string7 + "', '" + string2 + "'" + TIMESTAMP_STRING_SUFFIX;
    }

    public Calendar getCalendar() {
        return this.dateEditor.getCalendar();
    }

    public void dismissPopupEditor() {
    }

    public JComponent getComponent() {
        return this;
    }

    public String getHelpTopicId() {
        return "f1_extendeddataedit_html";
    }

    public Object getValue() {
        String string = null;
        if (this.tsFormat == null) {
            this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_conn)).getOraTIMESTAMPFormat();
            if (this.tsFormat == null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy hh.mm.ss a");
                string = simpleDateFormat.format(this.getTimestamp());
                return string.toUpperCase();
            }
            string = this.tsFormat.format(new TIMESTAMP(this.getTimestamp()));
        } else {
            this.tsFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_conn)).getOraTIMESTAMPFormat();
            string = this.tsFormat.format(new TIMESTAMP(this.getTimestamp()));
        }
        return string;
    }

    public boolean isEditable() {
        return this._canChange;
    }

    public boolean isNULL() {
        return false;
    }

    public void setEditable(boolean bl) {
        this._canChange = bl;
    }

    public void setValue(Object object) {
        if (object == null || object.toString().equals("")) {
            object = new Timestamp(new java.util.Date().getTime());
        } else if (object instanceof DATE) {
            object = ((DATE)object).dateValue();
            object = new Timestamp(((java.util.Date)object).getTime());
        } else {
            OraDATEFormat oraDATEFormat = null;
            try {
                oraDATEFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)this.m_conn)).getOraDATEFormat();
                object = oraDATEFormat.parseDATE(object.toString(), new ParsePosition(0)).timestampValue();
                object = new Timestamp(((Timestamp)object).getTime());
            }
            catch (Exception exception) {
                object = new Timestamp(new java.util.Date().getTime());
            }
        }
        this.createDateTimeEditPanel((Timestamp)object);
    }

    public String validateValue() {
        return null;
    }

    public void setConnection(Connection connection) {
        this.m_conn = connection;
    }

    private String convertToSimplifiedDateFormat(String string, boolean bl) {
        String string2 = string;
        if (string2.contains("month")) {
            string2 = string2.replace("month", "MMMMM");
        }
        if (string2.contains("mon")) {
            string2 = string2.replace("mon", "MMM");
        }
        if (string2.contains("mm")) {
            string2 = string2.replace("mm", "MM");
        }
        if (string2.contains("dy")) {
            string2 = string2.replace("dy", "EEE");
        }
        if (string2.contains("day")) {
            string2 = string2.replace("day", "EEE");
        }
        if (string2.contains("ddd")) {
            string2 = string2.replace("ddd", "D");
        }
        if (string2.contains("rr")) {
            string2 = string2.replace("rr", "yy");
        }
        if (string2.contains("syyyy")) {
            string2 = string2.replace("syyyy", "-yyyy");
        }
        if (string2.contains("hh12")) {
            string2 = string2.replace("hh12", "hh");
        }
        if (string2.contains("hh24")) {
            string2 = string2.replace("hh24", "HH");
        }
        if (string2.contains("mi")) {
            string2 = string2.replace("mi", "mm");
        }
        if (string2.contains("a.m.") || string2.contains("am")) {
            string2 = string2.contains("a.m.") ? string2.replace("a.m.", "a") : string2.replace("am", "a");
        }
        if (string2.contains("p.m.") || string2.contains("pm")) {
            string2 = string2.contains("p.m.") ? string2.replace("m.m.", "a") : string2.replace("pm", "a");
        }
        if (string2.contains("ff")) {
            string2 = string2.replace("ff", "S");
        }
        if (string2.contains("tzr")) {
            string2 = string2.replace("tzr", bl ? "z" : "Z");
        }
        return string2;
    }

    public void setPopupDialog(JEWTDialog jEWTDialog) {
    }
}

