/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.oviewer.jobclass;

import java.awt.Component;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import oracle.dbtools.raptor.controls.cellrenderers.ICellRenderer;
import oracle.dbtools.scheduler.SchedulerArb;

public class JobClassCellRenderer
implements ICellRenderer {
    Map<String, String> LogLevelTolocalMap = new Hashtable<String, String>(){
        {
            this.put("FULL", SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FULL"));
            this.put("RUNS", SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_RUNS"));
            this.put("FAILED_RUNS", SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_FAILED_RUNS"));
            this.put("OFF", SchedulerArb.get("JOBCLASS_LOGGING_LEVEL_OFF"));
        }
    };

    public Component getComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = null;
        switch (n) {
            case 0: {
                component = new JTextField(object == null ? null : object.toString());
                component.setEditable(false);
                break;
            }
            case 1: {
                component = this.getListBox(this.getLocalLoggingLevel(object), false, this.LogLevelTolocalMap.values().toArray(new String[0]));
                break;
            }
            case 2: {
                int n3 = 0;
                if (object instanceof Number) {
                    n3 = ((Number)object).intValue();
                } else if (object != null) {
                    try {
                        n3 = Integer.valueOf(object.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        n3 = 0;
                    }
                }
                component = new JSpinner(new SpinnerNumberModel(n3, 0, 1000000, 1));
                break;
            }
            case 3: 
            case 4: {
                component = new JComboBox<Object>(new Object[]{object == null ? "null" : object.toString()});
                break;
            }
            case 5: {
                component = new JTextField(object == null ? null : object.toString());
            }
        }
        return component;
    }

    private Component getListBox(Object object, boolean bl, String ... stringArray) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        if (object != null) {
            jComboBox.setSelectedItem(object.toString().toUpperCase());
        }
        jComboBox.setEditable(bl);
        return jComboBox;
    }

    public String getText(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return null;
    }

    private String getLocalLoggingLevel(Object object) {
        String string = null;
        if (object != null && (string = this.LogLevelTolocalMap.get(object.toString())) == null) {
            string = object.toString();
        }
        return string;
    }
}

