/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.xmlmodel;

import java.awt.geom.Point2D;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineDefinitions;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdge;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeGenerator;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineGraph;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNodeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineObject;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineEdge;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineNode;
import oracle.ide.model.Element;

public class XMLGraphEngineUtils {
    public static void removeEdgesFrom(GraphEngineGraph graphEngineGraph, GraphEngineNode graphEngineNode) {
        Collection<GraphEngineEdge> collection = graphEngineGraph.getEdgesInboundTo(graphEngineNode);
        for (GraphEngineEdge graphEngineEdge : collection) {
            graphEngineGraph.remove(graphEngineEdge);
        }
        collection = graphEngineGraph.getEdgesOutboundFrom(graphEngineNode);
        for (GraphEngineEdge graphEngineEdge : collection) {
            graphEngineGraph.remove(graphEngineEdge);
        }
    }

    public static List<GraphEngineObject> generateEdgesFor(GraphEngineDefinitions graphEngineDefinitions, GraphEngineNode graphEngineNode) {
        List<GraphEngineEdge> list;
        Vector<GraphEngineObject> vector = new Vector<GraphEngineObject>();
        GraphEngineNodeType graphEngineNodeType = graphEngineNode.getType();
        List<GraphEngineEdgeGenerator> list2 = graphEngineDefinitions.getEdgeGeneratorsInboundTo(graphEngineNodeType.getTypeId());
        for (GraphEngineEdgeGenerator graphEngineEdgeGenerator : list2) {
            list = graphEngineEdgeGenerator.generateInboundTo(graphEngineNode);
            if (list == null) continue;
            vector.addAll(list);
        }
        list2 = graphEngineDefinitions.getEdgeGeneratorsOutboundFrom(graphEngineNodeType.getTypeId());
        for (GraphEngineEdgeGenerator graphEngineEdgeGenerator : list2) {
            list = graphEngineEdgeGenerator.generateOutboundFrom(graphEngineNode);
            if (list == null) continue;
            vector.addAll(list);
        }
        return vector;
    }

    public static XMLGraphEngineNode createNode(Element element, GraphEngineGraph graphEngineGraph, GraphEngineNode graphEngineNode, String string, String string2, String string3, String string4, String string5, String string6, Point2D point2D) {
        XMLGraphEngineNode xMLGraphEngineNode = new XMLGraphEngineNode(graphEngineNode);
        GraphEngineNodeType graphEngineNodeType = null;
        if (string2 == null) {
            string2 = string4 != null ? string4 + "." + string5 : string5;
        }
        if (string != null) {
            graphEngineNodeType = graphEngineGraph.getModel().getDefinitions().getNodeDefinition(string);
        }
        String string7 = string4 != null ? (string3 != null && string3.equals(string4) ? string5 : string4 + "." + string5) : string5;
        xMLGraphEngineNode.setElement(element);
        xMLGraphEngineNode.setOwner(string4);
        xMLGraphEngineNode.setName(string5);
        xMLGraphEngineNode.setId(string2);
        xMLGraphEngineNode.setConnectionSchema(string3);
        xMLGraphEngineNode.setNodeType(graphEngineNodeType);
        xMLGraphEngineNode.setLabel(string7);
        xMLGraphEngineNode.setToolTip(string6);
        xMLGraphEngineNode.setLocation(point2D);
        return xMLGraphEngineNode;
    }

    public static XMLGraphEngineEdge createEdge(GraphEngineGraph graphEngineGraph, GraphEngineNode graphEngineNode, String string, String string2, Boolean bl, String string3, String string4, GraphEngineNode graphEngineNode2, GraphEngineNode graphEngineNode3) {
        XMLGraphEngineEdge xMLGraphEngineEdge = new XMLGraphEngineEdge(graphEngineNode);
        GraphEngineEdgeType graphEngineEdgeType = null;
        if (string != null) {
            graphEngineEdgeType = graphEngineGraph.getModel().getDefinitions().getEdgeDefinition(string);
        }
        xMLGraphEngineEdge.setElement(graphEngineNode2.getElement());
        xMLGraphEngineEdge.setId(string2);
        xMLGraphEngineEdge.setEdgeType(graphEngineEdgeType);
        xMLGraphEngineEdge.setLabel(string3);
        xMLGraphEngineEdge.setToolTip(string4);
        xMLGraphEngineEdge.setDirected(bl);
        xMLGraphEngineEdge.setSource(graphEngineNode2);
        xMLGraphEngineEdge.setTarget(graphEngineNode3);
        return xMLGraphEngineEdge;
    }

    public static Element getElement(String string, String string2, String string3, String string4) {
        DatabaseNode databaseNode = null;
        if (string != null && string2 != null && string3 != null && string4 != null) {
            DatabaseNode databaseNode2;
            URL uRL = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string3, (String)string2), (String)string4);
            databaseNode = databaseNode2 = DatabaseNavigatorElementFactory.getObjectNode((URL)uRL);
        }
        return databaseNode;
    }
}

