/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.xmlmodel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineAction;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineDefinitions;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineDrop;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineType;

public abstract class XMLGraphEngineType
implements GraphEngineType {
    protected Map<String, GraphEngineAction> actions = new TreeMap<String, GraphEngineAction>();
    protected Map<String, GraphEngineAction> popupActions = new TreeMap<String, GraphEngineAction>();
    protected List<String> popupOrder = new Vector<String>();
    protected Map<String, GraphEngineDrop> dropActions = new TreeMap<String, GraphEngineDrop>();
    protected GraphEngineDefinitions definitions;
    protected transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private GraphEngineAction externalDropAction = null;
    private boolean externalDropAllowed = false;
    private String toolTip;
    private String typeId;

    public XMLGraphEngineType(GraphEngineDefinitions graphEngineDefinitions) {
        this.definitions = graphEngineDefinitions;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void addAction(GraphEngineAction graphEngineAction) {
        if (graphEngineAction != null && !this.actions.containsKey(graphEngineAction.getId())) {
            this.actions.put(graphEngineAction.getId(), graphEngineAction);
        }
    }

    public void removeAction(GraphEngineAction graphEngineAction) {
        if (graphEngineAction != null && this.actions.containsKey(graphEngineAction.getId())) {
            this.actions.remove(graphEngineAction);
        }
    }

    public void addPopupAction(GraphEngineAction graphEngineAction) {
        if (graphEngineAction != null && !this.popupActions.containsKey(graphEngineAction.getId())) {
            this.popupActions.put(graphEngineAction.getId(), graphEngineAction);
            this.popupOrder.add(graphEngineAction.getId());
        }
    }

    public void removePopupAction(GraphEngineAction graphEngineAction) {
        if (graphEngineAction != null && this.popupActions.containsKey(graphEngineAction.getId())) {
            this.popupActions.remove(graphEngineAction);
            this.popupOrder.remove(graphEngineAction.getId());
        }
    }

    public void addDropAction(GraphEngineDrop graphEngineDrop) {
        if (graphEngineDrop != null && !this.dropActions.containsKey(graphEngineDrop.getDropSourceTypeId())) {
            this.dropActions.put(graphEngineDrop.getDropSourceTypeId(), graphEngineDrop);
        }
    }

    public void removeDropAction(GraphEngineDrop graphEngineDrop) {
        if (graphEngineDrop != null && this.dropActions.containsKey(graphEngineDrop.getDropSourceTypeId())) {
            this.dropActions.remove(graphEngineDrop);
        }
    }

    @Override
    public Map<String, GraphEngineAction> getActions() {
        return Collections.unmodifiableMap(this.actions);
    }

    @Override
    public GraphEngineAction getAction(String string) {
        return this.actions.get(string);
    }

    @Override
    public GraphEngineAction getPopupActions(String string) {
        return this.popupActions.get(string);
    }

    @Override
    public List<GraphEngineAction> getPopupActions() {
        Vector<GraphEngineAction> vector = new Vector<GraphEngineAction>();
        for (String string : this.popupOrder) {
            vector.add(this.popupActions.get(string));
        }
        return Collections.unmodifiableList(vector);
    }

    @Override
    public Map<String, GraphEngineDrop> getDrops() {
        return Collections.unmodifiableMap(this.dropActions);
    }

    @Override
    public GraphEngineDrop getDrop(String string) {
        return this.dropActions.get(string);
    }

    @Override
    public GraphEngineDefinitions getDefinitions() {
        return this.definitions;
    }

    @Override
    public boolean canAcceptDrop(GraphEngineType ... graphEngineTypeArray) {
        if (this.dropActions != null && this.dropActions.size() > 0) {
            for (GraphEngineDrop graphEngineDrop : this.dropActions.values()) {
                if (!graphEngineDrop.canAccept(graphEngineTypeArray)) continue;
                return true;
            }
        }
        return false;
    }

    public void setExternalDropAction(GraphEngineAction graphEngineAction) {
        this.externalDropAction = graphEngineAction;
    }

    @Override
    public GraphEngineAction getExternalDropAction() {
        return this.externalDropAction;
    }

    public void setExternalDropAllowed(boolean bl) {
        this.externalDropAllowed = bl;
    }

    @Override
    public boolean isExternalDropAllowed() {
        return this.externalDropAllowed;
    }

    public void setToolTip(String string) {
        this.toolTip = string;
    }

    @Override
    public String getToolTip() {
        return this.toolTip;
    }

    public void setTypeId(String string) {
        String string2 = this.typeId;
        this.typeId = string;
        this.propertyChangeSupport.firePropertyChange("type", string2, string);
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    public boolean equals(Object object) {
        if (object instanceof GraphEngineType) {
            GraphEngineType graphEngineType = (GraphEngineType)object;
            return this.getTypeId().equals(graphEngineType.getTypeId());
        }
        return false;
    }

    public int hashCode() {
        return this.getTypeId() == null ? super.hashCode() : this.getTypeId().hashCode();
    }
}

