/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.xmlmodel;

import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineGraph;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineObject;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineType;
import oracle.ide.model.Element;

public abstract class XMLGraphEngineObject
implements GraphEngineObject {
    private String label;
    private String style;
    private String id;
    private String toolTip = null;
    private Object data;
    private GraphEngineNode parent;
    private Point2D location;
    private Element element;
    protected transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public XMLGraphEngineObject(GraphEngineNode graphEngineNode) {
        this.parent = graphEngineNode;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setLabel(String string) {
        String string2 = this.label;
        this.label = string;
        this.propertyChangeSupport.firePropertyChange("label", string2, string);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setId(String string) {
        String string2 = this.id;
        this.id = string;
        this.propertyChangeSupport.firePropertyChange("id", string2, string);
    }

    protected abstract String createId();

    @Override
    public String getId() {
        if (this.id == null) {
            this.setId(this.createId());
        }
        return this.id;
    }

    public void setStyle(String string) {
        String string2 = this.style;
        this.style = string;
        this.propertyChangeSupport.firePropertyChange("style", string2, string);
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    public void setData(Object object) {
        Object object2 = this.data;
        this.data = object;
        this.propertyChangeSupport.firePropertyChange("data", object2, object);
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public GraphEngineNode getParent() {
        return this.parent;
    }

    @Override
    public GraphEngineGraph getGraph() {
        return this.getParent().getGraph();
    }

    @Override
    public void setLocation(Point2D point2D) {
        Point2D point2D2 = this.location;
        this.location = point2D;
        this.propertyChangeSupport.firePropertyChange("location", point2D2, point2D);
    }

    @Override
    public Point2D getLocation() {
        return this.location;
    }

    public void setElement(Element element) {
        Element element2 = element;
        this.element = element;
        this.propertyChangeSupport.firePropertyChange("element", element2, element);
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public void setToolTip(String string) {
        String string2 = this.toolTip;
        this.toolTip = string;
        this.propertyChangeSupport.firePropertyChange("tooltip", string2, string);
    }

    @Override
    public String getToolTip() {
        return this.toolTip == null ? this.getType().getToolTip() : this.toolTip;
    }

    public boolean equals(Object object) {
        if (object instanceof GraphEngineObject) {
            GraphEngineObject graphEngineObject = (GraphEngineObject)object;
            GraphEngineType graphEngineType = graphEngineObject.getType();
            if (this.getType() == null && graphEngineType != null || this.getType() != null && (graphEngineType == null || !this.getType().equals(graphEngineType))) {
                return false;
            }
            return this.getId().equals(graphEngineObject.getId());
        }
        return false;
    }

    public int hashCode() {
        return (this.getId() == null ? super.hashCode() : this.getId().hashCode()) + (this.getType() == null ? 0 : this.getType().hashCode());
    }
}

