/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.program;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.editors.common.NameValidationPropertyChangeListener;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.AbstractActionDialogBase;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelController;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelModel;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelModelChangeListener;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelModelTemplateWrapper;
import oracle.dbtools.scheduler.panels.program.ProgramPropertyPanelStoredProcUpdateListener;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.javatools.util.Version;

public abstract class CreateProgramBase
extends AbstractActionDialogBase {
    ProgramPropertyPanelModelChangeListener modelChanges = new ProgramPropertyPanelModelChangeListener();
    ProgramPropertyPanelStoredProcUpdateListener storedProcUpdateListener;
    ProgramPropertyPanelModel model = null;
    DBObject dbObj = null;
    Node node = null;
    ViewerNode viewerNode = null;
    Context ctxt = null;
    String connectionName = null;
    String schema = null;
    String version = null;
    ProgramPropertyPanelModelTemplateWrapper templateModel;
    ProgramPropertyPanelController controller;
    List<String> deleted;
    List<String> added;

    protected abstract JComponent initEditPane();

    protected boolean isCloseOnError() {
        return false;
    }

    @Override
    protected String getObjectType() {
        return "SCHPROGRAM";
    }

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    protected JComponent createEditPane(Connection connection) {
        if (this.model == null) {
            this.model = new ProgramPropertyPanelModel();
            this.model.setProgram_type(ProgramPropertyPanelModel.PROG_TYPE_PLSQL_BLOCK);
            this.controller = new ProgramPropertyPanelController(this.model);
            this.model.addPropertyChangeListener(new NameValidationListener());
            this.templateModel = new ProgramPropertyPanelModelTemplateWrapper();
            this.templateModel.setModel(this.model);
        }
        JComponent jComponent = new JLabel("Failed to create panel");
        try {
            this.ctxt = this.getContext();
            this.node = this.ctxt.getNode();
            if (this.node instanceof ViewerNode) {
                this.viewerNode = (ViewerNode)this.node;
                this.dbObj = this.viewerNode.getDBObject();
            } else {
                this.dbObj = (DBObject)this.ctxt.getProperty("ObjectAction.DBOBJECT");
            }
            if (this.dbObj != null) {
                this.connectionName = this.dbObj.getConnectionName();
                this.schema = this.dbObj.getSchemaName();
                this.version = this.dbObj.getDBVersion();
                this.storedProcUpdateListener = new ProgramPropertyPanelStoredProcUpdateListener(this.connectionName, this.version, this.model);
                if (this.connectionName != null) {
                    jComponent = this.initEditPane();
                }
            }
        }
        catch (Throwable throwable) {
            jComponent = new JTextArea();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            ((JTextArea)jComponent).setText(stringWriter.getBuffer().toString());
            ((JTextArea)jComponent).setEditable(false);
        }
        return jComponent;
    }

    protected void onCommandComplete() {
        if (this.model != null) {
            if (this.storedProcUpdateListener != null) {
                this.model.removePropertyChangeListener(this.storedProcUpdateListener);
            }
            if (this.modelChanges != null) {
                this.model.removePropertyChangeListener(this.modelChanges);
            }
        }
    }

    public boolean isEnabled(Context context) {
        Version version = new Version("10");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }

    private class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return CreateProgramBase.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = dBMSSchedulerCodeGenerator.generate(CreateProgramBase.this.getDBObject().getDBVersion(), "PROGRAM_LIST", null);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            Connection connection = CreateProgramBase.this.getDBObject().getConnection();
            DBUtil.getConnectionResolver().lock(connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                ResultSetWrapper resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string = resultSet.getString("OWNER") + "." + resultSet.getString("PROGRAM_NAME");
                        vector.add(string);
                    }
                }
                finally {
                    resultSetWrapper.close();
                }
            }
            catch (Exception exception) {
                throw new TaskException((Throwable)exception);
            }
            finally {
                DBUtil.getConnectionResolver().unlock(connection);
            }
            return vector;
        }
    }

    private class NameValidationListener
    extends NameValidationPropertyChangeListener {
        public NameValidationListener() {
            super("program_name");
        }

        @Override
        protected boolean validateImpl() {
            String string = null;
            String string2 = CreateProgramBase.this.model.getProgram_name();
            if (string2 != null && string2.length() > 0) {
                if (string2.contains("\"")) {
                    string = SchedulerArb.getString("VALIDATION_CANNOT_CONTAIN_DOUBLE_QUOTE");
                } else if (string2.length() > 30) {
                    string = SchedulerArb.getString("VALIDATION_CANNOT_BE_GREATER_THAN_N_BYTES");
                    string = MessageFormat.format(string, 30);
                }
            }
            CreateProgramBase.this.model.setProgram_nameValidMsg(string);
            return string != null;
        }
    }
}

