/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.newjob;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.editors.common.NameValidationPropertyChangeListener;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.AbstractActionDialogBase;
import oracle.dbtools.scheduler.panels.newjob.NewJobModelTemplateWrapper;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelController;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModel;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModelChangeListener;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.javatools.util.Version;

public abstract class NewJobCreateBase
extends AbstractActionDialogBase {
    NewJobPropertyPanelModelChangeListener modelChanges = new NewJobPropertyPanelModelChangeListener();
    NewJobPropertyPanelModel model = new NewJobPropertyPanelModel();
    DBObject dbObj = null;
    Node node = null;
    ViewerNode viewerNode = null;
    Context ctxt = null;
    String connectionName = null;
    String schema = null;
    String version = null;
    NewJobPropertyPanelController controller = new NewJobPropertyPanelController(this.model);
    NewJobModelTemplateWrapper templateModel;
    List<String> deleted;
    List<String> added;

    public NewJobCreateBase() {
        this.model.addPropertyChangeListener(new NameValidationListener());
        this.templateModel = new NewJobModelTemplateWrapper();
        this.templateModel.setModel(this.model);
    }

    protected abstract JComponent initEditPane(Connection var1, CustomTabbedPane var2);

    protected abstract JComponent initEditPane_ProgramArguments(String var1, String var2);

    protected abstract JComponent initEditPane_AdvancedProperties();

    protected abstract JComponent initEditPane_Destination(Connection var1);

    protected abstract JComponent initEditPane_EmailNotification();

    @Override
    protected DatabaseQueryTask<List<String>> getListTask() {
        return new ListTask();
    }

    @Override
    protected String getObjectType() {
        return "SCHNEWJOB";
    }

    protected JComponent createEditPane(Connection connection) {
        JComponent jComponent = new JLabel("Failed to create panel");
        try {
            this.ctxt = this.getContext();
            this.node = this.ctxt.getNode();
            if (this.node instanceof ViewerNode) {
                this.viewerNode = (ViewerNode)this.node;
                this.dbObj = this.viewerNode.getDBObject();
            } else {
                this.dbObj = (DBObject)this.ctxt.getProperty("ObjectAction.DBOBJECT");
            }
            if (this.dbObj != null) {
                this.connectionName = this.dbObj.getConnectionName();
                this.schema = this.dbObj.getSchemaName();
                this.version = this.dbObj.getDBVersion();
                if (this.connectionName != null) {
                    jComponent = this.initEditPane(connection, this.getTabbedPane());
                }
            }
        }
        catch (Throwable throwable) {
            jComponent = new JTextArea();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            ((JTextArea)jComponent).setText(stringWriter.getBuffer().toString());
        }
        return jComponent;
    }

    protected void onCommandComplete() {
        if (this.model != null && this.modelChanges != null) {
            this.model.removePropertyChangeListener(this.modelChanges);
        }
    }

    public boolean isEnabled(Context context) {
        Version version = new Version("10");
        return DBUtil.checkVersion((Connection)this.getDBObject().getConnection(), null, (Version)version) && super.isEnabled(context);
    }

    protected JComponent[] createAdditionalPanes(Connection connection) {
        JComponent[] jComponentArray = new JComponent[]{this.createEditPane_Destination(connection), this.createEditPane_ProgramArguments(connection), this.createEditPane_EmailNotification(connection), this.createEditPane_AdvancedProperties(connection)};
        return jComponentArray;
    }

    protected String[] getAdditionalPaneTitles() {
        String[] stringArray = new String[]{SchedulerArb.getString("JOB_CREATE_TAB_DESTINATION"), SchedulerArb.getString("JOB_CREATE_TAB_JOB_ARGUMENTS"), SchedulerArb.getString("JOB_CREATE_TAB_EMAIL_NOTIFICATION"), SchedulerArb.getString("JOB_CREATE_TAB_ADVANCED_PROPERTIES")};
        return stringArray;
    }

    protected JComponent createEditPane_ProgramArguments(Connection connection) {
        JComponent jComponent = new JLabel("Failed to create Program Arguments panel");
        try {
            this.ctxt = this.getContext();
            this.node = this.ctxt.getNode();
            if (this.node instanceof ViewerNode) {
                this.viewerNode = (ViewerNode)this.node;
                this.dbObj = this.viewerNode.getDBObject();
            } else {
                this.dbObj = (DBObject)this.ctxt.getProperty("ObjectAction.DBOBJECT");
            }
            if (this.dbObj != null) {
                this.connectionName = this.dbObj.getConnectionName();
                this.schema = this.dbObj.getSchemaName();
                this.version = this.dbObj.getDBVersion();
                if (this.connectionName != null) {
                    jComponent = this.initEditPane_ProgramArguments(this.connectionName, this.version);
                }
            }
        }
        catch (Throwable throwable) {
            jComponent = new JTextArea();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            ((JTextArea)jComponent).setText(stringWriter.getBuffer().toString());
        }
        return jComponent;
    }

    protected JComponent createEditPane_AdvancedProperties(Connection connection) {
        JComponent jComponent = new JLabel("Failed to create Advanced Properties panel");
        try {
            this.ctxt = this.getContext();
            this.node = this.ctxt.getNode();
            if (this.node instanceof ViewerNode) {
                this.viewerNode = (ViewerNode)this.node;
                this.dbObj = this.viewerNode.getDBObject();
            } else {
                this.dbObj = (DBObject)this.ctxt.getProperty("ObjectAction.DBOBJECT");
            }
            if (this.dbObj != null) {
                this.connectionName = this.dbObj.getConnectionName();
                this.schema = this.dbObj.getSchemaName();
                this.version = this.dbObj.getDBVersion();
                if (this.connectionName != null) {
                    jComponent = this.initEditPane_AdvancedProperties();
                }
            }
        }
        catch (Throwable throwable) {
            jComponent = new JTextArea();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            ((JTextArea)jComponent).setText(stringWriter.getBuffer().toString());
        }
        return jComponent;
    }

    protected JComponent createEditPane_Destination(Connection connection) {
        JComponent jComponent = new JLabel("Failed to create Destination panel");
        try {
            this.ctxt = this.getContext();
            this.node = this.ctxt.getNode();
            if (this.node instanceof ViewerNode) {
                this.viewerNode = (ViewerNode)this.node;
                this.dbObj = this.viewerNode.getDBObject();
            } else {
                this.dbObj = (DBObject)this.ctxt.getProperty("ObjectAction.DBOBJECT");
            }
            if (this.dbObj != null) {
                this.connectionName = this.dbObj.getConnectionName();
                this.schema = this.dbObj.getSchemaName();
                this.version = this.dbObj.getDBVersion();
                if (this.connectionName != null) {
                    jComponent = this.initEditPane_Destination(connection);
                }
            }
        }
        catch (Throwable throwable) {
            jComponent = new JTextArea();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            ((JTextArea)jComponent).setText(stringWriter.getBuffer().toString());
        }
        return jComponent;
    }

    protected JComponent createEditPane_EmailNotification(Connection connection) {
        JComponent jComponent = new JLabel("Failed to create Program Arguments panel");
        try {
            this.ctxt = this.getContext();
            this.node = this.ctxt.getNode();
            if (this.node instanceof ViewerNode) {
                this.viewerNode = (ViewerNode)this.node;
                this.dbObj = this.viewerNode.getDBObject();
            } else {
                this.dbObj = (DBObject)this.ctxt.getProperty("ObjectAction.DBOBJECT");
            }
            if (this.dbObj != null) {
                this.connectionName = this.dbObj.getConnectionName();
                this.schema = this.dbObj.getSchemaName();
                this.version = this.dbObj.getDBVersion();
                if (this.connectionName != null) {
                    jComponent = this.initEditPane_EmailNotification();
                }
            }
        }
        catch (Throwable throwable) {
            jComponent = new JTextArea();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            ((JTextArea)jComponent).setText(stringWriter.getBuffer().toString());
        }
        return jComponent;
    }

    private class ListTask
    extends DatabaseQueryTask<List<String>> {
        public ListTask() {
            super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
        }

        public String getConnectionName() {
            return NewJobCreateBase.this.getDBObject().getConnectionName();
        }

        public String getQuery() {
            DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
            String string = dBMSSchedulerCodeGenerator.generate(NewJobCreateBase.this.getDBObject().getDBVersion(), "JOB_LIST", null);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> doWork() throws TaskException {
            Vector<String> vector = new Vector<String>();
            Connection connection = NewJobCreateBase.this.getDBObject().getConnection();
            DBUtil.getConnectionResolver().lock(connection);
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                ResultSetWrapper resultSetWrapper = dBUtil.executeOracleQuery(this.getQuery(), null);
                try {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        String string = resultSet.getString("OWNER") + "." + resultSet.getString("JOB_NAME");
                        vector.add(string);
                    }
                }
                finally {
                    resultSetWrapper.close();
                }
            }
            catch (Exception exception) {
                throw new TaskException((Throwable)exception);
            }
            finally {
                DBUtil.getConnectionResolver().unlock(connection);
            }
            return vector;
        }
    }

    private class NameValidationListener
    extends NameValidationPropertyChangeListener {
        public NameValidationListener() {
            super("job_name");
        }

        @Override
        protected boolean validateImpl() {
            String string = null;
            String string2 = NewJobCreateBase.this.model.getJobName();
            if (string2 != null && string2.length() > 0) {
                if (string2.contains("\"")) {
                    string = SchedulerArb.getString("VALIDATION_CANNOT_CONTAIN_DOUBLE_QUOTE");
                } else if (string2.length() > 30) {
                    string = SchedulerArb.getString("VALIDATION_CANNOT_BE_GREATER_THAN_N_BYTES");
                    string = MessageFormat.format(string, 30);
                }
            }
            return string != null;
        }
    }
}

