/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.newjob;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentListener;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.CardLayoutActionControl;
import oracle.dbtools.raptor.ui.controls.EditorActionControl;
import oracle.dbtools.raptor.ui.controls.FilePathActionControl;
import oracle.dbtools.raptor.ui.controls.PropertyPanelActionControl;
import oracle.dbtools.raptor.ui.controls.SideBySideActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.ui.panels.CardLayoutPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_Destination;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobCreateActionDialogTab_JobArguments;
import oracle.dbtools.scheduler.dialogs.newjob.NewJobModel;
import oracle.dbtools.scheduler.panels.IdSqlComboBoxActionControl;
import oracle.dbtools.scheduler.panels.newjob.NewJobPropertyPanelModel;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenActionControl;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenModel;
import oracle.javatools.util.ArrayMap;

public class NewJobCreateActionDialogTab_EditProperties
extends ActionDialogTab
implements PropertyChangeListener {
    private NewJobModel model;
    private SqlComboBoxActionControl addChainCtl;
    private ActionControl nameCtl1 = null;
    private ActionControl enabledCtl = null;
    private ActionControl commentsCtl = null;
    private ActionControl jobClassCtl = null;
    private CardLayoutActionControl whatJobCtl = null;
    private SqlComboBoxActionControl addStoredProcedureCtl = null;
    private EditorActionControl plsqlEditorCtl = null;
    private ActionControl addUsersCtl = null;
    private SqlComboBoxActionControl addNamedProgramCtl = null;
    private FilePathActionControl execNameCtl = null;
    protected String schema = null;
    private String job_name_text = "";
    private String jobDescription = null;
    private boolean jobEnabled = true;
    private final String DEFAULT_JOB_CLASS_NAME = "SYS.DEFAULT_JOB_CLASS";
    private final String NULL_JOB_CLASS_NAME = "\"SYS\".\"null\"";
    private String jobClassName = "SYS.DEFAULT_JOB_CLASS";
    private String jobStyle = "REGULAR";
    private String jobAction = "";
    private String nlsJobType = NewJobPropertyPanelModel.JOB_TYPE_PLSQL_BLOCK;
    private String jobType = null;
    private String programName = "";
    private boolean delayLoading = true;
    private Connection conn;
    private String jobActionPlsqlBlock = null;
    private String jobActionChain = "";
    private String jobActionExecutable = "";
    private String jobActionStoredProcedure = "";
    private String jobActionStoredProcedureSchema = "";
    private String jobActionProgramName = "";
    private String programOwner = null;
    private String editScheduleType = "IMMEDIATE";

    public NewJobCreateActionDialogTab_EditProperties(String string, String string2, NewJobModel newJobModel) {
        super(string, string2);
        this.model = newJobModel;
        if (this.model != null && newJobModel.getOperation() != NewJobModel.Operation.CREATE_NEW) {
            if (newJobModel.getOperation() == NewJobModel.Operation.EDIT) {
                this.job_name_text = (String)newJobModel.getPreviousJobData("oldObjectName");
            }
            this.jobEnabled = new Boolean((String)newJobModel.getPreviousJobData("oldEnabled"));
            this.jobDescription = (String)newJobModel.getPreviousJobData("oldComments");
            this.jobClassName = (String)newJobModel.getPreviousJobData("oldJobclass");
            if (this.jobClassName == null || this.jobClassName.equals("\"SYS\".\"null\"")) {
                this.jobClassName = "SYS.DEFAULT_JOB_CLASS";
            }
            this.jobStyle = (String)newJobModel.getPreviousJobData("oldJobStyle");
            this.jobType = (String)newJobModel.getPreviousJobData("oldJobType");
            this.nlsJobType = this.getNLSJobType((String)newJobModel.getPreviousJobData("oldJobType"));
            this.jobAction = (String)newJobModel.getPreviousJobData("oldJobAction");
            this.programName = (String)newJobModel.getPreviousJobData("oldProgramName");
            if (this.programName == null) {
                this.programName = "";
            }
            this.programOwner = (String)newJobModel.getPreviousJobData("oldProgramOwner");
            if (this.jobType == null) {
                if (this.programName.length() > 0) {
                    this.jobActionProgramName = this.programOwner + "." + this.programName;
                }
            } else if (this.jobType.equals("PLSQL_BLOCK")) {
                this.jobActionPlsqlBlock = this.jobAction;
            } else if (this.jobType.equals("CHAIN")) {
                this.jobActionChain = this.jobAction;
            } else if (this.jobType.equals("EXECUTABLE")) {
                this.jobActionExecutable = this.jobAction;
            } else if (this.jobType.equals("STORED_PROCEDURE")) {
                this.jobActionStoredProcedureSchema = this.getSchemaNameInJobAction(this.jobAction);
                this.jobActionStoredProcedure = this.stripSchemaNameInJobAction(this.jobAction);
            }
            this.editScheduleType = (String)newJobModel.getPreviousJobData("oldScheduleType");
            this.delayLoading = newJobModel.getDelayLoadingChoice();
        }
    }

    public List<ActionControl> createControls(Connection connection) {
        Object object;
        String string;
        this.conn = connection;
        this.getCurrentUser(connection);
        if (this.jobActionStoredProcedureSchema.length() == 0) {
            this.jobActionStoredProcedureSchema = this.schema;
        }
        this.nameCtl1 = new TextBoxActionControl("JOB_NAME", SchedulerArb.getString("JOB_CREATE_DETAILS_JOB_NAME_LABEL"), this.job_name_text);
        if (this.model.getOperation() == NewJobModel.Operation.EDIT) {
            this.nameCtl1.setEditable(false);
        } else {
            this.nameCtl1.setEditable(true);
        }
        this.enabledCtl = new BooleanCheckBoxActionControl("ENABLED", SchedulerArb.getString("JOB_CREATE_DETAILS_ENABLED_LABEL"), this.jobEnabled, false);
        this.commentsCtl = new TextBoxActionControl("COMMENTS", SchedulerArb.getString("JOB_CREATE_DETAILS_DESCRIPTION_LABEL"), this.jobDescription);
        String string2 = this.getQuery(connection, "jobCreateGetJobClasses");
        this.jobClassCtl = new IdSqlComboBoxActionControl("JOB_CLASS", SchedulerArb.getString("JOB_CREATE_DETAILS_JOB_CLASS_LABEL"), connection, string2, null, this.jobClassName, true);
        PropertyPanelActionControl propertyPanelActionControl = new PropertyPanelActionControl("WHAT_PANEL", null);
        this.plsqlEditorCtl = new EditorActionControl("WHAT_JOB_TYPE_PANEL_PLSQL_BLOCK", this.jobActionPlsqlBlock, "x.pls");
        propertyPanelActionControl.addChildControls((List)new ArrayList<ActionControl>(){
            {
                this.add(NewJobCreateActionDialogTab_EditProperties.this.plsqlEditorCtl);
            }
        });
        this.execNameCtl = new FilePathActionControl("WHAT_JOB_TYPE_PANEL_EXECUTABLE", SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_ADD_EXECUTABLE"), this.jobActionExecutable, 0);
        PropertyPanelActionControl propertyPanelActionControl2 = new PropertyPanelActionControl("WHAT_EXECUTABLE_PANEL", null);
        ArrayList<FilePathActionControl> arrayList = new ArrayList<FilePathActionControl>();
        arrayList.add(this.execNameCtl);
        propertyPanelActionControl2.addChildControls(arrayList);
        PropertyPanelActionControl propertyPanelActionControl3 = null;
        if (this.model.Feature102()) {
            string = this.getQuery(connection, "getChains");
            this.addChainCtl = new IdSqlComboBoxActionControl("WHAT_JOB_TYPE_PANEL_CHAIN", SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_ADD_CHAIN"), connection, string, null, this.jobActionChain, false, this.delayLoading);
            propertyPanelActionControl3 = new PropertyPanelActionControl("WHAT_CHAIN_PANEL", null);
            object = new ArrayList();
            ((ArrayList)object).add(this.addChainCtl);
            propertyPanelActionControl3.addChildControls((List)object);
        }
        string = this.getQuery(connection, "getPrograms");
        this.addNamedProgramCtl = new IdSqlComboBoxActionControl("WHAT_JOB_TYPE_PANEL_NAMED_PROGRAM", SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_ADD_NAMED_PROGRAM"), connection, string, null, this.jobActionProgramName, true, this.delayLoading);
        object = new PropertyPanelActionControl("WHAT_NAME_PROGRAM_PANEL", null);
        ArrayList<SqlComboBoxActionControl> arrayList2 = new ArrayList<SqlComboBoxActionControl>();
        arrayList2.add(this.addNamedProgramCtl);
        object.addChildControls(arrayList2);
        String string3 = this.getQuery(connection, "jobCreateGetUsers");
        this.addUsersCtl = new SqlComboBoxActionControl("WHAT_JOB_TYPE_PANEL_STORED_PROCEDURE_SCHEMA", SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_ADD_STORED_PROCEDURE_SCHEMA"), connection, string3, null, this.jobActionStoredProcedureSchema, true, this.delayLoading);
        String string4 = this.getQuery(connection, "getStoredProceduresGivenOwner");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.model.setSchemaForStoredProcedure(this.jobActionStoredProcedureSchema);
        hashtable.put("OWNER", this.jobActionStoredProcedureSchema);
        this.addStoredProcedureCtl = new SqlComboBoxActionControl("WHAT_JOB_TYPE_PANEL_STORED_PROCEDURE", SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_ADD_STORED_PROCEDURE_NAME"), connection, string4, hashtable, this.jobActionStoredProcedure, true, this.delayLoading);
        PropertyPanelActionControl propertyPanelActionControl4 = new PropertyPanelActionControl("WHAT_STORED_PROCEDURE_PANEL", null);
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        arrayList3.add(this.addUsersCtl);
        this.addUsersCtl.addPropertyChangeListener((PropertyChangeListener)this);
        arrayList3.add(this.addStoredProcedureCtl);
        propertyPanelActionControl4.addChildControls(arrayList3);
        ArrayMap arrayMap = new ArrayMap();
        arrayMap.put(NewJobPropertyPanelModel.JOB_TYPE_PLSQL_BLOCK, propertyPanelActionControl);
        if (this.model.Feature102()) {
            arrayMap.put(NewJobPropertyPanelModel.JOB_TYPE_CHAIN, propertyPanelActionControl3);
        }
        arrayMap.put(NewJobPropertyPanelModel.JOB_TYPE_STORED_PROCEDURE, propertyPanelActionControl4);
        arrayMap.put(NewJobPropertyPanelModel.JOB_TYPE_NAMED_PROGRAM, object);
        arrayMap.put(NewJobPropertyPanelModel.JOB_TYPE_EXECUTABLE, propertyPanelActionControl2);
        this.whatJobCtl = new CardLayoutActionControl("WHAT_JOB_TYPE_PANEL_NAME", null, CardLayoutPanel.Type.TITLE_BORDER, SchedulerArb.getString("JOB_CREATE_DETAILS_WHAT_PANEL_TITLE"), (Map)arrayMap);
        if (this.model.getOperation() != NewJobModel.Operation.CREATE_NEW) {
            if (this.programName.length() > 0) {
                this.whatJobCtl.setSelected((Object)this.getNLSJobType("NAMED_PROGRAM"));
            } else {
                this.whatJobCtl.setSelected((Object)this.getNLSJobType(this.jobType));
            }
        }
        this.whatJobCtl.getUI().setPreferredSize(new Dimension(313, 196));
        ScheduleWhenActionControl scheduleWhenActionControl = new ScheduleWhenActionControl("WHEN_JOB_TYPE_PANEL_NAME", null, CardLayoutPanel.Type.TITLE_BORDER, SchedulerArb.getString("JOB_CREATE_DETAILS_WHEN_PANEL_TITLE"), ScheduleWhenActionControl.FCOTarget.JOB, connection);
        ScheduleWhenModel scheduleWhenModel = this.model.getWhenModel();
        scheduleWhenModel.doInitialize();
        scheduleWhenActionControl.setModel(scheduleWhenModel);
        this.whatJobCtl.setFillVertical(true);
        scheduleWhenActionControl.setFillVertical(true);
        SideBySideActionControl sideBySideActionControl = new SideBySideActionControl("WHAT_WHEN", null, (ActionControl)this.whatJobCtl, (ActionControl)scheduleWhenActionControl, 4);
        ArrayList<ActionControl> arrayList4 = new ArrayList<ActionControl>();
        arrayList4.add(this.nameCtl1);
        arrayList4.add(this.enabledCtl);
        arrayList4.add(this.commentsCtl);
        arrayList4.add(this.jobClassCtl);
        arrayList4.add((ActionControl)sideBySideActionControl);
        return arrayList4;
    }

    private void print(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        String string2 = ((ActionControl.Value)propertyChangeEvent.getNewValue()).get();
        if (string2 == null) {
            return;
        }
        String string3 = propertyChangeEvent.getSource().getClass().getName();
        if (string.equals("WHAT_JOB_TYPE_PANEL_STORED_PROCEDURE_SCHEMA") && Connections.getInstance().lock(this.conn)) {
            String string4 = string2;
            this.model.setSchemaForStoredProcedure(string4);
            Object var6_6 = null;
            try {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("OWNER", string4);
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
                dBUtil.setRaiseError(true);
                String string5 = this.getQuery(this.conn, "getStoredProceduresGivenOwner");
                this.addStoredProcedureCtl.resetQuery(this.conn, string5, hashtable, "");
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (var6_6 != null) {
                    var6_6.close();
                }
                Connections.getInstance().unlock(this.conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCurrentUser(Connection connection) {
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string = this.getQuery(connection, "jobCreateGetCurrentUser");
                resultSetWrapper = dBUtil.executeOracleQuery(string, null);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    this.setCurrentUserFromResultSet(resultSet);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    private void setCurrentUserFromResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                this.schema = this.getStringFromRS(resultSet, "USER");
            }
        }
    }

    private String getStringFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getString(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void addListener(ActionDialogTab actionDialogTab) {
        if (actionDialogTab instanceof NewJobCreateActionDialogTab_Destination) {
            this.whatJobCtl.addPropertyChangeListener((PropertyChangeListener)actionDialogTab);
        } else if (actionDialogTab instanceof NewJobCreateActionDialogTab_JobArguments) {
            this.addStoredProcedureCtl.addPropertyChangeListener((PropertyChangeListener)actionDialogTab);
            this.addNamedProgramCtl.addPropertyChangeListener((PropertyChangeListener)actionDialogTab);
            this.whatJobCtl.addPropertyChangeListener((PropertyChangeListener)actionDialogTab);
            this.execNameCtl.getUI().addDocumentListener((DocumentListener)actionDialogTab);
            this.execNameCtl.addPropertyChangeListener((PropertyChangeListener)actionDialogTab);
        }
    }

    private String getNLSJobType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("PLSQL_BLOCK")) {
            return NewJobPropertyPanelModel.JOB_TYPE_PLSQL_BLOCK;
        }
        if (string.equals("EXECUTABLE")) {
            return NewJobPropertyPanelModel.JOB_TYPE_EXECUTABLE;
        }
        if (string.equals("STORED_PROCEDURE")) {
            return NewJobPropertyPanelModel.JOB_TYPE_STORED_PROCEDURE;
        }
        if (string.equals("CHAIN")) {
            return NewJobPropertyPanelModel.JOB_TYPE_CHAIN;
        }
        if (string.equals("NAMED_PROGRAM")) {
            return NewJobPropertyPanelModel.JOB_TYPE_NAMED_PROGRAM;
        }
        return null;
    }

    public void setEditOptions() {
        if (this.model.getOperation() != NewJobModel.Operation.CREATE_NEW) {
            if (this.jobType != null) {
                if (this.jobType.equals("PLSQL_BLOCK")) {
                    if (this.plsqlEditorCtl != null) {
                        this.plsqlEditorCtl.set(this.jobActionPlsqlBlock);
                    }
                } else if (this.jobType.equals("CHAIN")) {
                    if (this.addChainCtl != null) {
                        this.addChainCtl.setSelected((Object)this.jobActionChain);
                    }
                } else if (this.jobType.equals("EXECUTABLE")) {
                    this.whatJobCtl.firePropertyChangeListeners(NewJobPropertyPanelModel.JOB_TYPE_EXECUTABLE);
                    if (this.execNameCtl != null) {
                        this.execNameCtl.set(this.jobActionExecutable);
                        this.execNameCtl.firePropertyChangeListeners("WHAT_JOB_TYPE_PANEL_EXECUTABLE");
                    }
                } else if (this.jobType.equals("STORED_PROCEDURE")) {
                    this.whatJobCtl.firePropertyChangeListeners(NewJobPropertyPanelModel.JOB_TYPE_STORED_PROCEDURE);
                    if (this.addStoredProcedureCtl != null) {
                        this.addStoredProcedureCtl.setSelected((Object)this.jobActionStoredProcedure);
                        this.addStoredProcedureCtl.firePropertyChangeListeners("WHAT_JOB_TYPE_PANEL_STORED_PROCEDURE");
                    }
                }
            } else if (this.programName != null && this.programName.trim().length() > 0) {
                this.whatJobCtl.firePropertyChangeListeners(NewJobPropertyPanelModel.JOB_TYPE_NAMED_PROGRAM);
                if (this.addNamedProgramCtl != null) {
                    this.addNamedProgramCtl.setSelected((Object)this.jobActionProgramName);
                    this.addNamedProgramCtl.firePropertyChangeListeners("WHAT_JOB_TYPE_PANEL_NAMED_PROGRAM");
                }
            }
        }
    }

    private String stripSchemaNameInJobAction(String string) {
        if (string.contains(".")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            if (stringTokenizer.countTokens() == 2) {
                stringArray[0] = stringTokenizer.nextToken().trim();
                return this.stripQuotes(stringTokenizer.nextToken().trim());
            }
        } else {
            return this.stripQuotes(string);
        }
        return null;
    }

    private String getSchemaNameInJobAction(String string) {
        if (string.contains(".")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            if (stringTokenizer.countTokens() == 2) {
                stringArray[0] = stringTokenizer.nextToken().trim();
                return this.stripQuotes(stringArray[0]);
            }
        } else {
            return this.stripQuotes(string);
        }
        return null;
    }

    public void initialize(Connection connection) {
        super.initialize(connection);
    }

    private String stripQuotes(String string) {
        String string2 = string;
        if (string.startsWith("\"") && !string.endsWith("\"")) {
            string2 = string.substring(1);
        } else if (!string.startsWith("\"") && string.endsWith("\"")) {
            string2 = string.substring(0, string.length() - 1);
        } else if (string.startsWith("\"") && string.endsWith("\"")) {
            string2 = string.substring(1, string.length() - 1);
        }
        return string2;
    }
}

